/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2;

import com.sun.tools.jxc.SchemaGenerator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.jaxb2.TransformSchema;
import org.codehaus.mojo.jaxb2.helpers.SchemagenHelper;
import org.codehaus.mojo.jaxb2.helpers.SimpleNamespaceResolver;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SingleTargetSourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Scanner;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.sonatype.plexus.build.incremental.DefaultBuildContext;

public abstract class AbstractSchemagenMojo
extends AbstractMojo {
    private static final String SCHEMAGEN_EMITTED_FILENAME = "schema1.xsd";
    @Component
    private BuildContext buildContext;
    @Component
    private MavenProject project;
    @Parameter
    private List<TransformSchema> transformSchemas;
    @Parameter(required=true)
    private Set<String> includes = new HashSet<String>();
    @Parameter
    private Set<String> excludes = new HashSet<String>();
    @Parameter(property="lastModGranularityMs", defaultValue="0")
    private int staleMillis;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.getLog().isDebugEnabled()) {
            Package jaxbImplPackage = SchemaGenerator.class.getPackage();
            this.getLog().debug((CharSequence)("Using SchemaGen of " + jaxbImplPackage.getImplementationTitle() + " version " + jaxbImplPackage.getImplementationVersion()));
        }
        if ("pom".equals(this.project.getPackaging())) {
            return;
        }
        if (this.includes.isEmpty()) {
            throw new MojoExecutionException("At least one file has to be included");
        }
        if (this.isOutputStale()) {
            String includePaths = StringUtils.join((Object[])this.includes.toArray(), (String)",");
            String excludePaths = StringUtils.join((Object[])this.excludes.toArray(), (String)",");
            HashSet includedSources = new HashSet();
            for (String path : this.getCompileSourceRoots()) {
                File sourceDir = new File(path);
                if (sourceDir.exists() && sourceDir.isDirectory()) {
                    try {
                        includedSources.addAll(FileUtils.getFileNames((File)sourceDir, (String)includePaths, (String)excludePaths, (boolean)true));
                        continue;
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Error retrieving files in: '" + sourceDir + "' ", (Exception)e);
                    }
                }
                this.getLog().info((CharSequence)("Source directory '" + sourceDir + "' doesn't exist. Ignoring directory in schema generation."));
            }
            ArrayList<String> args = new ArrayList<String>();
            StringBuilder classPath = new StringBuilder();
            try {
                List<String> classpathFiles = this.getClasspathElements(this.project);
                classPath = new StringBuilder();
                for (String classpathFile : classpathFiles) {
                    classPath.append(classpathFile);
                    classPath.append(File.pathSeparatorChar);
                }
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            if (!this.getOutputDirectory().exists() && !this.getOutputDirectory().mkdirs()) {
                throw new MojoExecutionException("Could not create directory " + this.getOutputDirectory().getAbsolutePath());
            }
            try {
                args.add("-d");
                args.add(this.getOutputDirectory().getAbsolutePath());
                args.add("-classpath");
                args.add(classPath.toString());
                args.addAll(includedSources);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Args for SchemaGenerator: " + args));
                }
                SchemaGenerator.run((String[])args.toArray(new String[0]));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to generate schema", e);
            }
            if (this.transformSchemas != null) {
                SchemagenHelper.validateSchemasInPluginConfiguration(this.transformSchemas);
                if (this.hasRenamingSchemas()) {
                    try {
                        FileUtils.copyDirectory((File)this.getOutputDirectory(), (File)this.getWorkDirectory());
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException(e.getMessage());
                    }
                }
                Map<String, SimpleNamespaceResolver> resolverMap = SchemagenHelper.getFileNameToResolverMap(this.getOutputDirectory());
                SchemagenHelper.replaceNamespacePrefixes(resolverMap, this.transformSchemas, this.getLog(), this.getOutputDirectory());
                SchemagenHelper.renameGeneratedSchemaFiles(resolverMap, this.transformSchemas, this.getLog(), this.getOutputDirectory());
            }
            this.buildContext.refresh(this.getOutputDirectory());
        } else {
            this.getLog().info((CharSequence)"No updated sources found - skipping schema generation.");
        }
    }

    private boolean isOutputStale() throws MojoExecutionException {
        if (this.buildContext instanceof DefaultBuildContext) {
            return this.commandLineStalenessCheck();
        }
        return this.buildContextStalenessCheck();
    }

    private boolean commandLineStalenessCheck() throws MojoExecutionException {
        StaleSourceScanner staleSourceScanner = new StaleSourceScanner((long)this.staleMillis, this.includes, this.excludes);
        SingleTargetSourceMapping mapping = new SingleTargetSourceMapping(".java", SCHEMAGEN_EMITTED_FILENAME);
        staleSourceScanner.addSourceMapping((SourceMapping)mapping);
        for (String path : this.getCompileSourceRoots()) {
            File sourceDir = new File(path);
            try {
                Set includedSources = staleSourceScanner.getIncludedSources(sourceDir, this.getOutputDirectory());
                if (includedSources.isEmpty()) continue;
                return true;
            }
            catch (InclusionScanException e) {
                throw new MojoExecutionException("Error scanning source root: '" + sourceDir + "' " + "for stale files to recompile.", (Exception)((Object)e));
            }
        }
        return false;
    }

    private boolean buildContextStalenessCheck() {
        String[] includedFiles;
        File sourceDir;
        String[] includesArray = this.includes.toArray(new String[0]);
        String[] excludesArray = this.excludes.toArray(new String[0]);
        for (String path : this.getCompileSourceRoots()) {
            sourceDir = new File(path);
            Scanner modifiedScanner = this.buildContext.newScanner(sourceDir);
            modifiedScanner.setIncludes(includesArray);
            modifiedScanner.setExcludes(excludesArray);
            modifiedScanner.scan();
            includedFiles = modifiedScanner.getIncludedFiles();
            if (includedFiles.length == 0) continue;
            return true;
        }
        for (String path : this.getCompileSourceRoots()) {
            sourceDir = new File(path);
            Scanner deletedScanner = this.buildContext.newDeleteScanner(sourceDir);
            deletedScanner.setIncludes(includesArray);
            deletedScanner.setExcludes(excludesArray);
            deletedScanner.scan();
            includedFiles = deletedScanner.getIncludedFiles();
            if (includedFiles.length == 0) continue;
            return true;
        }
        return false;
    }

    private boolean hasRenamingSchemas() {
        if (this.transformSchemas != null) {
            for (TransformSchema schema : this.transformSchemas) {
                if (schema.getToFile() == null) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract File getOutputDirectory();

    protected abstract File getWorkDirectory();

    protected abstract List<String> getCompileSourceRoots();

    protected abstract List<String> getClasspathElements(MavenProject var1) throws DependencyResolutionRequiredException;
}

