/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.helper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyFileReader {
    private static final Logger log = LoggerFactory.getLogger(PropertyFileReader.class);
    private static final Pattern nonCommentPattern = Pattern.compile("^([^#]+)");
    private InputStream is = null;

    public PropertyFileReader(InputStream is) {
        this.is = is;
    }

    public Properties getProperties() throws IOException {
        if (this.is == null) {
            return null;
        }
        Properties props = new Properties();
        props.load(this.is);
        return props;
    }

    public Set<String> getNonCommentLines() throws IOException {
        String line;
        HashSet<String> lines = new HashSet<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.is));
        while ((line = reader.readLine()) != null) {
            Matcher m = nonCommentPattern.matcher(line = line.trim());
            if (!m.find()) continue;
            lines.add(m.group().trim());
        }
        return lines;
    }

    public void close() {
        try {
            this.is.close();
        }
        catch (IOException e) {
            log.warn("Exception when closing PropertyFileReader: " + e);
        }
    }
}

