/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.mgeom;

public final class DoubleComparator {
    private static final int radix = DoubleComparator.computeRadix();
    private static final double machinePrecision = DoubleComparator.computeMachinePrecision();
    private static final double defaultNumericalPrecision = Math.sqrt(machinePrecision);

    private static int computeRadix() {
        double tmp1;
        double tmp2;
        int radix = 0;
        double a = 1.0;
        while ((tmp2 = (tmp1 = (a += a) + 1.0) - a) - 1.0 != 0.0) {
        }
        double b = 1.0;
        while (radix == 0) {
            b += b;
            tmp1 = a + b;
            radix = (int)(tmp1 - a);
        }
        return radix;
    }

    public static int getRadix() {
        return radix;
    }

    private static double computeMachinePrecision() {
        double floatingRadix = DoubleComparator.getRadix();
        double inverseRadix = 1.0 / floatingRadix;
        double machinePrecision = 1.0;
        double tmp = 1.0 + machinePrecision;
        while (tmp - 1.0 != 0.0) {
            tmp = 1.0 + (machinePrecision *= inverseRadix);
        }
        return machinePrecision;
    }

    public static double getMachinePrecision() {
        return machinePrecision;
    }

    public static double defaultNumericalPrecision() {
        return defaultNumericalPrecision;
    }

    public static boolean equals(double a, double b) {
        return DoubleComparator.equals(a, b, DoubleComparator.defaultNumericalPrecision());
    }

    public static boolean equals(double a, double b, double precision) {
        double norm = Math.max(Math.abs(a), Math.abs(b));
        boolean result = norm < precision || Math.abs(a - b) < precision * norm;
        return result || Double.isNaN(a) && Double.isNaN(b);
    }

    public static void main(String[] args) {
        System.out.println("Machine precision = " + DoubleComparator.getMachinePrecision());
        System.out.println("Radix = " + DoubleComparator.getRadix());
        System.out.println("default numerical precision = " + DoubleComparator.defaultNumericalPrecision());
    }
}

