/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.pojo;

import java.security.ProtectionDomain;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import org.hibernatespatial.pojo.AttributeInfo;
import org.hibernatespatial.pojo.ClassInfo;
import org.hibernatespatial.pojo.NamingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureClassGenerator {
    private final String packageName;
    private final NamingStrategy naming;
    private static final ClassPool pool = ClassPool.getDefault();

    public FeatureClassGenerator(String packageName, NamingStrategy naming) {
        this.packageName = packageName;
        this.naming = naming;
    }

    public Class<?> generate(ClassInfo classInfo) {
        try {
            String classname = this.packageName + "." + classInfo.getClassName();
            CtClass pojo = pool.makeClass(classname);
            for (AttributeInfo ai : classInfo.getAttributes()) {
                CtField field = this.createField(ai, pojo);
                CtMethod getter = this.createGetterMethod(field);
                CtMethod setter = this.createSetterMethod(field);
                pojo.addField(field);
                pojo.addMethod(getter);
                pojo.addMethod(setter);
            }
            ProtectionDomain pd = pojo.getClass().getProtectionDomain();
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class clazz = pojo.toClass(cl, pd);
            pojo.detach();
            return clazz;
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
            throw new RuntimeException("Problem generating class for table " + classInfo.getTableName(), e);
        }
    }

    private CtMethod createGetterMethod(CtField field) throws CannotCompileException {
        String fn = field.getName();
        return CtNewMethod.getter((String)this.naming.createGetterName(fn), (CtField)field);
    }

    private CtMethod createSetterMethod(CtField field) throws CannotCompileException {
        String fn = field.getName();
        return CtNewMethod.setter((String)this.naming.createSetterName(fn), (CtField)field);
    }

    private CtField createField(AttributeInfo ai, CtClass declaring) throws CannotCompileException {
        CtField f = new CtField(ai.getCtClass(), ai.getFieldName(), declaring);
        return f;
    }
}

