/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.pojo;

import java.util.ArrayList;
import java.util.List;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.hibernatespatial.GeometryUserType;
import org.hibernatespatial.pojo.TypeNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeMapper {
    protected static final Logger logger = LoggerFactory.getLogger(TypeMapper.class);
    private static final String GEOMETRY_USER_TYPE = GeometryUserType.class.getCanonicalName();
    private List<TMEntry> entries = new ArrayList<TMEntry>();
    private String dbGeomType = "";
    private CtClass ctGeom;

    public TypeMapper(String dbGeomType) {
        CtClass ctBinary;
        CtClass ctByte;
        CtClass ctBigDecimal;
        CtClass ctFloat;
        CtClass ctShort;
        CtClass ctLong;
        CtClass ctDouble;
        CtClass ctBoolean;
        CtClass ctInteger;
        CtClass ctDate;
        CtClass ctString;
        this.dbGeomType = dbGeomType;
        ClassPool pool = ClassPool.getDefault();
        pool.insertClassPath((ClassPath)new ClassClassPath(this.getClass()));
        try {
            ctString = pool.get("java.lang.String");
            ctDate = pool.get("java.util.Date");
            this.ctGeom = pool.get("com.vividsolutions.jts.geom.Geometry");
            ctInteger = pool.get("java.lang.Integer");
            ctBoolean = pool.get("java.lang.Boolean");
            ctDouble = pool.get("java.lang.Double");
            ctLong = pool.get("java.lang.Long");
            ctShort = pool.get("java.lang.Short");
            ctFloat = pool.get("java.lang.Float");
            ctBigDecimal = pool.get("java.math.BigDecimal");
            ctByte = pool.get("java.lang.Byte");
            ctBinary = pool.get("byte[]");
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        this.entries.add(new TMEntry(-5, "integer", ctInteger));
        this.entries.add(new TMEntry(5, "short", ctShort));
        this.entries.add(new TMEntry(-6, "byte", ctByte));
        this.entries.add(new TMEntry(16, "boolean", ctBoolean));
        this.entries.add(new TMEntry(-7, "boolean", ctBoolean));
        this.entries.add(new TMEntry(1, "string", ctString));
        this.entries.add(new TMEntry(91, "date", ctDate));
        this.entries.add(new TMEntry(93, "timestamp", ctDate));
        this.entries.add(new TMEntry(92, "time", ctDate));
        this.entries.add(new TMEntry(3, "big_decimal", ctBigDecimal));
        this.entries.add(new TMEntry(8, "double", ctDouble));
        this.entries.add(new TMEntry(2, "big_decimal", ctBigDecimal));
        this.entries.add(new TMEntry(6, "float", ctFloat));
        this.entries.add(new TMEntry(4, "integer", ctInteger));
        this.entries.add(new TMEntry(-5, "long", ctLong));
        this.entries.add(new TMEntry(12, "string", ctString));
        this.entries.add(new TMEntry(-2, "binary", ctBinary));
        this.entries.add(new TMEntry(2005, "text", ctString));
    }

    public CtClass getCtClass(String dbType, int sqlType) {
        if (dbType.equalsIgnoreCase(this.dbGeomType)) {
            return this.ctGeom;
        }
        for (TMEntry entry : this.entries) {
            if (entry.javaType != sqlType) continue;
            return entry.ctClass;
        }
        return null;
    }

    public String getHibernateType(String dbType, int sqlType) throws TypeNotFoundException {
        if (dbType.equalsIgnoreCase(this.dbGeomType)) {
            return GEOMETRY_USER_TYPE;
        }
        for (TMEntry entry : this.entries) {
            if (entry.javaType != sqlType) continue;
            return entry.hibernateTypeName;
        }
        throw new TypeNotFoundException(dbType);
    }

    public int[] getMappedSQLTypes() {
        int l = this.entries.size();
        int[] types = new int[l];
        for (int i = 0; i < this.entries.size(); ++i) {
            types[i] = this.entries.get((int)i).javaType;
        }
        return types;
    }

    public void addTypeMapping(int sqlType, String hibernateType, CtClass ctClass) {
        this.entries.add(new TMEntry(sqlType, hibernateType, ctClass));
    }

    public void removeTypeMapping(int sqlType) {
        TMEntry tm = null;
        for (TMEntry t : this.entries) {
            if (t.javaType != sqlType) continue;
            tm = t;
            break;
        }
        if (tm != null) {
            this.entries.remove(tm);
        }
    }

    private static class TMEntry {
        protected int javaType = 0;
        protected String hibernateTypeName = "";
        protected CtClass ctClass;

        protected TMEntry(int jt, String ht, CtClass jc) {
            this.javaType = jt;
            this.hibernateTypeName = ht;
            this.ctClass = jc;
        }
    }
}

