/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.readers;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.hibernate.EntityMode;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.property.Getter;
import org.hibernate.util.ReflectHelper;
import org.hibernatespatial.helper.FinderException;
import org.hibernatespatial.helper.GeometryPropertyFinder;
import org.hibernatespatial.readers.Feature;

public class FeatureAdapter {
    public static Feature adapt(Object o, ClassMetadata cf) {
        return (Feature)Proxy.newProxyInstance(o.getClass().getClassLoader(), new Class[]{Feature.class}, (InvocationHandler)new FeatureInvocationHandler(o, cf));
    }

    private static class FeatureInvocationHandler
    implements InvocationHandler {
        private final Object target;
        private final ClassMetadata metadata;
        private Method targetGeomGetter;
        private Method targetIdGetter;
        private static final Method geomGetter;
        private static final Method idGetter;
        private static final Method attrGetter;
        private static GeometryPropertyFinder geomPropertyFinder;

        private FeatureInvocationHandler(Object o, ClassMetadata meta) {
            if (meta.getMappedClass(EntityMode.POJO) != o.getClass()) {
                throw new RuntimeException("Metadata and POJO class do not cohere");
            }
            this.target = o;
            this.metadata = meta;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Method m = this.getTargetGetter(method, args);
            if (m == null) {
                return method.invoke(this.target, args);
            }
            return m.invoke(this.target, new Object[0]);
        }

        private Method getTargetGetter(Method invokedMethod, Object[] args) {
            try {
                if (invokedMethod.equals(geomGetter)) {
                    if (this.targetGeomGetter == null) {
                        this.targetGeomGetter = this.getGeomGetter();
                    }
                    return this.targetGeomGetter;
                }
                if (invokedMethod.equals(idGetter)) {
                    if (this.targetIdGetter == null) {
                        this.targetIdGetter = this.getIdGetter();
                    }
                    return this.targetIdGetter;
                }
                if (invokedMethod.equals(attrGetter)) {
                    String property = (String)args[0];
                    return this.getGetterFor(property);
                }
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException("Problem getting suitable target method for method:  " + invokedMethod.getName(), e);
            }
        }

        private Method getGetterFor(String property) {
            Class cl = this.metadata.getMappedClass(EntityMode.POJO);
            Getter getter = ReflectHelper.getGetter((Class)cl, (String)property);
            return getter.getMethod();
        }

        private Method getGeomGetter() {
            try {
                String prop = this.getGeometryPropertyName();
                return this.getGetterFor(prop);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String getGeometryPropertyName() throws FinderException {
            return geomPropertyFinder.find(this.metadata);
        }

        public Method getIdGetter() {
            String prop = this.metadata.getIdentifierPropertyName();
            return this.getGetterFor(prop);
        }

        static {
            geomPropertyFinder = new GeometryPropertyFinder();
            Class<Feature> featureIntf = Feature.class;
            try {
                geomGetter = featureIntf.getDeclaredMethod("getGeometry", new Class[0]);
                idGetter = featureIntf.getDeclaredMethod("getId", new Class[0]);
                attrGetter = featureIntf.getDeclaredMethod("getAttribute", String.class);
            }
            catch (Exception e) {
                throw new RuntimeException("Probable programming Error", e);
            }
        }
    }
}

