/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage;

import java.awt.image.ColorModel;
import java.awt.image.RasterFormatException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import javax.measure.unit.Unit;
import javax.media.jai.iterator.WritableRectIter;
import org.geotools.coverage.Category;
import org.geotools.coverage.ColorModelFactory;
import org.geotools.coverage.GeophysicsCategoryList;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.operation.matrix.Matrix1;
import org.geotools.referencing.wkt.UnformattableObjectException;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.AbstractInternationalString;
import org.geotools.util.NumberRange;
import org.geotools.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CategoryList
extends AbstractList<Category>
implements MathTransform1D,
Comparator<Category>,
Serializable {
    private static final long serialVersionUID = 2647846361059903365L;
    final CategoryList inverse;
    private transient NumberRange<?> range;
    private final double[] minimums;
    private final Category[] categories;
    private final Category main;
    final Category nodata;
    private final Category overflowFallback;
    private transient Category last;
    private final boolean hasGaps;
    private transient InternationalString name;

    public CategoryList(Category[] categories, Unit<?> units) throws IllegalArgumentException {
        this(categories, units, false, null);
        assert (this.isGeophysics(false));
    }

    CategoryList(Category[] categories, Unit<?> units, boolean searchNearest, CategoryList inverse) throws IllegalArgumentException {
        boolean geophysics;
        boolean bl = geophysics = inverse != null;
        assert (geophysics == this instanceof GeophysicsCategoryList) : geophysics;
        categories = (Category[])categories.clone();
        this.categories = categories;
        for (int i = 0; i < categories.length; ++i) {
            categories[i] = categories[i].geophysics(geophysics);
        }
        Arrays.sort(categories, this);
        assert (CategoryList.isSorted(categories));
        assert (this.isGeophysics(geophysics));
        boolean hasGaps = false;
        this.minimums = new double[categories.length];
        for (int i = 0; i < categories.length; ++i) {
            double minimum = this.minimums[i] = categories[i].minimum;
            if (i == 0) continue;
            assert (!(minimum < this.minimums[i - 1])) : minimum;
            Category previous = categories[i - 1];
            if (CategoryList.compare(minimum, previous.maximum) <= 0) {
                NumberRange<? extends Number> range1 = categories[i - 1].getRange();
                NumberRange<? extends Number> range2 = categories[i - 0].getRange();
                Comparable[] args = new Comparable[]{range1.getMinValue(), range1.getMaxValue(), range2.getMinValue(), range2.getMaxValue()};
                for (int j = 0; j < args.length; ++j) {
                    float value;
                    if (!(args[j] instanceof Number) || !Float.isNaN(value = ((Number)((Object)args[j])).floatValue())) continue;
                    String hex = Integer.toHexString(Float.floatToRawIntBits(value));
                    args[j] = "NaN(" + hex + ')';
                }
                throw new IllegalArgumentException(Errors.format((int)162, (Object)args));
            }
            if (Double.isNaN(minimum) || minimum == previous.getRange().getMaximum(false)) continue;
            hasGaps = true;
        }
        this.hasGaps = hasGaps;
        Category nodata = Category.NODATA;
        long nodataBits = Double.doubleToRawLongBits(Double.NaN);
        int i = categories.length;
        while (--i >= 0) {
            Category candidate = categories[i];
            double value = candidate.geophysics((boolean)true).minimum;
            if (!Double.isNaN(value)) continue;
            nodata = candidate;
            if (Double.doubleToRawLongBits(value) != nodataBits) continue;
            break;
        }
        this.nodata = nodata;
        double range = 0.0;
        Category main = null;
        int i2 = categories.length;
        while (--i2 >= 0) {
            Category candidate = categories[i2];
            if (!candidate.isQuantitative()) continue;
            Category candidatePeer = candidate.geophysics(false);
            double candidateRange = candidatePeer.maximum - candidatePeer.minimum;
            if (!(candidateRange >= range)) continue;
            range = candidateRange;
            main = candidate;
        }
        this.main = main;
        this.last = main != null || categories.length == 0 ? main : categories[0];
        Category overflowFallback = null;
        if (searchNearest) {
            int i3 = categories.length;
            while (--i3 >= 0) {
                Category category = categories[i3];
                if (Double.isNaN(category.maximum)) continue;
                overflowFallback = category;
                break;
            }
        }
        this.overflowFallback = overflowFallback;
        if (inverse == null) {
            inverse = new GeophysicsCategoryList(categories, units, this);
        }
        this.inverse = inverse;
        assert (this instanceof GeophysicsCategoryList != inverse instanceof GeophysicsCategoryList);
    }

    @Override
    public final int compare(Category o1, Category o2) {
        return CategoryList.compare(o1.minimum, o2.minimum);
    }

    private static int compare(double v1, double v2) {
        if (Double.isNaN(v1) && Double.isNaN(v2)) {
            long bits2;
            long bits1 = Double.doubleToRawLongBits(v1);
            if (bits1 < (bits2 = Double.doubleToRawLongBits(v2))) {
                return -1;
            }
            if (bits1 > bits2) {
                return 1;
            }
        }
        return Double.compare(v1, v2);
    }

    static boolean isSorted(Category[] categories) {
        for (int i = 1; i < categories.length; ++i) {
            Category c;
            if (!$assertionsDisabled) {
                Category category;
                c = categories[i - 0];
                if (category.minimum > c.maximum) {
                    throw new AssertionError(c);
                }
            }
            if (!$assertionsDisabled) {
                Category category;
                c = categories[i - 1];
                if (category.minimum > c.maximum) {
                    throw new AssertionError(c);
                }
            }
            if (CategoryList.compare(categories[i - 1].maximum, categories[i].minimum) <= 0) continue;
            return false;
        }
        return true;
    }

    static int binarySearch(double[] array, double key) {
        int low = 0;
        int high = array.length - 1;
        boolean keyIsNaN = Double.isNaN(key);
        while (low <= high) {
            boolean adjustLow;
            long keyRawBits;
            int mid = low + high >> 1;
            double midVal = array[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            long midRawBits = Double.doubleToRawLongBits(midVal);
            if (midRawBits == (keyRawBits = Double.doubleToRawLongBits(key))) {
                return mid;
            }
            boolean midIsNaN = Double.isNaN(midVal);
            if (keyIsNaN) {
                adjustLow = !midIsNaN || midRawBits < keyRawBits;
            } else {
                boolean bl = adjustLow = !midIsNaN && midRawBits < keyRawBits;
            }
            if (adjustLow) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -(low + 1);
    }

    public CategoryList geophysics(boolean geo) {
        CategoryList scaled;
        CategoryList categoryList = scaled = geo ? this.inverse : this;
        assert (scaled.isGeophysics(geo));
        return scaled;
    }

    final boolean isGeophysics(boolean geo) {
        return CategoryList.isGeophysics(this.categories, geo);
    }

    static boolean isGeophysics(Category[] categories, boolean geo) {
        for (int i = 0; i < categories.length; ++i) {
            Category category = categories[i];
            if (category.geophysics(geo) == category) continue;
            return false;
        }
        return true;
    }

    public final InternationalString getName() {
        if (this.name == null) {
            this.name = new Name();
        }
        return this.name;
    }

    public Unit<?> getUnits() {
        return null;
    }

    public final NumberRange<?> getRange() {
        if (this.range == null) {
            NumberRange range = null;
            for (int i = 0; i < this.categories.length; ++i) {
                NumberRange extent = this.categories[i].getRange();
                if (Double.isNaN(extent.getMinimum()) || Double.isNaN(extent.getMaximum())) continue;
                range = range != null ? range.union(extent) : extent;
            }
            this.range = range;
        }
        return this.range;
    }

    private StringBuffer formatRange(StringBuffer buffer, Locale locale) {
        NumberRange<?> range = this.getRange();
        buffer.append('[');
        if (range != null) {
            buffer = this.format(range.getMinimum(), false, locale, buffer);
            buffer.append(" ... ");
            buffer = this.format(range.getMaximum(), true, locale, buffer);
        } else {
            Unit<?> unit = this.getUnits();
            if (unit != null) {
                buffer.append(unit);
            }
        }
        buffer.append(']');
        return buffer;
    }

    StringBuffer format(double value, boolean writeUnits, Locale locale, StringBuffer buffer) {
        return buffer.append(value);
    }

    public final ColorModel getColorModel(int visibleBand, int numBands) {
        int type = 4;
        NumberRange<?> range = this.getRange();
        Class rt = range.getElementClass();
        if (Byte.class.equals((Object)rt) || Short.class.equals((Object)rt) || Integer.class.equals((Object)rt)) {
            int min = ((Number)((Object)range.getMinValue())).intValue();
            int max = ((Number)((Object)range.getMaxValue())).intValue();
            type = min >= 0 ? (max < 256 ? 0 : (max < 65536 ? 1 : 3)) : (min >= Short.MIN_VALUE && max <= Short.MAX_VALUE ? 2 : 3);
        }
        return this.getColorModel(visibleBand, numBands, type);
    }

    public final ColorModel getColorModel(int visibleBand, int numBands, int type) {
        return ColorModelFactory.getColorModel(this.categories, type, visibleBand, numBands);
    }

    public final Category getCategory(double sample) {
        int i = CategoryList.binarySearch(this.minimums, sample);
        if (i >= 0) {
            assert (Double.doubleToRawLongBits(sample) == Double.doubleToRawLongBits(this.minimums[i]));
            return this.categories[i];
        }
        if (Double.isNaN(sample)) {
            return null;
        }
        assert (i == Arrays.binarySearch(this.minimums, sample)) : i;
        if ((i = ~i - 1) >= 0) {
            Category category = this.categories[i];
            assert (sample > category.minimum) : sample;
            if (sample <= category.maximum) {
                return category;
            }
            if (this.overflowFallback != null) {
                if (++i < this.categories.length) {
                    Category upper = this.categories[i];
                    assert (!(upper.minimum <= sample)) : sample;
                    return upper.minimum - sample < sample - category.maximum ? upper : category;
                }
                return this.overflowFallback;
            }
        } else if (this.overflowFallback != null && this.categories.length != 0) {
            Category category = this.categories[0];
            if (!Double.isNaN(category.minimum)) {
                return category;
            }
        }
        return null;
    }

    public final String format(double value, Locale locale) {
        if (Double.isNaN(value)) {
            Category category = this.last;
            if (!(value >= category.minimum && value <= category.maximum || Double.doubleToRawLongBits(value) == Double.doubleToRawLongBits(category.minimum))) {
                category = this.getCategory(value);
                if (category == null) {
                    return Vocabulary.getResources((Locale)locale).getString(232);
                }
                this.last = category;
            }
            return category.getName().toString(null);
        }
        return this.format(value, true, locale, new StringBuffer()).toString();
    }

    @Override
    public final int size() {
        return this.categories.length;
    }

    @Override
    public final Category get(int i) {
        return this.categories[i];
    }

    public final Category[] toArray() {
        return (Category[])this.categories.clone();
    }

    @Override
    public final String toString() {
        return this.toString(this, null);
    }

    final String toString(Object owner, InternationalString description) {
        String lineSeparator = System.getProperty("line.separator", "\n");
        StringBuffer buffer = new StringBuffer(Classes.getShortClassName((Object)owner));
        buffer.append('(');
        if (description != null && description != this.name) {
            buffer.append('\"').append((CharSequence)description).append("\":");
        }
        buffer = this.formatRange(buffer, null);
        if (this.hasGaps) {
            buffer.append(" with gaps");
        }
        buffer.append(')').append(lineSeparator);
        for (Category category : this.categories) {
            buffer.append("  ").append(category == this.main ? (char)'\u2023' : ' ').append(' ').append(category).append(lineSeparator);
        }
        return buffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof CategoryList) {
            CategoryList that = (CategoryList)object;
            if (Arrays.equals(this.categories, that.categories)) {
                assert (Arrays.equals(this.minimums, that.minimums));
                return Utilities.equals((Object)this.overflowFallback, (Object)that.overflowFallback);
            }
            return false;
        }
        return this.overflowFallback == null && super.equals(object);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.last = this.main != null || this.categories.length == 0 ? this.main : this.categories[0];
    }

    public final int getSourceDimensions() {
        return 1;
    }

    public final int getTargetDimensions() {
        return 1;
    }

    public boolean isIdentity() {
        return false;
    }

    public final MathTransform1D inverse() {
        return this.inverse;
    }

    private static void checkDimension(DirectPosition point) {
        int dim = point.getDimension();
        if (dim != 1) {
            throw new MismatchedDimensionException(Errors.format((int)93, (Object)1, (Object)dim));
        }
    }

    public final DirectPosition transform(DirectPosition ptSrc, DirectPosition ptDst) throws TransformException {
        CategoryList.checkDimension(ptSrc);
        if (ptDst == null) {
            ptDst = new GeneralDirectPosition(1);
        } else {
            CategoryList.checkDimension(ptDst);
        }
        ptDst.setOrdinate(0, this.transform(ptSrc.getOrdinate(0)));
        return ptDst;
    }

    public final Matrix derivative(DirectPosition point) throws TransformException {
        CategoryList.checkDimension(point);
        return new Matrix1(this.derivative(point.getOrdinate(0)));
    }

    public final double derivative(double value) throws TransformException {
        Category category = this.last;
        if (!(value >= category.minimum && value <= category.maximum || Double.doubleToRawLongBits(value) == Double.doubleToRawLongBits(category.minimum))) {
            category = this.getCategory(value);
            if (category == null) {
                throw new TransformException(Errors.format((int)128, (Object)value));
            }
            this.last = category;
        }
        return category.transform.derivative(value);
    }

    public final double transform(double value) throws TransformException {
        Category category = this.last;
        if (!(value >= category.minimum && value <= category.maximum || Double.doubleToRawLongBits(value) == Double.doubleToRawLongBits(category.minimum))) {
            category = this.getCategory(value);
            if (category == null) {
                throw new TransformException(Errors.format((int)128, (Object)value));
            }
            this.last = category;
        }
        value = category.transform.transform(value);
        if (this.overflowFallback != null) {
            if (value < category.inverse.minimum) {
                return category.inverse.minimum;
            }
            if (value > category.inverse.maximum) {
                return category.inverse.maximum;
            }
        }
        assert (category == this.inverse.getCategory((double)value).inverse) : category;
        return value;
    }

    private void transform(double[] srcPts, float[] srcFloat, int srcOff, double[] dstPts, float[] dstFloat, int dstOff, int numPts, boolean doublePrecision) throws TransformException {
        int direction;
        int srcToDst = dstOff - srcOff;
        Category category = this.last;
        double maximum = category.maximum;
        double minimum = category.minimum;
        long rawBits = Double.doubleToRawLongBits(minimum);
        if (srcPts != dstPts || srcOff >= dstOff) {
            direction = 1;
        } else {
            direction = -1;
            dstOff += numPts - 1;
            srcOff += numPts - 1;
        }
        int peekOff = srcOff;
        while (true) {
            double value = 0.0;
            if (doublePrecision) {
                while (--numPts >= 0 && ((value = srcPts[peekOff]) >= minimum && value <= maximum || Double.doubleToRawLongBits(value) == rawBits)) {
                    peekOff += direction;
                }
            } else {
                while (--numPts >= 0 && ((value = (double)srcFloat[peekOff]) >= minimum && value <= maximum || Double.doubleToRawLongBits(value) == rawBits)) {
                    peekOff += direction;
                }
            }
            if (!(this.overflowFallback != null && (value > maximum && category == this.overflowFallback || value < minimum && category == this.categories[0]))) {
                int count = peekOff - srcOff;
                if (count < 0) {
                    count = -count;
                    srcOff -= count - 1;
                }
                if (doublePrecision) {
                    category.transform.transform(srcPts, srcOff, dstPts, srcOff + srcToDst, count);
                    if (this.overflowFallback != null) {
                        dstOff = srcOff + srcToDst;
                        double min = category.inverse.minimum;
                        double max = category.inverse.maximum;
                        while (--count >= 0) {
                            double check = dstPts[dstOff];
                            if (check < min) {
                                dstPts[dstOff] = min;
                            } else if (check > max) {
                                dstPts[dstOff] = max;
                            }
                            ++dstOff;
                        }
                    }
                } else {
                    category.transform.transform(srcFloat, srcOff, dstFloat, srcOff + srcToDst, count);
                    if (this.overflowFallback != null) {
                        dstOff = srcOff + srcToDst;
                        float min = (float)category.inverse.minimum;
                        float max = (float)category.inverse.maximum;
                        while (--count >= 0) {
                            float check = dstFloat[dstOff];
                            if (check < min) {
                                dstFloat[dstOff] = min;
                            } else if (check > max) {
                                dstFloat[dstOff] = max;
                            }
                            ++dstOff;
                        }
                    }
                }
                if (numPts < 0) break;
                category = this.getCategory(value);
                if (category == null) {
                    throw new TransformException(Errors.format((int)128, (Object)value));
                }
                maximum = category.maximum;
                minimum = category.minimum;
                rawBits = Double.doubleToRawLongBits(minimum);
                srcOff = peekOff;
            }
            peekOff += direction;
        }
        this.last = category;
    }

    public final void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        this.transform(srcPts, null, srcOff, dstPts, null, dstOff, numPts, true);
    }

    public final void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        this.transform(null, srcPts, srcOff, null, dstPts, dstOff, numPts, false);
    }

    public final void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public final void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public final void transform(WritableRectIter iterator) throws RasterFormatException {
        double minTr;
        double maxTr;
        Category categoryMin = null;
        Category categoryMax = null;
        int i = this.categories.length;
        while (--i >= 0) {
            if (Double.isNaN(this.categories[i].maximum)) continue;
            categoryMax = this.categories[i];
            categoryMin = this.categories[0];
            break;
        }
        Category category = this.main;
        if (this.main == null) {
            category = this.nodata;
        }
        double maximum = category.maximum;
        double minimum = category.minimum;
        long rawBits = Double.doubleToRawLongBits(minimum);
        MathTransform1D tr = category.transform;
        if (this.overflowFallback == null) {
            maxTr = Double.POSITIVE_INFINITY;
            minTr = Double.NEGATIVE_INFINITY;
        } else {
            maxTr = category.inverse.maximum;
            minTr = category.inverse.minimum;
        }
        try {
            iterator.startLines();
            if (!iterator.finishedLines()) {
                do {
                    iterator.startPixels();
                    if (iterator.finishedPixels()) continue;
                    do {
                        double value;
                        if (!((value = iterator.getSampleDouble()) >= minimum && value <= maximum || Double.doubleToRawLongBits(value) == rawBits)) {
                            category = this.getCategory(value);
                            if (category == null) {
                                category = this.nodata;
                            }
                            maximum = category != categoryMax ? category.maximum : Double.POSITIVE_INFINITY;
                            minimum = category != categoryMin ? category.minimum : Double.NEGATIVE_INFINITY;
                            rawBits = Double.doubleToRawLongBits(minimum);
                            tr = category.transform;
                            if (this.overflowFallback != null) {
                                maxTr = category.inverse.maximum;
                                minTr = category.inverse.minimum;
                            }
                        }
                        assert (this.hasGaps || category == this.nodata || (!Double.isNaN(value) ? value >= minimum && value <= maximum : Double.doubleToRawLongBits(value) == rawBits)) : value;
                        if ((value = tr.transform(value)) > maxTr) {
                            value = maxTr;
                        } else if (value < minTr) {
                            value = minTr;
                        }
                        iterator.setSample(value);
                    } while (!iterator.nextPixelDone());
                } while (!iterator.nextLineDone());
            }
        }
        catch (TransformException cause) {
            RasterFormatException exception = new RasterFormatException(Errors.format((int)15, (Object)Classes.getClass((Object)tr)));
            exception.initCause(cause);
            throw exception;
        }
    }

    public String toWKT() throws UnsupportedOperationException {
        throw new UnformattableObjectException("Not yet implemented.", this.getClass());
    }

    private final class Name
    extends AbstractInternationalString {
        private Name() {
        }

        public String toString(Locale locale) {
            StringBuffer buffer = new StringBuffer(30);
            if (CategoryList.this.main != null) {
                buffer.append(CategoryList.this.main.getName().toString(locale));
            } else {
                buffer.append('(');
                buffer.append(Vocabulary.getResources((Locale)locale).getString(232));
                buffer.append(')');
            }
            buffer.append(' ');
            return String.valueOf(CategoryList.this.geophysics(true).formatRange(buffer, locale));
        }

        public String toString() {
            return this.toString(Locale.getDefault());
        }
    }
}

