/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.io.Serializable;
import java.util.Arrays;
import org.geotools.resources.Classes;
import org.opengis.coverage.grid.GridCoordinates;

public class GeneralGridCoordinates
implements GridCoordinates,
Serializable {
    private static final long serialVersionUID = 8146318677770695383L;
    final int[] coordinates;

    public GeneralGridCoordinates(int dimension) {
        this.coordinates = new int[dimension];
    }

    public GeneralGridCoordinates(int[] coordinates) {
        this.coordinates = (int[])coordinates.clone();
    }

    public GeneralGridCoordinates(int[] coordinates, int lower, int upper) {
        int length = upper - lower;
        this.coordinates = new int[length];
        System.arraycopy(coordinates, lower, this.coordinates, 0, length);
    }

    public GeneralGridCoordinates(GridCoordinates coordinates) {
        this.coordinates = coordinates.getCoordinateValues();
    }

    public int getDimension() {
        return this.coordinates.length;
    }

    public int[] getCoordinateValues() {
        return (int[])this.coordinates.clone();
    }

    public int getCoordinateValue(int dimension) throws ArrayIndexOutOfBoundsException {
        return this.coordinates[dimension];
    }

    public void setCoordinateValue(int dimension, int value) throws ArrayIndexOutOfBoundsException, UnsupportedOperationException {
        this.coordinates[dimension] = value;
    }

    static String toString(GridCoordinates coordinates) {
        StringBuilder buffer = new StringBuilder(Classes.getShortClassName((Object)coordinates));
        int dimension = coordinates.getDimension();
        for (int i = 0; i < dimension; ++i) {
            buffer.append(i == 0 ? (char)'[' : ',').append(coordinates.getCoordinateValue(i));
        }
        return buffer.append(']').toString();
    }

    public String toString() {
        return GeneralGridCoordinates.toString(this);
    }

    public int hashCode() {
        int code = 665252567;
        for (int i = 0; i < this.coordinates.length; ++i) {
            code = code * 37 + this.coordinates[i];
        }
        return code;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof GeneralGridCoordinates) {
            GeneralGridCoordinates that = (GeneralGridCoordinates)object;
            return Arrays.equals(this.coordinates, that.coordinates);
        }
        return false;
    }

    public GeneralGridCoordinates clone() {
        try {
            return (GeneralGridCoordinates)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static final class Immutable
    extends GeneralGridCoordinates {
        private static final long serialVersionUID = -7723383411061425866L;

        public Immutable(int[] coordinates) {
            super(coordinates);
        }

        public Immutable(int[] coordinates, int lower, int upper) {
            super(coordinates, lower, upper);
        }

        public Immutable(GridCoordinates coordinates) {
            super(coordinates);
        }

        final void translate(int offset) {
            int i = 0;
            while (i < this.coordinates.length) {
                int n = i++;
                this.coordinates[n] = this.coordinates[n] + offset;
            }
        }

        public void setCoordinateValue(int dimension, int value) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        public GeneralGridCoordinates clone() {
            return new GeneralGridCoordinates(this.coordinates);
        }
    }
}

