/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.lang.reflect.Method;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.EMFUtils;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;

public abstract class AbstractComplexEMFBinding
extends AbstractComplexBinding {
    EFactory factory;

    public AbstractComplexEMFBinding() {
    }

    public AbstractComplexEMFBinding(EFactory factory) {
        this.factory = factory;
    }

    public Class getType() {
        String pkg = this.factory.getClass().getPackage().getName();
        if (pkg.endsWith(".impl")) {
            pkg = pkg.substring(0, pkg.length() - 5);
        }
        String className = this.getTarget().getLocalPart();
        try {
            return Class.forName(pkg + "." + className);
        }
        catch (ClassNotFoundException e) {
            if (className.startsWith("_")) {
                className = className.substring(1) + "Type";
            }
            try {
                return Class.forName(pkg + "." + className);
            }
            catch (ClassNotFoundException e1) {
                return null;
            }
        }
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        if (EObject.class.isAssignableFrom(this.getType()) && this.factory != null) {
            Method create;
            String className = this.getType().getName();
            int index = className.lastIndexOf(46);
            if (index != -1) {
                className = className.substring(index + 1);
            }
            if ((create = this.factory.getClass().getMethod("create" + className, null)) == null) {
                return value;
            }
            EObject eObject = (EObject)create.invoke((Object)this.factory, null);
            Iterator c = node.getChildren().iterator();
            while (c.hasNext()) {
                Node child = (Node)c.next();
                String property = child.getComponent().getName();
                if (!EMFUtils.has(eObject, property)) continue;
                if (EMFUtils.isCollection(eObject, property)) {
                    EMFUtils.add(eObject, property, child.getValue());
                    continue;
                }
                EMFUtils.set(eObject, property, child.getValue());
            }
            return eObject;
        }
        return value;
    }

    public Object getProperty(Object object, QName name) throws Exception {
        EObject eObject;
        if (object instanceof EObject && EMFUtils.has(eObject = (EObject)object, name.getLocalPart())) {
            return EMFUtils.get(eObject, name.getLocalPart());
        }
        return null;
    }
}

