/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDSchemaLocationResolver;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.geotools.resources.Utilities;
import org.geotools.xml.BindingConfiguration;
import org.geotools.xml.SchemaLocationResolver;
import org.geotools.xml.SchemaLocator;
import org.geotools.xs.XSConfiguration;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;

public abstract class Configuration {
    private final List dependencies = new ArrayList();
    private XSDSchemaLocator schemaLocator;
    private final List properties;

    public Configuration() {
        if (!(this instanceof XSConfiguration)) {
            this.dependencies.add(new XSConfiguration());
        }
        this.properties = Collections.synchronizedList(new ArrayList());
    }

    public final List getDependencies() {
        return this.dependencies;
    }

    public final List getProperties() {
        return this.properties;
    }

    public final List allDependencies() {
        LinkedList<Configuration> unpacked = new LinkedList<Configuration>();
        Stack<Configuration> stack = new Stack<Configuration>();
        stack.push(this);
        while (!stack.isEmpty()) {
            Configuration c = (Configuration)stack.pop();
            if (unpacked.contains(c)) continue;
            unpacked.addFirst(c);
            stack.addAll(c.getDependencies());
        }
        return unpacked;
    }

    protected void addDependency(Configuration dependency) {
        if (this.dependencies.contains(dependency)) {
            return;
        }
        this.dependencies.add(dependency);
    }

    public abstract String getNamespaceURI();

    public abstract String getSchemaFileURL();

    public abstract BindingConfiguration getBindingConfiguration();

    public XSDSchemaLocationResolver getSchemaLocationResolver() {
        return new SchemaLocationResolver(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSDSchemaLocator getSchemaLocator() {
        if (this.schemaLocator == null) {
            Configuration configuration = this;
            synchronized (configuration) {
                if (this.schemaLocator == null) {
                    this.schemaLocator = this.createSchemaLocator();
                }
            }
        }
        return this.schemaLocator;
    }

    protected XSDSchemaLocator createSchemaLocator() {
        return new SchemaLocator(this);
    }

    public XSDSchema schema() {
        return this.getSchemaLocator().locateSchema(null, this.getNamespaceURI(), null, null);
    }

    public final MutablePicoContainer setupBindings(MutablePicoContainer container) {
        Iterator d = this.allDependencies().iterator();
        while (d.hasNext()) {
            Configuration dependency = (Configuration)d.next();
            BindingConfiguration bindings = dependency.getBindingConfiguration();
            if (bindings == null) continue;
            bindings.configure(container);
        }
        container = container.makeChildContainer();
        this.configureBindings(container);
        return container;
    }

    protected void configureBindings(MutablePicoContainer container) {
    }

    public final MutablePicoContainer setupContext(MutablePicoContainer container) {
        List dependencies = this.allDependencies();
        Iterator d = dependencies.iterator();
        while (d.hasNext()) {
            XSDSchemaLocator locator;
            Configuration dependency = (Configuration)d.next();
            XSDSchemaLocationResolver resolver = dependency.getSchemaLocationResolver();
            if (resolver != null) {
                QName key = new QName(dependency.getNamespaceURI(), "schemaLocationResolver");
                container.registerComponentInstance((Object)key, (Object)resolver);
            }
            if ((locator = dependency.getSchemaLocator()) != null) {
                QName key = new QName(dependency.getNamespaceURI(), "schemaLocator");
                container.registerComponentInstance((Object)key, (Object)locator);
            }
            ArrayList properties = new ArrayList(dependency.getProperties());
            Iterator p = properties.iterator();
            while (p.hasNext()) {
                QName property = (QName)p.next();
                try {
                    container.registerComponentInstance((Object)property, (Object)property);
                }
                catch (DuplicateComponentKeyRegistrationException e) {}
            }
            container = container.makeChildContainer();
            dependency.configureContext(container);
        }
        return container;
    }

    protected void configureContext(MutablePicoContainer container) {
    }

    public void flush() {
        this.schemaLocator = null;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof Configuration) {
            Configuration other = (Configuration)obj;
            return Utilities.equals((Object)this.getNamespaceURI(), (Object)other.getNamespaceURI());
        }
        return false;
    }

    public final int hashCode() {
        if (this.getNamespaceURI() != null) {
            return this.getNamespaceURI().hashCode();
        }
        return 0;
    }
}

