/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EMFUtils {
    public static boolean has(EObject eobject, String property) {
        return EMFUtils.feature(eobject, property) != null;
    }

    public static void set(EObject eobject, String property, Object value) {
        EStructuralFeature feature = EMFUtils.feature(eobject, property);
        eobject.eSet(feature, value);
    }

    public static Object get(EObject eobject, String property) {
        EStructuralFeature feature = EMFUtils.feature(eobject, property);
        return eobject.eGet(feature);
    }

    public static void add(EObject eobject, String property, Object value) {
        EStructuralFeature feature = EMFUtils.feature(eobject, property);
        if (feature != null && EMFUtils.isCollection(eobject, property)) {
            Collection collection = (Collection)EMFUtils.get(eobject, property);
            collection.add(value);
        }
    }

    public static boolean isCollection(EObject eobject, String property) {
        EStructuralFeature feature = EMFUtils.feature(eobject, property);
        if (feature == null) {
            return false;
        }
        return EList.class.isAssignableFrom(feature.getEType().getInstanceClass());
    }

    public static EStructuralFeature feature(EObject eobject, String property) {
        EStructuralFeature feature = eobject.eClass().getEStructuralFeature(property);
        if (feature != null) {
            return feature;
        }
        Iterator itr = eobject.eClass().getEAllStructuralFeatures().iterator();
        while (itr.hasNext()) {
            feature = (EStructuralFeature)itr.next();
            if (!feature.getName().equalsIgnoreCase(property)) continue;
            return feature;
        }
        return null;
    }

    public static void set(List objects, String property, List values) {
        for (int i = 0; i < objects.size(); ++i) {
            EObject eobject = (EObject)objects.get(i);
            EMFUtils.set(eobject, property, values.get(i));
        }
    }

    public static void set(List objects, String property, Object value) {
        for (int i = 0; i < objects.size(); ++i) {
            EObject eobject = (EObject)objects.get(i);
            EMFUtils.set(eobject, property, value);
        }
    }

    public static List get(List objects, String property) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < objects.size(); ++i) {
            EObject eobject = (EObject)objects.get(i);
            EStructuralFeature feature = EMFUtils.feature(eobject, property);
            values.add(eobject.eGet(feature));
        }
        return values;
    }

    public static boolean isSet(EObject eobject, String property) {
        EStructuralFeature feature = EMFUtils.feature(eobject, property);
        return eobject.eIsSet(feature);
    }

    public static boolean isSet(List objects, String property) {
        for (int i = 0; i < objects.size(); ++i) {
            EObject eobject = (EObject)objects.get(i);
            if (EMFUtils.isSet(eobject, property)) continue;
            return false;
        }
        return true;
    }

    public static boolean isUnset(List objects, String property) {
        for (int i = 0; i < objects.size(); ++i) {
            EObject eobject = (EObject)objects.get(i);
            if (!EMFUtils.isSet(eobject, property)) continue;
            return false;
        }
        return true;
    }

    public static EObject clone(EObject prototype, EFactory factory) {
        EObject clone = factory.create(prototype.eClass());
        Iterator i = clone.eClass().getEStructuralFeatures().iterator();
        while (i.hasNext()) {
            EStructuralFeature feature = (EStructuralFeature)i.next();
            clone.eSet(feature, prototype.eGet(feature));
        }
        return clone;
    }

    public static void copy(EObject source, EObject target) {
        Iterator i = source.eClass().getEStructuralFeatures().iterator();
        while (i.hasNext()) {
            EStructuralFeature feature = (EStructuralFeature)i.next();
            target.eSet(feature, source.eGet(feature));
        }
    }
}

