/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDSchemaLocationResolver;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.geotools.util.logging.Logging;
import org.geotools.xml.Configuration;
import org.geotools.xml.Schemas;

public class SchemaLocator
implements XSDSchemaLocator {
    static Logger logger = Logging.getLogger((String)"org.geotools.xml");
    protected Configuration configuration;
    XSDSchema schema;

    public SchemaLocator(Configuration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSDSchema locateSchema(XSDSchema schema, String namespaceURI, String rawSchemaLocationURI, String resolvedSchemaLocationURI) {
        if (this.configuration.getNamespaceURI().equals(namespaceURI)) {
            if (this.schema != null) {
                logger.finer("returning cached schema for " + namespaceURI);
                return this.schema;
            }
            SchemaLocator schemaLocator = this;
            synchronized (schemaLocator) {
                if (this.schema != null) {
                    logger.finer("returning cached schema for " + namespaceURI);
                    return this.schema;
                }
                try {
                    this.schema = this.createSchema();
                }
                catch (Throwable t) {
                    String msg = "Failed to create schema: " + this.configuration.getNamespaceURI();
                    logger.log(Level.WARNING, msg, t);
                }
            }
            return this.schema;
        }
        return null;
    }

    protected XSDSchema createSchema() throws Exception {
        ArrayList<XSDSchemaLocationResolver> resolvers = new ArrayList<XSDSchemaLocationResolver>();
        Iterator d = this.configuration.allDependencies().iterator();
        while (d.hasNext()) {
            Configuration dependency = (Configuration)d.next();
            XSDSchemaLocationResolver resolver = dependency.getSchemaLocationResolver();
            if (resolver == null) continue;
            resolvers.add(resolver);
        }
        String location = this.configuration.getSchemaFileURL().toString();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("parsing schema " + this.configuration.getNamespaceURI());
        }
        return Schemas.parse(location, null, resolvers);
    }
}

