/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.eclipse.xsd.util.XSDSchemaLocationResolver;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.eclipse.xsd.util.XSDUtil;
import org.geotools.resources.Utilities;
import org.geotools.util.logging.Logging;
import org.geotools.xml.Configuration;
import org.geotools.xml.SchemaIndex;
import org.geotools.xml.impl.SchemaIndexImpl;
import org.geotools.xml.impl.TypeWalker;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVisitor;
import org.w3c.dom.Node;

public class Schemas {
    private static final Logger LOGGER = Logging.getLogger((String)Schemas.class.getPackage().getName());
    static /* synthetic */ Class class$org$eclipse$xsd$util$XSDSchemaLocator;
    static /* synthetic */ Class class$org$eclipse$xsd$util$XSDSchemaLocationResolver;

    public static final SchemaIndex findSchemas(Configuration configuration) {
        HashSet<Configuration> configurations = new HashSet<Configuration>(configuration.allDependencies());
        configurations.add(configuration);
        ArrayList<XSDSchema> resolvedSchemas = new ArrayList<XSDSchema>(configurations.size());
        Iterator it = configurations.iterator();
        while (it.hasNext()) {
            XSDSchemaLocator locator;
            Configuration conf = (Configuration)it.next();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("looking up schema for " + conf.getNamespaceURI());
            }
            if ((locator = conf.getSchemaLocator()) == null) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine("No schema locator for " + conf.getNamespaceURI());
                continue;
            }
            String namespaceURI = conf.getNamespaceURI();
            String schemaLocation = null;
            try {
                URL location = new URL(conf.getSchemaFileURL());
                schemaLocation = location.toExternalForm();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            LOGGER.fine("schema location: " + schemaLocation);
            XSDSchema schema = locator.locateSchema(null, namespaceURI, schemaLocation, null);
            if (schema == null) continue;
            resolvedSchemas.add(schema);
        }
        XSDSchema[] schemas = resolvedSchemas.toArray(new XSDSchema[resolvedSchemas.size()]);
        SchemaIndexImpl index = new SchemaIndexImpl(schemas);
        return index;
    }

    public static List findSchemaLocationResolvers(Configuration configuration) {
        List all = configuration.allDependencies();
        ArrayList<XSDSchemaLocationResolver> resolvers = new ArrayList<XSDSchemaLocationResolver>();
        Iterator c = all.iterator();
        while (c.hasNext()) {
            configuration = (Configuration)c.next();
            XSDSchemaLocationResolver resolver = configuration.getSchemaLocationResolver();
            if (resolver == null) continue;
            resolvers.add(resolver);
        }
        return resolvers;
    }

    public static final XSDSchema parse(String location) throws IOException {
        return Schemas.parse(location, (List)null, (List)null);
    }

    public static final XSDSchema parse(String location, XSDSchemaLocator[] locators, XSDSchemaLocationResolver[] resolvers) throws IOException {
        return Schemas.parse(location, locators != null ? Arrays.asList(locators) : (List)null, resolvers != null ? Arrays.asList(resolvers) : (List)null);
    }

    public static final XSDSchema parse(String location, List locators, List resolvers) throws IOException {
        AdapterFactoryImpl adapterFactory;
        if (new File(location).exists()) {
            location = new File(location).getCanonicalFile().toURI().toString();
        }
        URI uri = URI.createURI((String)location);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        if (resolvers != null && !resolvers.isEmpty()) {
            adapterFactory = new SchemaLocationResolverAdapterFactory(resolvers);
            resourceSet.getAdapterFactories().add((Object)adapterFactory);
        }
        if (locators != null && !locators.isEmpty()) {
            adapterFactory = new SchemaLocatorAdapterFactory(locators);
            resourceSet.getAdapterFactories().add((Object)adapterFactory);
        }
        XSDResourceImpl xsdMainResource = (XSDResourceImpl)resourceSet.createResource(URI.createURI((String)".xsd"));
        xsdMainResource.setURI(uri);
        xsdMainResource.load(resourceSet.getLoadOptions());
        return xsdMainResource.getSchema();
    }

    public static final List getChildElementDeclarations(XSDElementDeclaration element) {
        return Schemas.getChildElementDeclarations(element.getType());
    }

    public static final List getChildElementDeclarations(XSDTypeDefinition type) {
        return Schemas.getChildElementDeclarations(type, true);
    }

    public static final List getChildElementDeclarations(XSDElementDeclaration element, boolean includeParents) {
        return Schemas.getChildElementDeclarations(element.getType(), includeParents);
    }

    public static final XSDParticle getChildElementParticle(XSDTypeDefinition type, String name, boolean includeParents) {
        List particles = Schemas.getChildElementParticles(type, includeParents);
        Iterator p = particles.iterator();
        while (p.hasNext()) {
            XSDParticle particle = (XSDParticle)p.next();
            XSDElementDeclaration element = (XSDElementDeclaration)particle.getContent();
            if (element.isElementDeclarationReference()) {
                element.getResolvedElementDeclaration();
            }
            if (!name.equals(element.getName())) continue;
            return particle;
        }
        return null;
    }

    public static final List getChildElementParticles(XSDTypeDefinition type, boolean includeParents) {
        final HashSet contents = new HashSet();
        final ArrayList particles = new ArrayList();
        TypeWalker.Visitor visitor = new TypeWalker.Visitor(){

            public boolean visit(XSDTypeDefinition type) {
                if (type instanceof XSDSimpleTypeDefinition) {
                    return true;
                }
                XSDComplexTypeDefinition cType = (XSDComplexTypeDefinition)type;
                ElementVisitor visitor = new ElementVisitor(this){
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void visit(XSDParticle particle) {
                        XSDElementDeclaration element = (XSDElementDeclaration)particle.getContent();
                        if (element.isElementDeclarationReference()) {
                            element = element.getResolvedElementDeclaration();
                        }
                        if (!1.access$000(this.this$0).contains(element)) {
                            1.access$000(this.this$0).add(element);
                            1.access$100(this.this$0).add(particle);
                        }
                    }
                };
                Schemas.visitElements(cType, visitor);
                return true;
            }

            static /* synthetic */ HashSet access$000(1 x0) {
                return x0.contents;
            }

            static /* synthetic */ ArrayList access$100(1 x0) {
                return x0.particles;
            }
        };
        if (includeParents) {
            new TypeWalker().rwalk(type, visitor);
        } else {
            visitor.visit(type);
        }
        return new ArrayList(particles);
    }

    public static final List getChildElementDeclarations(XSDTypeDefinition type, boolean includeParents) {
        List particles = Schemas.getChildElementParticles(type, includeParents);
        ArrayList<XSDElementDeclaration> elements = new ArrayList<XSDElementDeclaration>();
        Iterator p = particles.iterator();
        while (p.hasNext()) {
            XSDParticle particle = (XSDParticle)p.next();
            XSDElementDeclaration decl = (XSDElementDeclaration)particle.getContent();
            if (decl.isElementDeclarationReference()) {
                decl = decl.getResolvedElementDeclaration();
            }
            elements.add(decl);
        }
        return elements;
    }

    public static final XSDTypeDefinition getBaseTypeDefinition(XSDTypeDefinition type, final QName parentTypeName) {
        final ArrayList found = new ArrayList();
        TypeWalker.Visitor visitor = new TypeWalker.Visitor(){

            public boolean visit(XSDTypeDefinition type) {
                if (Schemas.nameMatches((XSDNamedComponent)type, parentTypeName)) {
                    found.add(type);
                    return false;
                }
                return true;
            }
        };
        new TypeWalker().walk(type, visitor);
        return found.isEmpty() ? null : (XSDTypeDefinition)found.get(0);
    }

    public static final int getMinOccurs(XSDComplexTypeDefinition type, XSDElementDeclaration element) {
        final XSDElementDeclaration fElement = element;
        final ArrayList minOccurs = new ArrayList();
        ElementVisitor visitor = new ElementVisitor(){

            public void visit(XSDParticle particle) {
                XSDElementDeclaration decl = (XSDElementDeclaration)particle.getContent();
                if (decl.isElementDeclarationReference()) {
                    decl = decl.getResolvedElementDeclaration();
                }
                if (decl == fElement) {
                    minOccurs.add(new Integer(particle.getMinOccurs()));
                }
            }
        };
        Schemas.visitElements(type, visitor, true);
        if (minOccurs.isEmpty()) {
            throw new IllegalArgumentException("Element: " + element + " not found in type: " + type);
        }
        return (Integer)minOccurs.get(0);
    }

    public static final int getMaxOccurs(XSDComplexTypeDefinition type, XSDElementDeclaration element) {
        final XSDElementDeclaration fElement = element;
        final ArrayList maxOccurs = new ArrayList();
        ElementVisitor visitor = new ElementVisitor(){

            public void visit(XSDParticle particle) {
                XSDElementDeclaration decl = (XSDElementDeclaration)particle.getContent();
                if (decl.isElementDeclarationReference()) {
                    decl = decl.getResolvedElementDeclaration();
                }
                if (decl == fElement) {
                    maxOccurs.add(new Integer(particle.getMaxOccurs()));
                }
            }
        };
        Schemas.visitElements(type, visitor, true);
        if (maxOccurs.isEmpty()) {
            throw new IllegalArgumentException("Element: " + element + " not found in type: " + type);
        }
        return (Integer)maxOccurs.get(0);
    }

    private static void visitElements(XSDComplexTypeDefinition cType, ElementVisitor visitor, boolean includeParents) {
        if (includeParents) {
            XSDTypeDefinition baseType;
            LinkedList<XSDTypeDefinition> baseTypes = new LinkedList<XSDTypeDefinition>();
            for (baseType = cType.getBaseType(); baseType != null && baseType != baseType.getBaseType(); baseType = baseType.getBaseType()) {
                if (!(baseType instanceof XSDComplexTypeDefinition)) continue;
                baseTypes.addLast(baseType);
            }
            Iterator it = baseTypes.iterator();
            while (it.hasNext()) {
                baseType = (XSDTypeDefinition)it.next();
                Schemas.visitElements((XSDComplexTypeDefinition)baseType, visitor);
            }
        }
        Schemas.visitElements(cType, visitor);
    }

    private static void visitElements(XSDComplexTypeDefinition cType, ElementVisitor visitor) {
        if (cType.getContent() == null || cType.getContent() instanceof XSDSimpleTypeDefinition) {
            return;
        }
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.addLast(cType.getContent());
        while (!queue.isEmpty()) {
            XSDParticle particle = (XSDParticle)queue.removeFirst();
            int pType = XSDUtil.nodeType((Node)particle.getElement());
            if (pType == 11) {
                visitor.visit(particle);
                continue;
            }
            XSDModelGroup grp = null;
            switch (pType) {
                case 16: {
                    XSDModelGroupDefinition grpDef = (XSDModelGroupDefinition)particle.getContent();
                    if (grpDef.isModelGroupDefinitionReference()) {
                        grpDef = grpDef.getResolvedModelGroupDefinition();
                    }
                    grp = grpDef.getModelGroup();
                    break;
                }
                case 0: 
                case 7: 
                case 35: {
                    grp = (XSDModelGroup)particle.getContent();
                }
            }
            if (grp == null) continue;
            EList parts = grp.getParticles();
            Iterator itr = parts.iterator();
            while (itr.hasNext()) {
                queue.addLast(itr.next());
            }
        }
    }

    public static final XSDElementDeclaration getChildElementDeclaration(XSDElementDeclaration parent, QName qName) {
        XSDElementDeclaration child;
        List children = Schemas.getChildElementDeclarations(parent);
        Iterator itr = children.iterator();
        while (itr.hasNext()) {
            XSDElementDeclaration element = (XSDElementDeclaration)itr.next();
            if (!Schemas.nameMatches((XSDNamedComponent)element, qName)) continue;
            return element;
        }
        ArrayList derived = new ArrayList();
        Iterator itr2 = children.iterator();
        while (itr2.hasNext()) {
            child = (XSDElementDeclaration)itr2.next();
            derived.addAll(Schemas.getDerivedElementDeclarations(child));
        }
        itr2 = derived.iterator();
        while (itr2.hasNext()) {
            child = (XSDElementDeclaration)itr2.next();
            if (!Schemas.nameMatches((XSDNamedComponent)child, qName)) continue;
            return child;
        }
        return null;
    }

    public static final List getDerivedElementDeclarations(XSDElementDeclaration element) {
        EList elements = element.getSchema().getElementDeclarations();
        ArrayList<XSDElementDeclaration> derived = new ArrayList<XSDElementDeclaration>();
        Iterator itr = elements.iterator();
        block0: while (itr.hasNext()) {
            XSDElementDeclaration derivee = (XSDElementDeclaration)itr.next();
            if (derivee.equals(element)) continue;
            XSDTypeDefinition type = derivee.getType();
            while (true) {
                if (type.equals(element.getType())) {
                    derived.add(derivee);
                    continue block0;
                }
                if (type.equals(type.getBaseType())) continue block0;
                type = type.getBaseType();
            }
        }
        return derived;
    }

    public static final List getAttributeDeclarations(XSDElementDeclaration element) {
        return Schemas.getAttributeDeclarations(element.getType());
    }

    public static final List getAttributeDeclarations(XSDTypeDefinition type) {
        final ArrayList attributes = new ArrayList();
        TypeWalker.Visitor visitor = new TypeWalker.Visitor(){

            public boolean visit(XSDTypeDefinition type) {
                if (type instanceof XSDSimpleTypeDefinition) {
                    return true;
                }
                XSDComplexTypeDefinition cType = (XSDComplexTypeDefinition)type;
                EList attContent = cType.getAttributeContents();
                Iterator itr = attContent.iterator();
                while (itr.hasNext()) {
                    XSDAttributeGroupContent content = (XSDAttributeGroupContent)itr.next();
                    if (content instanceof XSDAttributeUse) {
                        XSDAttributeUse use = (XSDAttributeUse)content;
                        attributes.add(use.getAttributeDeclaration());
                        continue;
                    }
                    if (!(content instanceof XSDAttributeGroupDefinition)) continue;
                    XSDAttributeGroupDefinition attGrp = (XSDAttributeGroupDefinition)content;
                    if (attGrp.isAttributeGroupDefinitionReference()) {
                        attGrp = attGrp.getResolvedAttributeGroupDefinition();
                    }
                    EList uses = attGrp.getAttributeUses();
                    Iterator aitr = uses.iterator();
                    while (aitr.hasNext()) {
                        XSDAttributeUse use = (XSDAttributeUse)aitr.next();
                        attributes.add(use.getAttributeDeclaration());
                    }
                }
                return true;
            }
        };
        new TypeWalker().walk(type, visitor);
        return attributes;
    }

    public static final XSDAttributeDeclaration getAttributeDeclaration(XSDElementDeclaration element, QName qName) {
        List atts = Schemas.getAttributeDeclarations(element);
        Iterator itr = atts.iterator();
        while (itr.hasNext()) {
            XSDAttributeDeclaration att = (XSDAttributeDeclaration)itr.next();
            if (!Schemas.nameMatches((XSDNamedComponent)att, qName)) continue;
            return att;
        }
        return null;
    }

    public static final List getImports(XSDSchema schema) {
        LinkedList<XSDSchema> queue = new LinkedList<XSDSchema>();
        ArrayList<XSDImport> imports = new ArrayList<XSDImport>();
        HashSet<String> added = new HashSet<String>();
        queue.addLast(schema);
        while (!queue.isEmpty()) {
            schema = (XSDSchema)queue.removeFirst();
            EList contents = schema.getContents();
            Iterator itr = contents.iterator();
            while (itr.hasNext()) {
                XSDImport imprt;
                XSDSchemaContent content = (XSDSchemaContent)itr.next();
                if (!(content instanceof XSDImport) || added.contains((imprt = (XSDImport)content).getNamespace())) continue;
                imports.add(imprt);
                added.add(imprt.getNamespace());
                queue.addLast(imprt.getResolvedSchema());
            }
        }
        return imports;
    }

    public static final List getIncludes(XSDSchema schema) {
        LinkedList<XSDSchema> queue = new LinkedList<XSDSchema>();
        ArrayList<XSDInclude> includes = new ArrayList<XSDInclude>();
        HashSet<String> added = new HashSet<String>();
        queue.addLast(schema);
        while (!queue.isEmpty()) {
            schema = (XSDSchema)queue.removeFirst();
            EList contents = schema.getContents();
            Iterator itr = contents.iterator();
            while (itr.hasNext()) {
                XSDInclude include;
                XSDSchemaContent content = (XSDSchemaContent)itr.next();
                if (!(content instanceof XSDInclude) || added.contains((include = (XSDInclude)content).getSchemaLocation())) continue;
                XSDSchema incorporated = include.getIncorporatedSchema();
                if (incorporated != null) {
                    includes.add(include);
                    added.add(include.getSchemaLocation());
                    queue.addLast(incorporated);
                    continue;
                }
                String msg = "Could not find included schema: " + include.getSchemaLocation();
                LOGGER.warning(msg);
            }
        }
        return includes;
    }

    public static XSDElementDeclaration getElementDeclaration(XSDSchema schema, QName name) {
        Iterator e = schema.getElementDeclarations().iterator();
        while (e.hasNext()) {
            XSDElementDeclaration element = (XSDElementDeclaration)e.next();
            if (!element.getTargetNamespace().equals(name.getNamespaceURI()) || !element.getName().equals(name.getLocalPart())) continue;
            return element;
        }
        return null;
    }

    public static final boolean nameMatches(XSDNamedComponent component, QName qName) {
        String ns1 = component.getTargetNamespace();
        String ns2 = qName.getNamespaceURI();
        String n1 = component.getName();
        String n2 = qName.getLocalPart();
        ns1 = "".equals(ns1) ? null : ns1;
        ns2 = "".equals(ns2) ? null : ns2;
        n1 = "".equals(n1) ? null : n1;
        String string = n2 = "".equals(n2) ? null : n2;
        if (ns1 == null && ns2 != null && component.getSchema() != null && "".equals(ns1 = component.getSchema().getTargetNamespace())) {
            ns1 = null;
        }
        return Utilities.equals((Object)ns1, (Object)ns2) && Utilities.equals((Object)n1, (Object)n2);
    }

    public static String getTargetPrefix(XSDSchema schema) {
        String ns = schema.getTargetNamespace();
        Map pre2ns = schema.getQNamePrefixToNamespaceMap();
        Iterator itr = pre2ns.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            if (entry.getKey() == null || !entry.getValue().equals(ns)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public static List getComponentInstancesOfType(PicoContainer container, Class clazz) {
        ArrayList instances = new ArrayList();
        while (container != null) {
            List l = container.getComponentInstancesOfType(clazz);
            instances.addAll(l);
            container = container.getParent();
        }
        return instances;
    }

    public static void unregisterComponent(PicoContainer container, final Object key) {
        while (container.getParent() != null) {
            container = container.getParent();
        }
        container.accept(new PicoVisitor(){

            public Object traverse(Object node) {
                return null;
            }

            public void visitContainer(PicoContainer container) {
                if (container instanceof MutablePicoContainer) {
                    ((MutablePicoContainer)container).unregisterComponent(key);
                }
            }

            public void visitComponentAdapter(ComponentAdapter adapter) {
            }

            public void visitParameter(Parameter parameter) {
            }
        });
    }

    static {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
    }

    static class SchemaLocationResolverAdapter
    extends AdapterImpl
    implements XSDSchemaLocationResolver {
        List resolvers;

        public SchemaLocationResolverAdapter(List resolvers) {
            this.resolvers = resolvers;
        }

        public boolean isAdapterForType(Object type) {
            return type == (class$org$eclipse$xsd$util$XSDSchemaLocationResolver == null ? (class$org$eclipse$xsd$util$XSDSchemaLocationResolver = Schemas.class$("org.eclipse.xsd.util.XSDSchemaLocationResolver")) : class$org$eclipse$xsd$util$XSDSchemaLocationResolver);
        }

        public String resolveSchemaLocation(XSDSchema schema, String namespaceURI, String rawSchemaLocationURI) {
            for (int i = 0; i < this.resolvers.size(); ++i) {
                XSDSchemaLocationResolver resolver = (XSDSchemaLocationResolver)this.resolvers.get(i);
                String resolved = resolver.resolveSchemaLocation(schema, namespaceURI, rawSchemaLocationURI);
                if (resolved == null) continue;
                return resolved;
            }
            if (rawSchemaLocationURI != null || rawSchemaLocationURI.startsWith("http://") || rawSchemaLocationURI.startsWith("file:")) {
                LOGGER.warning("Using the provided absolute URI as the location for namespace '" + namespaceURI + "', as it couldn't be resolved for the provided location path '" + rawSchemaLocationURI + "'");
                return rawSchemaLocationURI;
            }
            LOGGER.warning("Could not resolve schema location: " + rawSchemaLocationURI + " to physical location.");
            return null;
        }
    }

    static class SchemaLocationResolverAdapterFactory
    extends AdapterFactoryImpl {
        SchemaLocationResolverAdapter adapter;

        public SchemaLocationResolverAdapterFactory(List resolvers) {
            this.adapter = new SchemaLocationResolverAdapter(resolvers);
        }

        public boolean isFactoryForType(Object type) {
            return type == (class$org$eclipse$xsd$util$XSDSchemaLocationResolver == null ? (class$org$eclipse$xsd$util$XSDSchemaLocationResolver = Schemas.class$("org.eclipse.xsd.util.XSDSchemaLocationResolver")) : class$org$eclipse$xsd$util$XSDSchemaLocationResolver);
        }

        public Adapter adaptNew(Notifier notifier, Object type) {
            return this.adapter;
        }
    }

    static class SchemaLocatorAdapter
    extends AdapterImpl
    implements XSDSchemaLocator {
        List locators;

        public SchemaLocatorAdapter(List locators) {
            this.locators = locators;
        }

        public boolean isAdapterForType(Object type) {
            return type == (class$org$eclipse$xsd$util$XSDSchemaLocator == null ? (class$org$eclipse$xsd$util$XSDSchemaLocator = Schemas.class$("org.eclipse.xsd.util.XSDSchemaLocator")) : class$org$eclipse$xsd$util$XSDSchemaLocator);
        }

        public XSDSchema locateSchema(XSDSchema xsdSchema, String namespaceURI, String rawSchemaLocationURI, String resolvedSchemaLocationURI) {
            for (int i = 0; i < this.locators.size(); ++i) {
                XSDSchemaLocator locator = (XSDSchemaLocator)this.locators.get(i);
                XSDSchema schema = locator.locateSchema(xsdSchema, namespaceURI, rawSchemaLocationURI, resolvedSchemaLocationURI);
                if (schema == null) continue;
                return schema;
            }
            return null;
        }
    }

    static class SchemaLocatorAdapterFactory
    extends AdapterFactoryImpl {
        SchemaLocatorAdapter adapter;

        public SchemaLocatorAdapterFactory(List locators) {
            this.adapter = new SchemaLocatorAdapter(locators);
        }

        public boolean isFactoryForType(Object type) {
            return type == (class$org$eclipse$xsd$util$XSDSchemaLocator == null ? (class$org$eclipse$xsd$util$XSDSchemaLocator = Schemas.class$("org.eclipse.xsd.util.XSDSchemaLocator")) : class$org$eclipse$xsd$util$XSDSchemaLocator);
        }

        public Adapter adaptNew(Notifier notifier, Object type) {
            return this.adapter;
        }
    }

    private static interface ElementVisitor {
        public void visit(XSDParticle var1);
    }
}

