/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.collections.MultiHashMap;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.geotools.xml.Encoder;
import org.geotools.xml.PropertyExtractor;
import org.geotools.xml.impl.GetPropertiesExecutor;
import org.geotools.xml.impl.GetPropertyExecutor;
import org.picocontainer.MutablePicoContainer;

public class BindingPropertyExtractor
implements PropertyExtractor {
    Encoder encoder;
    MutablePicoContainer context;

    public BindingPropertyExtractor(Encoder encoder, MutablePicoContainer context) {
        this.encoder = encoder;
        this.context = context;
    }

    public boolean canHandle(Object object) {
        return true;
    }

    public void setContext(MutablePicoContainer context) {
        this.context = context;
    }

    public List properties(Object object, XSDElementDeclaration element) {
        ArrayList<Object[]> properties = new ArrayList<Object[]>();
        List children = this.encoder.getSchemaIndex().getChildElementParticles(element);
        Iterator itr = children.iterator();
        while (itr.hasNext()) {
            XSDParticle particle = (XSDParticle)itr.next();
            XSDElementDeclaration child = (XSDElementDeclaration)particle.getContent();
            if (child.isElementDeclarationReference()) {
                child = child.getResolvedElementDeclaration();
            }
            GetPropertyExecutor executor = new GetPropertyExecutor(object, (XSDNamedComponent)child);
            this.encoder.getBindingWalker().walk((XSDFeature)element, executor, this.context);
            if (executor.getChildObject() == null) continue;
            properties.add(new Object[]{particle, executor.getChildObject()});
        }
        GetPropertiesExecutor executor = new GetPropertiesExecutor(object);
        this.encoder.getBindingWalker().walk((XSDFeature)element, executor, this.context);
        if (!executor.getProperties().isEmpty()) {
            QName name;
            MultiHashMap map = new MultiHashMap();
            Iterator p = executor.getProperties().iterator();
            while (p.hasNext()) {
                Object[] property = (Object[])p.next();
                map.put(property[0], property[1]);
            }
            HashMap<QName, XSDParticle> particles = new HashMap<QName, XSDParticle>();
            Iterator e = map.entrySet().iterator();
            while (e.hasNext()) {
                Map.Entry entry = (Map.Entry)e.next();
                name = (QName)entry.getKey();
                Collection values = (Collection)entry.getValue();
                XSDElementDeclaration elementDecl = this.encoder.getSchemaIndex().getElementDeclaration(name);
                if (elementDecl == null) {
                    elementDecl = this.encoder.getSchema().resolveElementDeclaration(name.getNamespaceURI(), name.getLocalPart());
                }
                XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
                particle.setContent((XSDParticleContent)elementDecl);
                if (values.size() > 1) {
                    particle.setMaxOccurs(-1);
                } else {
                    particle.setMaxOccurs(1);
                }
                particles.put(name, particle);
            }
            Iterator p2 = executor.getProperties().iterator();
            while (p2.hasNext()) {
                Object[] property = (Object[])p2.next();
                name = (QName)property[0];
                XSDParticle particle = (XSDParticle)particles.get(name);
                if (particle == null) continue;
                Collection values = (Collection)map.get((Object)name);
                if (values.size() > 1) {
                    properties.add(new Object[]{particle, values});
                } else {
                    properties.add(new Object[]{particle, values.iterator().next()});
                }
                particles.remove(name);
            }
        }
        return properties;
    }
}

