/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.xml.Binding;
import org.geotools.xml.Schemas;
import org.geotools.xml.impl.BindingLoader;
import org.geotools.xml.impl.TypeWalker;
import org.geotools.xs.bindings.XS;
import org.picocontainer.MutablePicoContainer;

public class BindingWalker
implements TypeWalker.Visitor {
    BindingLoader loader;
    HashMap chains;
    TypeWalker typeWalker;
    MutablePicoContainer context;
    ArrayList bindings;
    XSDFeature component;
    XSDTypeDefinition container;

    public BindingWalker(BindingLoader factory) {
        this.loader = factory;
        this.chains = new HashMap();
        this.typeWalker = new TypeWalker();
    }

    public boolean visit(XSDTypeDefinition type) {
        QName bindingName = null;
        if (type.getName() != null) {
            bindingName = new QName(type.getTargetNamespace(), type.getName());
        } else {
            XSDElementDeclaration anonymous;
            XSDParticle particle;
            Iterator e = type.getSchema().getElementDeclarations().iterator();
            while (e.hasNext()) {
                XSDElementDeclaration element = (XSDElementDeclaration)e.next();
                if (!type.equals(element.getAnonymousTypeDefinition())) continue;
                bindingName = new QName(type.getTargetNamespace(), "_" + element.getName());
                break;
            }
            if (bindingName == null && this.container != null && type.getContainer() instanceof XSDElementDeclaration && (particle = Schemas.getChildElementParticle(this.container, (anonymous = (XSDElementDeclaration)type.getContainer()).getName(), true)) != null) {
                bindingName = new QName(this.container.getTargetNamespace(), this.container.getName() + "_" + anonymous.getName());
            }
            if ((bindingName == null || this.loader.getBinding(bindingName) == null) && type instanceof XSDComplexTypeDefinition && type.getBaseType() instanceof XSDSimpleTypeDefinition) {
                bindingName = XS.ANYTYPE;
            }
        }
        Binding binding = this.loader.loadBinding(bindingName, this.context);
        if (binding != null) {
            this.bindings.add(binding);
            if (binding.getExecutionMode() == 2) {
                return false;
            }
        }
        return true;
    }

    public void walk(XSDFeature component, Visitor visitor, XSDTypeDefinition container, MutablePicoContainer context) {
        BindingExecutionChain chain = (BindingExecutionChain)this.chains.get(component);
        if (chain == null) {
            QName qName;
            Binding binding;
            this.container = container;
            this.component = component;
            this.context = context;
            this.bindings = new ArrayList();
            this.typeWalker.walk(component.getType(), this);
            if (component.getName() != null && (binding = this.loader.loadBinding(qName = new QName(component.getTargetNamespace(), component.getName()), context)) != null) {
                if (binding.getExecutionMode() == 2) {
                    this.bindings.clear();
                    this.bindings.add(binding);
                } else {
                    this.bindings.add(0, binding);
                }
            }
            chain = new BindingExecutionChain(this.bindings);
            this.chains.put(component, chain);
        }
        chain.execute(visitor);
    }

    public void walk(XSDFeature component, Visitor visitor, MutablePicoContainer context) {
        this.walk(component, visitor, null, context);
    }

    public static class BindingExecutionChain {
        List bindings;

        public BindingExecutionChain(List bindings) {
            this.bindings = bindings;
        }

        public void execute(Visitor visitor) {
            Stack<Binding> stack = new Stack<Binding>();
            for (int i = 0; i < this.bindings.size(); ++i) {
                Binding binding = (Binding)this.bindings.get(i);
                if (binding.getExecutionMode() == 0) {
                    stack.push(binding);
                    continue;
                }
                visitor.visit(binding);
            }
            while (!stack.isEmpty()) {
                Binding binding = (Binding)stack.pop();
                visitor.visit(binding);
            }
        }
    }

    public static interface Visitor {
        public void visit(Binding var1);
    }
}

