/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.geotools.xml.InstanceComponent;
import org.geotools.xml.Node;

public class NodeImpl
implements Node {
    private InstanceComponent component;
    private Object value;
    List children;
    List attributes;

    public NodeImpl(InstanceComponent component) {
        this.component = component;
        this.children = new ArrayList();
        this.attributes = new ArrayList();
    }

    public NodeImpl(InstanceComponent component, Object value) {
        this(component);
        this.value = value;
    }

    public InstanceComponent getComponent() {
        return this.component;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean hasChild(String name) {
        if (name == null) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            Node child = (Node)this.children.get(i);
            if (!name.equals(child.getComponent().getName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasChild(Class clazz) {
        if (clazz == null) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            Node child = (Node)this.children.get(i);
            if (child.getValue() == null || !clazz.isAssignableFrom(child.getValue().getClass())) continue;
            return true;
        }
        return false;
    }

    public List getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public int getNChildren() {
        return this.children.size();
    }

    public List getChildren(String name) {
        ArrayList<Node> matches = new ArrayList<Node>();
        if (name == null) {
            return matches;
        }
        Iterator itr = this.children.iterator();
        while (itr.hasNext()) {
            Node child = (Node)itr.next();
            if (!name.equals(child.getComponent().getName())) continue;
            matches.add(child);
        }
        return matches;
    }

    public List getChildren(Class clazz) {
        ArrayList<Node> matches = new ArrayList<Node>();
        if (clazz == null) {
            return matches;
        }
        Iterator itr = this.children.iterator();
        while (itr.hasNext()) {
            Node child = (Node)itr.next();
            if (child.getValue() == null || !clazz.isAssignableFrom(child.getValue().getClass())) continue;
            matches.add(child);
        }
        return matches;
    }

    public Node getChild(String name) {
        if (name == null) {
            return null;
        }
        Iterator itr = this.children.iterator();
        while (itr.hasNext()) {
            Node child = (Node)itr.next();
            if (!name.equals(child.getComponent().getName())) continue;
            return child;
        }
        return null;
    }

    public Node getChild(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Iterator itr = this.children.iterator();
        while (itr.hasNext()) {
            Node child = (Node)itr.next();
            if (child.getValue() == null || !clazz.isAssignableFrom(child.getValue().getClass())) continue;
            return child;
        }
        return null;
    }

    public boolean hasAttribute(Class clazz) {
        if (clazz == null) {
            return false;
        }
        Iterator itr = this.attributes.iterator();
        while (itr.hasNext()) {
            Node att = (Node)itr.next();
            if (att.getValue() == null || !clazz.isAssignableFrom(att.getValue().getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttribute(String name) {
        if (name == null) {
            return false;
        }
        Iterator itr = this.attributes.iterator();
        while (itr.hasNext()) {
            Node att = (Node)itr.next();
            if (!name.equals(att.getComponent().getName())) continue;
            return true;
        }
        return false;
    }

    public List getAttributes() {
        return new ArrayList(this.attributes);
    }

    public List getAttributes(Class clazz) {
        ArrayList<Node> matches = new ArrayList<Node>();
        if (clazz == null) {
            return matches;
        }
        Iterator a = this.attributes.iterator();
        while (a.hasNext()) {
            Node att = (Node)a.next();
            if (att.getValue() == null || !clazz.isAssignableFrom(att.getValue().getClass())) continue;
            matches.add(att);
        }
        return matches;
    }

    public int getNAttributes() {
        return this.attributes.size();
    }

    public Node getAttribute(String name) {
        if (name == null) {
            return null;
        }
        Iterator itr = this.attributes.iterator();
        while (itr.hasNext()) {
            Node att = (Node)itr.next();
            if (!name.equals(att.getComponent().getName())) continue;
            return att;
        }
        return null;
    }

    public Node getAttribute(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Iterator itr = this.attributes.iterator();
        while (itr.hasNext()) {
            Node att = (Node)itr.next();
            if (att.getValue() == null || !clazz.isAssignableFrom(att.getValue().getClass())) continue;
            return att;
        }
        return null;
    }

    public Object getAttributeValue(String name) {
        Node node = this.getAttribute(name);
        if (node != null) {
            return node.getValue();
        }
        return null;
    }

    public Object getAttributeValue(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Iterator a = this.attributes.iterator();
        while (a.hasNext()) {
            Node att = (Node)a.next();
            if (att.getValue() == null || !clazz.isAssignableFrom(att.getValue().getClass())) continue;
            return att.getValue();
        }
        return null;
    }

    public List getAttributeValues(Class clazz) {
        ArrayList<Object> matches = new ArrayList<Object>();
        if (clazz == null) {
            return matches;
        }
        Iterator a = this.attributes.iterator();
        while (a.hasNext()) {
            Node att = (Node)a.next();
            if (att.getValue() == null || !clazz.isAssignableFrom(att.getValue().getClass())) continue;
            matches.add(att.getValue());
        }
        return matches;
    }

    public String toString() {
        return this.getComponent().getName() + "=" + this.getValue();
    }

    public Object getChildValue(int index) {
        return ((Node)this.children.get(index)).getValue();
    }

    public Object getChildValue(String name) {
        Node node = this.getChild(name);
        if (node != null) {
            return node.getValue();
        }
        return null;
    }

    public Object getChildValue(Class clazz) {
        Node node = this.getChild(clazz);
        if (node != null) {
            return node.getValue();
        }
        return null;
    }

    public List getChildValues(String name) {
        ArrayList<Object> matches = new ArrayList<Object>();
        if (name == null) {
            return matches;
        }
        Iterator itr = this.children.iterator();
        while (itr.hasNext()) {
            Node child = (Node)itr.next();
            if (!name.equals(child.getComponent().getName())) continue;
            matches.add(child.getValue());
        }
        return matches;
    }

    public List getChildValues(Class clazz) {
        ArrayList<Object> matches = new ArrayList<Object>();
        if (clazz == null) {
            return matches;
        }
        Iterator itr = this.children.iterator();
        while (itr.hasNext()) {
            Node child = (Node)itr.next();
            Object parsed = child.getValue();
            if (parsed == null || !clazz.isAssignableFrom(parsed.getClass())) continue;
            matches.add(parsed);
        }
        return matches;
    }

    public void addChild(Node child) {
        this.children.add(child);
    }

    public Node removeChild(String name) {
        Node child = this.getChild(name);
        if (child != null) {
            this.children.remove(child);
        }
        return child;
    }

    public void removeChild(Node child) {
        this.children.remove(child);
    }

    public void addAttribute(Node attribute) {
        this.attributes.add(attribute);
    }

    public Node removeAttribute(String name) {
        Node attribute = this.getAttribute(name);
        if (attribute != null) {
            this.attributes.remove(attribute);
        }
        return attribute;
    }
}

