/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDSchemaLocationResolver;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.geotools.util.logging.Logging;
import org.geotools.xml.BindingFactory;
import org.geotools.xml.Configuration;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.SchemaIndex;
import org.geotools.xml.Schemas;
import org.geotools.xml.impl.BindingFactoryImpl;
import org.geotools.xml.impl.BindingLoader;
import org.geotools.xml.impl.BindingWalker;
import org.geotools.xml.impl.BindingWalkerFactoryImpl;
import org.geotools.xml.impl.DocumentHandler;
import org.geotools.xml.impl.ElementHandler;
import org.geotools.xml.impl.ElementHandlerImpl;
import org.geotools.xml.impl.Handler;
import org.geotools.xml.impl.HandlerFactory;
import org.geotools.xml.impl.HandlerFactoryImpl;
import org.geotools.xml.impl.NamespaceSupportWrapper;
import org.geotools.xml.impl.SchemaIndexImpl;
import org.geotools.xs.bindings.XS;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class ParserHandler
extends DefaultHandler {
    protected Stack handlers;
    NamespaceSupport namespaces;
    XSDSchema[] schemas;
    SchemaIndex index;
    HandlerFactory handlerFactory;
    BindingLoader bindingLoader;
    BindingWalker bindingWalker;
    BindingFactory bindingFactory;
    DocumentHandler documentHandler;
    Configuration config;
    MutablePicoContainer context;
    Logger logger;
    boolean validating;
    boolean strict = false;
    List errors;

    public ParserHandler(Configuration config) {
        this.config = config;
        this.errors = new ArrayList();
        this.namespaces = new NamespaceSupport();
        this.validating = false;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public List getValidationErrors() {
        return this.errors;
    }

    public HandlerFactory getHandlerFactory() {
        return this.handlerFactory;
    }

    public BindingLoader getBindingLoader() {
        return this.bindingLoader;
    }

    public BindingWalker getBindingWalker() {
        return this.bindingWalker;
    }

    public BindingFactory getBindingFactory() {
        return this.bindingFactory;
    }

    public XSDSchema[] getSchemas() {
        return this.schemas;
    }

    public SchemaIndex getSchemaIndex() {
        return this.index;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public NamespaceSupport getNamespaceSupport() {
        return this.namespaces;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaces.declarePrefix(prefix, uri);
    }

    public void startDocument() throws SAXException {
        this.configure(this.config);
        DocumentHandler docHandler = this.handlerFactory.createDocumentHandler(this);
        this.context = new DefaultPicoContainer();
        this.context = this.config.setupContext(this.context);
        docHandler.setContext(this.context);
        this.handlers = new Stack();
        this.handlers.push(docHandler);
        this.logger = (Logger)this.context.getComponentInstanceOfType(Logger.class);
        if (this.logger == null) {
            this.logger = Logging.getLogger((String)"org.geotools.xml");
            this.context.registerComponentInstance((Object)this.logger);
        }
        this.context.registerComponentInstance((Object)this.namespaces);
        this.context.registerComponentInstance((Object)new NamespaceSupportWrapper(this.namespaces));
        this.bindingFactory = new BindingFactoryImpl(this.bindingLoader);
        this.context.registerComponentInstance((Object)this.bindingFactory);
        this.context.registerComponentInstance((Object)new BindingWalkerFactoryImpl(this.bindingLoader, this.context));
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        XSDElementDeclaration element;
        this.logger.finest("startElement(" + uri + "," + localName + "," + qName);
        if (this.schemas == null) {
            int i;
            String[] locations = null;
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                String name = attributes.getQName(i2);
                if (!name.endsWith("schemaLocation")) continue;
                locations = attributes.getValue(i2).split(" +");
                break;
            }
            if (!this.isStrict() && locations == null) {
                locations = new String[]{this.config.getNamespaceURI(), this.config.getSchemaFileURL()};
            }
            XSDSchemaLocator[] locators = this.findSchemaLocators();
            XSDSchemaLocationResolver[] resolvers = this.findSchemaLocationResolvers();
            if (locations != null && locations.length > 0) {
                this.schemas = new XSDSchema[locations.length / 2];
                for (i = 0; i < locations.length; i += 2) {
                    int j;
                    String namespace = locations[i];
                    String location = locations[i + 1];
                    for (j = 0; j < resolvers.length; ++j) {
                        String override = resolvers[j].resolveSchemaLocation(null, namespace, location);
                        if (override == null) continue;
                        location = override;
                        break;
                    }
                    for (j = 0; j < locators.length; ++j) {
                        XSDSchema schema = locators[j].locateSchema(null, namespace, location, null);
                        if (schema == null) continue;
                        this.schemas[i / 2] = schema;
                        break;
                    }
                    if (this.schemas[i / 2] != null) continue;
                    try {
                        this.schemas[i / 2] = Schemas.parse(location, locators, resolvers);
                        continue;
                    }
                    catch (Exception e) {
                        String msg = "Error parsing: " + location;
                        this.logger.warning(msg);
                        throw (SAXException)new SAXException(msg).initCause(e);
                    }
                }
            } else {
                for (i = 0; i < locators.length; ++i) {
                    XSDSchema schema = locators[i].locateSchema(null, uri, null, null);
                    if (schema == null) continue;
                    this.schemas = new XSDSchema[]{schema};
                    break;
                }
            }
            if (this.schemas == null) {
                String msg = "Could not find a schemaLocation attribute or appropriate locator";
                throw new SAXException(msg);
            }
            boolean found = false;
            block7: for (int i3 = 0; i3 < this.schemas.length; ++i3) {
                List imports = Schemas.getImports(this.schemas[i3]);
                Iterator im = imports.iterator();
                while (im.hasNext()) {
                    XSDImport imprt = (XSDImport)im.next();
                    if (!this.config.getNamespaceURI().equals(imprt.getNamespace())) continue;
                    found = true;
                    break block7;
                }
            }
            if (!found) {
                if (!this.isStrict()) {
                    this.logger.fine("schema specified by parser configuration not found, supplementing...");
                    XSDSchema[] copy = new XSDSchema[this.schemas.length + 1];
                    System.arraycopy(this.schemas, 0, copy, 0, this.schemas.length);
                    copy[this.schemas.length] = this.config.schema();
                    this.schemas = copy;
                } else {
                    String msg = "parser configuration specified schema: '" + this.config.getNamespaceURI() + "', but instance document does not reference this schema.";
                    this.logger.info(msg);
                }
            }
            this.index = new SchemaIndexImpl(this.schemas);
            if (this.namespaces.getURI("") == null) {
                this.namespaces.declarePrefix("", this.config.getNamespaceURI());
            }
        }
        this.namespaces.pushContext();
        if (uri == null || uri.equals("")) {
            uri = this.namespaces.getURI("");
        }
        QName qualifiedName = new QName(uri, localName);
        Handler parent = (Handler)this.handlers.peek();
        ElementHandler handler = (ElementHandler)parent.createChildHandler(qualifiedName);
        if (handler == null && (element = this.index.getElementDeclaration(qualifiedName)) != null) {
            handler = this.handlerFactory.createElementHandler(element, parent, this);
        }
        if (handler == null) {
            List handlerFactories = this.context.getComponentInstancesOfType(HandlerFactory.class);
            Iterator hf = handlerFactories.iterator();
            while (handler == null && hf.hasNext()) {
                HandlerFactory handlerFactory = (HandlerFactory)hf.next();
                handler = handlerFactory.createElementHandler(qualifiedName, parent, this);
            }
        }
        if (handler == null && !this.isStrict()) {
            ElementInstance parentElement;
            List childParticles;
            String msg = "Could not find declaration for: " + qualifiedName + ". Checking if containing type declares a single particle.";
            this.logger.fine(msg);
            if (parent.getComponent() instanceof ElementInstance && (childParticles = this.index.getChildElementParticles((parentElement = (ElementInstance)parent.getComponent()).getElementDeclaration())).size() == 1) {
                XSDParticle particle = (XSDParticle)childParticles.iterator().next();
                XSDElementDeclaration child = (XSDElementDeclaration)particle.getContent();
                if (child.isElementDeclarationReference()) {
                    child = child.getResolvedElementDeclaration();
                }
                handler = this.handlerFactory.createElementHandler(new QName(child.getTargetNamespace(), child.getName()), parent, this);
            }
        }
        if (handler == null && !this.isStrict()) {
            String msg = "Could not find declaration for: " + qualifiedName + ". Performing lookup by ignoring namespace";
            this.logger.fine(msg);
            handler = (ElementHandler)parent.createChildHandler(new QName("*", qualifiedName.getLocalPart()));
        }
        if (handler == null && !this.isStrict()) {
            String msg = "Could not find declaration for: " + qualifiedName + ". Creating a mock element declaration and parsing anyways...";
            this.logger.fine(msg);
            XSDElementDeclaration decl = XSDFactory.eINSTANCE.createXSDElementDeclaration();
            decl.setName(qualifiedName.getLocalPart());
            decl.setTargetNamespace(qualifiedName.getNamespaceURI());
            XSDTypeDefinition type = this.index.getTypeDefinition(XS.ANYTYPE);
            decl.setTypeDefinition(type);
            handler = new ElementHandlerImpl(decl, parent, this);
        }
        if (handler != null) {
            if (handler.getElementDeclaration().getTargetNamespace() != null && !handler.getElementDeclaration().getTargetNamespace().equals(uri) && !handler.getElementDeclaration().isAbstract()) {
                this.namespaces.declarePrefix("", handler.getElementDeclaration().getTargetNamespace());
                qualifiedName = new QName(handler.getElementDeclaration().getTargetNamespace(), qualifiedName.getLocalPart());
            }
        } else {
            String msg = "Handler for " + qName + " could not be found.";
            throw new SAXException(msg);
        }
        handler.startElement(qualifiedName, attributes);
        this.handlers.push(handler);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        ElementHandler handler = (ElementHandler)this.handlers.peek();
        handler.characters(ch, start, length);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        ElementHandler handler = (ElementHandler)this.handlers.pop();
        QName qualifiedName = new QName(uri, localName);
        handler.endElement(qualifiedName);
        this.endElementInternal(handler);
        this.namespaces.popContext();
    }

    protected void endElementInternal(ElementHandler handler) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endDocument() throws SAXException {
        this.documentHandler = (DocumentHandler)this.handlers.pop();
        ParserHandler parserHandler = this;
        synchronized (parserHandler) {
            this.notifyAll();
        }
    }

    public void warning(SAXParseException e) throws SAXException {
    }

    public void error(SAXParseException e) throws SAXException {
        this.logger.log(Level.WARNING, e.getMessage());
        this.errors.add(e);
    }

    public Object getValue() {
        return this.documentHandler.getParseNode().getValue();
    }

    protected void configure(Configuration config) {
        this.handlerFactory = new HandlerFactoryImpl();
        this.bindingLoader = new BindingLoader();
        this.bindingWalker = new BindingWalker(this.bindingLoader);
        MutablePicoContainer container = this.bindingLoader.getContainer();
        container = config.setupBindings(container);
        this.bindingLoader.setContainer(container);
    }

    protected XSDSchemaLocator[] findSchemaLocators() {
        List l = Schemas.getComponentInstancesOfType((PicoContainer)this.context, XSDSchemaLocator.class);
        if (l == null || l.isEmpty()) {
            return new XSDSchemaLocator[0];
        }
        return l.toArray(new XSDSchemaLocator[l.size()]);
    }

    protected XSDSchemaLocationResolver[] findSchemaLocationResolvers() {
        List l = Schemas.getComponentInstancesOfType((PicoContainer)this.context, XSDSchemaLocationResolver.class);
        if (l == null || l.isEmpty()) {
            return new XSDSchemaLocationResolver[0];
        }
        return l.toArray(new XSDSchemaLocationResolver[l.size()]);
    }
}

