/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import junit.framework.TestCase;
import org.eclipse.xsd.XSDSchema;
import org.geotools.util.logging.Logging;
import org.geotools.xml.Binding;
import org.geotools.xml.Configuration;
import org.geotools.xml.DOMParser;
import org.geotools.xml.Encoder;
import org.geotools.xml.impl.BindingFactoryImpl;
import org.geotools.xml.impl.BindingLoader;
import org.geotools.xml.impl.BindingWalkerFactoryImpl;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class XMLTestSupport
extends TestCase {
    protected static Logger logger = Logging.getLogger((String)"org.geotools.xml.test");
    protected Document document;

    protected void setUp() throws Exception {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        this.document = docFactory.newDocumentBuilder().newDocument();
    }

    protected void registerNamespaces(Element root) {
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
    }

    protected abstract Configuration createConfiguration();

    protected Object parse() throws Exception {
        Element root = this.document.getDocumentElement();
        if (root == null) {
            throw new IllegalStateException("Document has no root element");
        }
        Configuration config = this.createConfiguration();
        this.registerNamespaces(root);
        root.setAttribute("xsi:schemaLocation", config.getNamespaceURI() + " " + config.getSchemaFileURL());
        DOMParser parser = new DOMParser(config, this.document);
        return parser.parse();
    }

    protected Document encode(Object object, QName element) throws Exception {
        Configuration configuration = this.createConfiguration();
        XSDSchema schema = configuration.getSchemaLocator().locateSchema(null, configuration.getNamespaceURI(), null, null);
        Encoder encoder = new Encoder(configuration, schema);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        encoder.write(object, element, output);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        return dbf.newDocumentBuilder().parse(new ByteArrayInputStream(output.toByteArray()));
    }

    protected void print(Node dom) throws Exception {
        TransformerFactory txFactory = TransformerFactory.newInstance();
        Transformer tx = txFactory.newTransformer();
        tx.setOutputProperty("indent", "yes");
        tx.transform(new DOMSource(dom), new StreamResult(System.out));
    }

    protected Binding binding(QName name) {
        Configuration configuration = this.createConfiguration();
        DefaultPicoContainer context = new DefaultPicoContainer();
        context = configuration.setupContext((MutablePicoContainer)context);
        BindingLoader bindingLoader = new BindingLoader();
        MutablePicoContainer container = bindingLoader.getContainer();
        container = configuration.setupBindings(container);
        bindingLoader.setContainer(container);
        context.registerComponentInstance((Object)new BindingFactoryImpl(bindingLoader));
        context.registerComponentInstance((Object)new BindingWalkerFactoryImpl(bindingLoader, (MutablePicoContainer)context));
        context.registerComponentInstance((Object)logger);
        return bindingLoader.loadBinding(name, (MutablePicoContainer)context);
    }
}

