/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.bindings;

import javax.xml.bind.ValidationException;
import javax.xml.namespace.QName;
import org.geotools.xml.InstanceComponent;
import org.geotools.xml.SimpleBinding;
import org.geotools.xs.bindings.XS;

public class XSBooleanBinding
implements SimpleBinding {
    public QName getTarget() {
        return XS.BOOLEAN;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return Boolean.class;
    }

    public Object parse(InstanceComponent instance, Object value) throws Exception {
        if ("1".equals(value) || "true".equals(value)) {
            return Boolean.TRUE;
        }
        if ("0".equals(value) || "false".equals(value)) {
            return Boolean.FALSE;
        }
        throw new ValidationException("boolean indeterminate from  '" + value + "'");
    }

    public String encode(Object object, String value) {
        Boolean bool = (Boolean)object;
        if (Boolean.TRUE.equals(bool)) {
            return "true";
        }
        if (Boolean.FALSE.equals(bool)) {
            return "false";
        }
        return null;
    }
}

