/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.bindings;

import java.math.BigInteger;
import javax.xml.bind.ValidationException;
import javax.xml.namespace.QName;
import org.geotools.xml.InstanceComponent;
import org.geotools.xml.SimpleBinding;
import org.geotools.xs.bindings.XS;

public class XSNonPositiveIntegerBinding
implements SimpleBinding {
    final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    final BigInteger MIN_INTEGER = BigInteger.valueOf(Integer.MIN_VALUE);

    public QName getTarget() {
        return XS.NONPOSITIVEINTEGER;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return BigInteger.class;
    }

    public Object parse(InstanceComponent instance, Object value) throws Exception {
        BigInteger number = (BigInteger)value;
        if (BigInteger.ZERO.compareTo(number) < 0) {
            throw new ValidationException("Value '" + number + "' must be non-positive (0 or below).");
        }
        if (this.MIN_INTEGER.compareTo(number) <= 0) {
            return new Integer(number.intValue());
        }
        if (this.MIN_LONG.compareTo(number) <= 0) {
            return new Long(number.longValue());
        }
        return number;
    }

    public String encode(Object object, String value) throws Exception {
        Number number = (Number)object;
        if (number.intValue() > 0) {
            throw new ValidationException("Value '" + number + "' must be non-positive (0 or below).");
        }
        return value;
    }
}

