/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.facets;

import java.lang.reflect.Array;
import java.util.Collection;
import javax.xml.bind.ValidationException;
import org.eclipse.xsd.XSDLengthFacet;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public abstract class Length {
    public static final Length CHARACTERS = new Length(){

        public void validate(XSDTypeDefinition definition, Object value) throws ValidationException {
            String text = (String)value;
            if (text.length() > this.length(definition)) {
                throw new ValidationException(text);
            }
        }
    };
    public static final Length OCTETS = new Length(){

        public void validate(XSDTypeDefinition definition, Object value) throws ValidationException {
            String text = (String)value;
            if (text.getBytes().length > this.length(definition)) {
                throw new ValidationException(text);
            }
        }
    };
    public static final Length LIST = new Length(){

        public int length(XSDTypeDefinition definition) {
            try {
                XSDSimpleTypeDefinition simple = definition.getSimpleType();
                XSDLengthFacet facet = simple.getLengthFacet();
                if (facet == null) {
                    return Integer.MAX_VALUE;
                }
                return Integer.parseInt(facet.getLexicalValue());
            }
            catch (NumberFormatException ignore) {
                return Integer.MIN_VALUE;
            }
        }

        public void validate(XSDTypeDefinition definition, Object value) throws ValidationException {
            String text;
            int length = Integer.MIN_VALUE;
            if (value instanceof Collection) {
                length = ((Collection)value).size();
            }
            if (value.getClass().isArray()) {
                length = Array.getLength(value);
            }
            if (value instanceof Integer) {
                length = (Integer)value;
            }
            if ((text = (String)value).getBytes().length > this.length(definition)) {
                throw new ValidationException(text);
            }
        }
    };

    private Length() {
    }

    public int length(XSDTypeDefinition definition) {
        try {
            XSDSimpleTypeDefinition simple = (XSDSimpleTypeDefinition)definition;
            XSDLengthFacet facet = simple.getLengthFacet();
            if (facet == null) {
                return Integer.MAX_VALUE;
            }
            return Integer.parseInt(facet.getLexicalValue());
        }
        catch (NumberFormatException ignore) {
            return Integer.MIN_VALUE;
        }
    }

    public abstract void validate(XSDTypeDefinition var1, Object var2) throws ValidationException;
}

