/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.facets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class Whitespace
implements Comparable {
    public static final Whitespace PRESERVE = new Whitespace("preserve", 0){

        public String preparse(String text) {
            return text;
        }
    };
    public static final Whitespace REPLACE = new Whitespace("replace", 1){

        public String preparse(String text) {
            StringBuffer replace = new StringBuffer(text);
            for (int i = 0; i < replace.length(); ++i) {
                char ch = replace.charAt(i);
                if ('\t' != ch && '\n' != ch && '\r' != ch) continue;
                replace.setCharAt(i, ' ');
            }
            return replace.toString();
        }
    };
    public static final Whitespace COLLAPSE = new Whitespace("collapse", 2){

        public String preparse(String text) {
            text = REPLACE.preparse(text);
            text = text.trim();
            StringBuffer collapse = new StringBuffer(text);
            for (int i = 0; i < collapse.length(); ++i) {
                if (' ' != collapse.charAt(i)) continue;
                ++i;
                while (i < collapse.length() && ' ' == collapse.charAt(i)) {
                    collapse.deleteCharAt(i);
                }
            }
            return collapse.toString();
        }
    };
    private static List values = new ArrayList();
    private int ordinal;
    private String name;

    private Whitespace(String name, int number) {
        this.ordinal = number;
        this.name = name;
    }

    public abstract String preparse(String var1);

    public String name() {
        return this.name;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public int hashCode() {
        return this.ordinal;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Ha Ha");
    }

    public boolean equals(Object other) {
        return other != null && other instanceof Whitespace && ((Whitespace)other).ordinal == this.ordinal;
    }

    public int compareTo(Object other) {
        if (other == null || !(other instanceof Whitespace)) {
            return -1;
        }
        int ord = ((Whitespace)other).ordinal;
        if (this.ordinal == ord) {
            return 0;
        }
        if (this.ordinal < ord) {
            return -1;
        }
        return 1;
    }

    public static Whitespace valueOf(String whitespace) {
        Iterator i = values.iterator();
        while (i.hasNext()) {
            Whitespace item = (Whitespace)i.next();
            if (!whitespace.equals(item.name)) continue;
            return item;
        }
        return null;
    }

    public Class getDeclaringClass() {
        return Whitespace.class;
    }

    public static List values() {
        return values;
    }

    static {
        values.add(PRESERVE);
        values.add(REPLACE);
        values.add(COLLAPSE);
    }
}

