/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webservice.test;

import org.alfresco.webservice.accesscontrol.ACE;
import org.alfresco.webservice.accesscontrol.ACL;
import org.alfresco.webservice.accesscontrol.AccessControlServiceSoapBindingStub;
import org.alfresco.webservice.accesscontrol.AccessStatus;
import org.alfresco.webservice.accesscontrol.AuthorityFilter;
import org.alfresco.webservice.accesscontrol.GetClassPermissionsResult;
import org.alfresco.webservice.accesscontrol.GetPermissionsResult;
import org.alfresco.webservice.accesscontrol.HasPermissionsResult;
import org.alfresco.webservice.accesscontrol.NewAuthority;
import org.alfresco.webservice.accesscontrol.OwnerResult;
import org.alfresco.webservice.accesscontrol.SiblingAuthorityFilter;
import org.alfresco.webservice.administration.NewUserDetails;
import org.alfresco.webservice.test.BaseWebServiceSystemTest;
import org.alfresco.webservice.types.NamedValue;
import org.alfresco.webservice.types.Predicate;
import org.alfresco.webservice.types.Reference;
import org.alfresco.webservice.util.AuthenticationUtils;
import org.alfresco.webservice.util.Constants;
import org.alfresco.webservice.util.WebServiceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AccessControlServiceSystemTest
extends BaseWebServiceSystemTest {
    private static Log logger = LogFactory.getLog(AccessControlServiceSystemTest.class);
    private String userName1 = null;
    private String userName2 = null;
    private AccessControlServiceSoapBindingStub accessControlService = WebServiceFactory.getAccessControlService();
    private int counter = 0;

    private void createUsers() throws Exception {
        this.userName1 = "user1" + System.currentTimeMillis();
        this.userName2 = "user2" + System.currentTimeMillis();
        String homeFolder = store.getScheme() + "://" + store.getAddress() + "/" + folderReference.getUuid();
        NewUserDetails[] newUsers = new NewUserDetails[]{new NewUserDetails(this.userName1, "password", this.createPersonProperties(homeFolder, "first", "middle", "last", "email", "org")), new NewUserDetails(this.userName2, "password", this.createPersonProperties(homeFolder, "first", "middle", "last", "email", "org"))};
        WebServiceFactory.getAdministrationService().createUsers(newUsers);
    }

    private NamedValue[] createPersonProperties(String homeFolder, String firstName, String middleName, String lastName, String email, String orgId) {
        return new NamedValue[]{new NamedValue(Constants.PROP_USER_HOMEFOLDER, false, homeFolder, null), new NamedValue(Constants.PROP_USER_FIRSTNAME, false, firstName, null), new NamedValue(Constants.PROP_USER_MIDDLENAME, false, middleName, null), new NamedValue(Constants.PROP_USER_LASTNAME, false, lastName, null), new NamedValue(Constants.PROP_USER_EMAIL, false, email, null), new NamedValue(Constants.PROP_USER_ORGID, false, orgId, null)};
    }

    private void removeUsers() throws Exception {
        String[] userNames = new String[]{this.userName1, this.userName2};
        WebServiceFactory.getAdministrationService().deleteUsers(userNames);
    }

    public void testGetSetRemoveACEs() throws Exception {
        Predicate predicate = new Predicate(new Reference[]{BaseWebServiceSystemTest.contentReference}, null, null);
        this.createUsers();
        ACL[] acls = this.accessControlService.getACLs(predicate, null);
        AccessControlServiceSystemTest.assertNotNull((Object)acls);
        AccessControlServiceSystemTest.assertEquals((int)1, (int)acls.length);
        ACL acl = acls[0];
        AccessControlServiceSystemTest.assertEquals((String)BaseWebServiceSystemTest.contentReference.getUuid(), (String)acl.getReference().getUuid());
        AccessControlServiceSystemTest.assertEquals((boolean)true, (boolean)acl.isInheritPermissions());
        AccessControlServiceSystemTest.assertNull((Object)acl.getAces());
        ACE[] aces1 = new ACE[]{new ACE(this.userName1, "Read", AccessStatus.acepted), new ACE(this.userName2, "Write", AccessStatus.acepted)};
        ACL[] acls1 = this.accessControlService.addACEs(predicate, aces1);
        AccessControlServiceSystemTest.assertNotNull((Object)acls1);
        AccessControlServiceSystemTest.assertEquals((int)1, (int)acls1.length);
        ACL acl1 = acls1[0];
        AccessControlServiceSystemTest.assertEquals((String)BaseWebServiceSystemTest.contentReference.getUuid(), (String)acl1.getReference().getUuid());
        AccessControlServiceSystemTest.assertEquals((boolean)true, (boolean)acl1.isInheritPermissions());
        AccessControlServiceSystemTest.assertNotNull((Object)acl1.getAces());
        AccessControlServiceSystemTest.assertEquals((int)2, (int)acl1.getAces().length);
        for (ACE ace1 : acl1.getAces()) {
            if (ace1.getAuthority().equals(this.userName1)) {
                AccessControlServiceSystemTest.assertEquals((String)"Read", (String)ace1.getPermission());
                AccessControlServiceSystemTest.assertEquals((Object)AccessStatus.acepted, (Object)ace1.getAccessStatus());
                continue;
            }
            if (ace1.getAuthority().equals(this.userName2)) {
                AccessControlServiceSystemTest.assertEquals((String)"Write", (String)ace1.getPermission());
                AccessControlServiceSystemTest.assertEquals((Object)AccessStatus.acepted, (Object)ace1.getAccessStatus());
                continue;
            }
            AccessControlServiceSystemTest.fail((String)"I wasn't expecting anything else here");
        }
        ACL[] acls3 = this.accessControlService.getACLs(predicate, null);
        AccessControlServiceSystemTest.assertNotNull((Object)acls3);
        AccessControlServiceSystemTest.assertEquals((int)1, (int)acls3.length);
        AccessControlServiceSystemTest.assertNotNull((Object)acls3[0].getAces());
        AccessControlServiceSystemTest.assertEquals((int)2, (int)acls3[0].getAces().length);
        ACE[] aces2 = new ACE[]{new ACE(this.userName1, "Read", AccessStatus.acepted)};
        ACL[] acls4 = this.accessControlService.removeACEs(predicate, aces2);
        AccessControlServiceSystemTest.assertNotNull((Object)acls4);
        AccessControlServiceSystemTest.assertEquals((int)1, (int)acls4.length);
        AccessControlServiceSystemTest.assertNotNull((Object)acls4[0].getAces());
        AccessControlServiceSystemTest.assertEquals((int)1, (int)acls4[0].getAces().length);
        ACL[] acls5 = this.accessControlService.getACLs(predicate, null);
        AccessControlServiceSystemTest.assertNotNull((Object)acls5);
        AccessControlServiceSystemTest.assertEquals((int)1, (int)acls5.length);
        AccessControlServiceSystemTest.assertNotNull((Object)acls5[0].getAces());
        AccessControlServiceSystemTest.assertEquals((int)1, (int)acls5[0].getAces().length);
        ACL[] acls6 = this.accessControlService.removeACEs(predicate, null);
        AccessControlServiceSystemTest.assertNotNull((Object)acls6);
        AccessControlServiceSystemTest.assertEquals((int)1, (int)acls6.length);
        AccessControlServiceSystemTest.assertNull((Object)acls6[0].getAces());
        this.removeUsers();
    }

    public void testGetPermissions() throws Exception {
        Predicate predicate = new Predicate(new Reference[]{BaseWebServiceSystemTest.contentReference}, null, null);
        GetPermissionsResult[] results = this.accessControlService.getPermissions(predicate);
        AccessControlServiceSystemTest.assertNotNull((Object)results);
        AccessControlServiceSystemTest.assertEquals((int)1, (int)results.length);
        GetPermissionsResult result = results[0];
        AccessControlServiceSystemTest.assertEquals((String)BaseWebServiceSystemTest.contentReference.getUuid(), (String)result.getReference().getUuid());
        AccessControlServiceSystemTest.assertNotNull((Object)result.getPermissions());
        if (logger.isDebugEnabled()) {
            System.out.println("Node permissions:");
            for (String permission : result.getPermissions()) {
                System.out.println(permission);
            }
            System.out.println("\n");
        }
    }

    public void testGetClassPermissions() throws Exception {
        GetClassPermissionsResult[] results = this.accessControlService.getClassPermissions(new String[]{Constants.TYPE_FOLDER});
        AccessControlServiceSystemTest.assertNotNull((Object)results);
        AccessControlServiceSystemTest.assertEquals((int)1, (int)results.length);
        GetClassPermissionsResult result = results[0];
        AccessControlServiceSystemTest.assertEquals((String)Constants.TYPE_FOLDER, (String)result.getClassName());
        AccessControlServiceSystemTest.assertNotNull((Object)result.getPermissions());
        if (logger.isDebugEnabled()) {
            System.out.println("Class permissions:");
            for (String permission : result.getPermissions()) {
                System.out.println(permission);
            }
            System.out.println("\n");
        }
    }

    public void testHasPermissions() throws Exception {
        Predicate predicate = this.convertToPredicate(BaseWebServiceSystemTest.contentReference);
        HasPermissionsResult[] results = this.accessControlService.hasPermissions(predicate, new String[]{"Write"});
        AccessControlServiceSystemTest.assertNotNull((Object)results);
        AccessControlServiceSystemTest.assertEquals((int)1, (int)results.length);
        HasPermissionsResult result = results[0];
        AccessControlServiceSystemTest.assertEquals((String)"Write", (String)result.getPermission());
        AccessControlServiceSystemTest.assertEquals((String)BaseWebServiceSystemTest.contentReference.getUuid(), (String)result.getReference().getUuid());
        AccessControlServiceSystemTest.assertEquals((Object)AccessStatus.acepted, (Object)result.getAccessStatus());
    }

    public void testSetInheritPermissions() throws Exception {
        ACL[] acls = this.accessControlService.setInheritPermission(this.convertToPredicate(BaseWebServiceSystemTest.contentReference), false);
        AccessControlServiceSystemTest.assertNotNull((Object)acls);
        AccessControlServiceSystemTest.assertEquals((int)1, (int)acls.length);
        ACL acl = acls[0];
        AccessControlServiceSystemTest.assertEquals((String)BaseWebServiceSystemTest.contentReference.getUuid(), (String)acl.getReference().getUuid());
        AccessControlServiceSystemTest.assertFalse((boolean)acl.isInheritPermissions());
    }

    public void testSetGetOwnable() throws Exception {
        this.createUsers();
        OwnerResult[] results = this.accessControlService.getOwners(this.convertToPredicate(BaseWebServiceSystemTest.contentReference));
        AccessControlServiceSystemTest.assertNotNull((Object)results);
        AccessControlServiceSystemTest.assertEquals((int)1, (int)results.length);
        OwnerResult result = results[0];
        AccessControlServiceSystemTest.assertEquals((String)BaseWebServiceSystemTest.contentReference.getUuid(), (String)result.getReference().getUuid());
        AccessControlServiceSystemTest.assertEquals((String)"admin", (String)result.getOwner());
        OwnerResult[] results2 = this.accessControlService.setOwners(this.convertToPredicate(BaseWebServiceSystemTest.contentReference), this.userName1);
        AccessControlServiceSystemTest.assertNotNull((Object)results2);
        AccessControlServiceSystemTest.assertEquals((int)1, (int)results2.length);
        OwnerResult result2 = results2[0];
        AccessControlServiceSystemTest.assertEquals((String)BaseWebServiceSystemTest.contentReference.getUuid(), (String)result2.getReference().getUuid());
        AccessControlServiceSystemTest.assertEquals((String)this.userName1, (String)result2.getOwner());
        this.removeUsers();
    }

    public void testCreateAuthorities() throws Exception {
        String shortName1 = this.getShortName("rootGroupOne");
        String shortName2 = this.getShortName("rootGroupTwo");
        NewAuthority newAuthOne = new NewAuthority("GROUP", shortName1);
        NewAuthority newAuthTwo = new NewAuthority("GROUP", shortName2);
        NewAuthority[] newAuthorities = new NewAuthority[]{newAuthOne, newAuthTwo};
        String[] result = this.accessControlService.createAuthorities(null, newAuthorities);
        AccessControlServiceSystemTest.assertNotNull((Object)result);
        AccessControlServiceSystemTest.assertEquals((int)2, (int)result.length);
        String rootGroupOne = result[0];
        String rootGroupTwo = result[1];
        AccessControlServiceSystemTest.assertEquals((String)("GROUP_" + shortName1), (String)rootGroupOne);
        AccessControlServiceSystemTest.assertEquals((String)("GROUP_" + shortName2), (String)rootGroupTwo);
        String shortName3 = this.getShortName("groupOneA");
        String shortName4 = this.getShortName("groupOneB");
        NewAuthority newAuthOneA = new NewAuthority("GROUP", shortName3);
        NewAuthority newAuthOneB = new NewAuthority("GROUP", shortName4);
        NewAuthority[] newAuthorities2 = new NewAuthority[]{newAuthOneA, newAuthOneB};
        String[] result2 = this.accessControlService.createAuthorities(rootGroupOne, newAuthorities2);
        AccessControlServiceSystemTest.assertNotNull((Object)result2);
        AccessControlServiceSystemTest.assertEquals((int)2, (int)result2.length);
        String groupOneA = result2[0];
        String groupOneB = result2[1];
        AccessControlServiceSystemTest.assertEquals((String)("GROUP_" + shortName3), (String)groupOneA);
        AccessControlServiceSystemTest.assertEquals((String)("GROUP_" + shortName4), (String)groupOneB);
        String shortName5 = this.getShortName("groupTwoA");
        String shortName6 = this.getShortName("groupTwoB");
        NewAuthority newAuthTwoA = new NewAuthority("GROUP", shortName5);
        NewAuthority newAuthTwoB = new NewAuthority("GROUP", shortName6);
        NewAuthority[] newAuthorities3 = new NewAuthority[]{newAuthTwoA, newAuthTwoB};
        String[] result3 = this.accessControlService.createAuthorities(rootGroupTwo, newAuthorities3);
        AccessControlServiceSystemTest.assertNotNull((Object)result3);
        AccessControlServiceSystemTest.assertEquals((int)2, (int)result3.length);
        String groupTwoA = result3[0];
        String groupTwoB = result3[1];
        AccessControlServiceSystemTest.assertEquals((String)("GROUP_" + shortName5), (String)groupTwoA);
        AccessControlServiceSystemTest.assertEquals((String)("GROUP_" + shortName6), (String)groupTwoB);
        AuthorityFilter filter = new AuthorityFilter("GROUP", false);
        String[] result4 = this.accessControlService.getAllAuthorities(filter);
        AccessControlServiceSystemTest.assertNotNull((Object)result4);
        if (result4.length < 6) {
            AccessControlServiceSystemTest.fail((String)"We where expecting at least 6 groups to be returned from the getAllAuthorities search.");
        }
        AccessControlServiceSystemTest.assertTrue((boolean)this.arrayContains(result4, rootGroupOne));
        AccessControlServiceSystemTest.assertTrue((boolean)this.arrayContains(result4, rootGroupTwo));
        AccessControlServiceSystemTest.assertTrue((boolean)this.arrayContains(result4, groupOneA));
        AccessControlServiceSystemTest.assertTrue((boolean)this.arrayContains(result4, groupOneB));
        AccessControlServiceSystemTest.assertTrue((boolean)this.arrayContains(result4, groupTwoA));
        AccessControlServiceSystemTest.assertTrue((boolean)this.arrayContains(result4, groupTwoB));
        AuthorityFilter filter2 = new AuthorityFilter("GROUP", true);
        String[] result5 = this.accessControlService.getAllAuthorities(filter2);
        AccessControlServiceSystemTest.assertNotNull((Object)result5);
        if (result5.length < 2) {
            AccessControlServiceSystemTest.fail((String)"We where expecting at least 2 groups to be returned from the getAllAuthorities search.");
        }
        AccessControlServiceSystemTest.assertTrue((boolean)this.arrayContains(result5, rootGroupOne));
        AccessControlServiceSystemTest.assertTrue((boolean)this.arrayContains(result5, rootGroupTwo));
        AccessControlServiceSystemTest.assertFalse((boolean)this.arrayContains(result5, groupOneA));
        AccessControlServiceSystemTest.assertFalse((boolean)this.arrayContains(result5, groupOneB));
        AccessControlServiceSystemTest.assertFalse((boolean)this.arrayContains(result5, groupTwoA));
        AccessControlServiceSystemTest.assertFalse((boolean)this.arrayContains(result5, groupTwoB));
        this.createUsers();
        AccessControlServiceSystemTest.assertNotNull((Object)this.userName1);
        AccessControlServiceSystemTest.assertNotNull((Object)this.userName2);
        String[] users = new String[]{this.userName1, this.userName2};
        String[] result6 = this.accessControlService.addChildAuthorities(groupOneA, users);
        AccessControlServiceSystemTest.assertNotNull((Object)result6);
        AccessControlServiceSystemTest.assertEquals((int)2, (int)result6.length);
        AccessControlServiceSystemTest.assertEquals((String)this.userName1, (String)result6[0]);
        AccessControlServiceSystemTest.assertEquals((String)this.userName2, (String)result6[1]);
        String[] result7 = this.accessControlService.addChildAuthorities(rootGroupTwo, users);
        AccessControlServiceSystemTest.assertNotNull((Object)result7);
        AccessControlServiceSystemTest.assertEquals((int)2, (int)result7.length);
        AccessControlServiceSystemTest.assertEquals((String)this.userName1, (String)result7[0]);
        AccessControlServiceSystemTest.assertEquals((String)this.userName2, (String)result7[1]);
        AuthenticationUtils.startSession(this.userName1, "password");
        String[] result8 = this.accessControlService.getAuthorities();
        AccessControlServiceSystemTest.assertNotNull((Object)result8);
        if (result8.length < 3) {
            AccessControlServiceSystemTest.fail((String)"We where expecting the user to be in at least 3 gropus");
        }
        AccessControlServiceSystemTest.assertTrue((boolean)this.arrayContains(result8, rootGroupOne));
        AccessControlServiceSystemTest.assertTrue((boolean)this.arrayContains(result8, rootGroupTwo));
        AccessControlServiceSystemTest.assertTrue((boolean)this.arrayContains(result8, groupOneA));
        AccessControlServiceSystemTest.assertFalse((boolean)this.arrayContains(result8, groupOneB));
        AccessControlServiceSystemTest.assertFalse((boolean)this.arrayContains(result8, groupTwoA));
        AccessControlServiceSystemTest.assertFalse((boolean)this.arrayContains(result8, groupTwoB));
        AuthenticationUtils.startSession("admin", "admin");
        SiblingAuthorityFilter filter3 = new SiblingAuthorityFilter("GROUP", true);
        String[] result9 = this.accessControlService.getParentAuthorities(groupOneA, filter3);
        AccessControlServiceSystemTest.assertNotNull((Object)result9);
        AccessControlServiceSystemTest.assertEquals((int)1, (int)result9.length);
        AccessControlServiceSystemTest.assertEquals((String)rootGroupOne, (String)result9[0]);
        SiblingAuthorityFilter filter4 = new SiblingAuthorityFilter("GROUP", false);
        String[] result10 = this.accessControlService.getParentAuthorities(this.userName1, filter4);
        AccessControlServiceSystemTest.assertNotNull((Object)result10);
        if (result8.length < 3) {
            AccessControlServiceSystemTest.fail((String)"We where expecting the user to have at least 3 parent groups");
        }
        AccessControlServiceSystemTest.assertTrue((boolean)this.arrayContains(result8, rootGroupOne));
        AccessControlServiceSystemTest.assertTrue((boolean)this.arrayContains(result8, rootGroupTwo));
        AccessControlServiceSystemTest.assertTrue((boolean)this.arrayContains(result8, groupOneA));
        AccessControlServiceSystemTest.assertFalse((boolean)this.arrayContains(result8, groupOneB));
        AccessControlServiceSystemTest.assertFalse((boolean)this.arrayContains(result8, groupTwoA));
        AccessControlServiceSystemTest.assertFalse((boolean)this.arrayContains(result8, groupTwoB));
        SiblingAuthorityFilter filter5 = new SiblingAuthorityFilter("USER", true);
        String[] result11 = this.accessControlService.getChildAuthorities(groupOneA, filter5);
        AccessControlServiceSystemTest.assertNotNull((Object)result11);
        AccessControlServiceSystemTest.assertEquals((int)2, (int)result11.length);
        AccessControlServiceSystemTest.assertTrue((boolean)this.arrayContains(result11, this.userName1));
        AccessControlServiceSystemTest.assertTrue((boolean)this.arrayContains(result11, this.userName2));
        SiblingAuthorityFilter filter6 = new SiblingAuthorityFilter("GROUP", false);
        String[] result12 = this.accessControlService.getChildAuthorities(rootGroupOne, filter6);
        AccessControlServiceSystemTest.assertNotNull((Object)result12);
        AccessControlServiceSystemTest.assertEquals((int)2, (int)result12.length);
        AccessControlServiceSystemTest.assertTrue((boolean)this.arrayContains(result12, groupOneA));
        AccessControlServiceSystemTest.assertTrue((boolean)this.arrayContains(result12, groupOneB));
        SiblingAuthorityFilter filter7 = new SiblingAuthorityFilter("GROUP", false);
        String[] result13 = this.accessControlService.getChildAuthorities(groupOneA, filter7);
        AccessControlServiceSystemTest.assertNull((Object)result13);
        this.accessControlService.removeChildAuthorities(groupOneA, users);
        String[] result14 = this.accessControlService.getChildAuthorities(groupOneA, filter5);
        AccessControlServiceSystemTest.assertNull((Object)result14);
        String[] toDelete = new String[]{groupOneA, groupOneB};
        this.accessControlService.deleteAuthorities(toDelete);
        String[] result15 = this.accessControlService.getChildAuthorities(rootGroupOne, filter6);
        AccessControlServiceSystemTest.assertNull((Object)result15);
    }

    private boolean arrayContains(String[] array, String value) {
        boolean result = false;
        for (String string : array) {
            if (!string.equals(value)) continue;
            result = true;
            break;
        }
        return result;
    }

    private String getShortName(String baseName) {
        ++this.counter;
        return baseName + System.nanoTime() + this.counter;
    }
}

