/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webservice.test;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.alfresco.webservice.authentication.AuthenticationFault;
import org.alfresco.webservice.authentication.AuthenticationResult;
import org.alfresco.webservice.authentication.AuthenticationServiceSoapBindingStub;
import org.alfresco.webservice.util.WebServiceFactory;

public class AuthenticationServiceSystemTest
extends TestCase {
    public void testSuccessfulLogin() throws Exception {
        try {
            AuthenticationResult value = WebServiceFactory.getAuthenticationService().startSession("admin", "admin");
            AuthenticationServiceSystemTest.assertNotNull((String)"result must not be null", (Object)value);
            System.out.println("ticket = " + value.getTicket());
        }
        catch (AuthenticationFault error) {
            throw new AssertionFailedError("AuthenticationFault Exception caught: " + error);
        }
    }

    public void testFailedLogin() throws Exception {
        try {
            WebServiceFactory.getAuthenticationService().startSession("wrong", "credentials");
            AuthenticationServiceSystemTest.fail((String)"The credentials are incorrect so an AuthenticationFault should have been thrown");
        }
        catch (AuthenticationFault authenticationFault) {
            // empty catch block
        }
    }

    public void testEndSession() throws Exception {
        AuthenticationServiceSoapBindingStub authenticationService = WebServiceFactory.getAuthenticationService();
        AuthenticationResult result = authenticationService.startSession("admin", "admin");
        authenticationService.endSession(result.getTicket());
        try {
            authenticationService.endSession("badSessionId");
            AuthenticationServiceSystemTest.fail((String)"An exception should have been thrown since we are trying to end an invalid session");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

