/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webservice.test;

import java.io.InputStream;
import org.alfresco.webservice.action.Action;
import org.alfresco.webservice.classification.AppliedCategory;
import org.alfresco.webservice.classification.CategoriesResult;
import org.alfresco.webservice.classification.ClassificationServiceSoapBindingStub;
import org.alfresco.webservice.repository.UpdateResult;
import org.alfresco.webservice.test.BaseWebServiceSystemTest;
import org.alfresco.webservice.types.CML;
import org.alfresco.webservice.types.CMLCreate;
import org.alfresco.webservice.types.Category;
import org.alfresco.webservice.types.ClassDefinition;
import org.alfresco.webservice.types.Classification;
import org.alfresco.webservice.types.ContentFormat;
import org.alfresco.webservice.types.NamedValue;
import org.alfresco.webservice.types.ParentReference;
import org.alfresco.webservice.types.Predicate;
import org.alfresco.webservice.types.Reference;
import org.alfresco.webservice.util.Constants;
import org.alfresco.webservice.util.ContentUtils;
import org.alfresco.webservice.util.WebServiceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassificationServiceSystemTest
extends BaseWebServiceSystemTest {
    private static Log logger = LogFactory.getLog(ClassificationServiceSystemTest.class);
    private ClassificationServiceSoapBindingStub classificationService;
    private static boolean categoriesLoaded = false;

    protected void setUp() throws Exception {
        super.setUp();
        this.classificationService = WebServiceFactory.getClassificationService();
        if (!categoriesLoaded) {
            InputStream viewStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/webservice/test/resources/test.acp");
            byte[] byteArray = ContentUtils.convertToByteArray(viewStream);
            ParentReference categoryParentRef = new ParentReference(BaseWebServiceSystemTest.store, BaseWebServiceSystemTest.rootReference.getUuid(), null, Constants.ASSOC_CHILDREN, "{http://www.alfresco.org/model/content/1.0}testContent");
            NamedValue[] categoryProperties = new NamedValue[]{new NamedValue(Constants.PROP_NAME, false, "categories.acp", null)};
            CMLCreate createCategory = new CMLCreate("categoryImport", categoryParentRef, null, null, null, Constants.TYPE_CONTENT, categoryProperties);
            CML cml2 = new CML();
            cml2.setCreate(new CMLCreate[]{createCategory});
            UpdateResult[] updateResult = this.repositoryService.update(cml2);
            Reference categoryReference = updateResult[0].getDestination();
            this.contentService.write(categoryReference, Constants.PROP_CONTENT, byteArray, new ContentFormat("application/acp", "UTF-8"));
            String rootNodeRef = store.getScheme() + "://" + store.getAddress() + "/" + rootReference.getUuid();
            Action importAction = new Action();
            importAction.setActionName("import");
            NamedValue[] params = new NamedValue[]{new NamedValue("encoding", false, "UTF-8", null), new NamedValue("destination", false, rootNodeRef, null)};
            importAction.setParameters(params);
            WebServiceFactory.getActionService().executeActions(new Predicate(new Reference[]{categoryReference}, store, null), new Action[]{importAction});
            categoriesLoaded = true;
        }
    }

    public void testGetClassifications() throws Exception {
        Classification[] classifications = this.classificationService.getClassifications(BaseWebServiceSystemTest.store);
        ClassificationServiceSystemTest.assertNotNull((Object)classifications);
        ClassificationServiceSystemTest.assertTrue((classifications.length != 0 ? 1 : 0) != 0);
        Classification classification = classifications[0];
        ClassificationServiceSystemTest.assertNotNull((Object)classification.getTitle());
        ClassificationServiceSystemTest.assertNotNull((Object)classification.getRootCategory());
        ClassificationServiceSystemTest.assertNotNull((Object)classification.getRootCategory().getId());
        ClassificationServiceSystemTest.assertNotNull((Object)classification.getRootCategory().getTitle());
        if (logger.isDebugEnabled()) {
            for (Classification item : classifications) {
                logger.debug((Object)("Classification '" + item.getTitle() + "' with root category '" + item.getRootCategory().getTitle() + "'"));
            }
        }
    }

    public void testGetChildCategories() throws Exception {
        Classification[] classifications = this.classificationService.getClassifications(BaseWebServiceSystemTest.store);
        Reference parentCategory = classifications[0].getRootCategory().getId();
        Category[] categories = this.classificationService.getChildCategories(parentCategory);
        ClassificationServiceSystemTest.assertNotNull((Object)categories);
        ClassificationServiceSystemTest.assertTrue((categories.length != 0 ? 1 : 0) != 0);
        Category item = categories[0];
        ClassificationServiceSystemTest.assertNotNull((Object)item.getId());
        ClassificationServiceSystemTest.assertNotNull((Object)item.getTitle());
        if (logger.isDebugEnabled()) {
            for (Category category : categories) {
                logger.debug((Object)("Sub-category '" + category.getTitle() + "'"));
            }
        }
    }

    public void testGetAndSetCategories() throws Exception {
        Classification[] classifications = this.classificationService.getClassifications(BaseWebServiceSystemTest.store);
        String classification = classifications[0].getClassification();
        Reference category = classifications[0].getRootCategory().getId();
        Reference reference = this.createContentAtRoot("TestContent" + System.currentTimeMillis(), "Any old content.");
        Predicate predicate = this.convertToPredicate(reference);
        CategoriesResult[] result1 = this.classificationService.getCategories(predicate);
        ClassificationServiceSystemTest.assertNotNull((Object)result1);
        ClassificationServiceSystemTest.assertEquals((int)1, (int)result1.length);
        ClassificationServiceSystemTest.assertNull((Object)result1[0].getCategories());
        AppliedCategory appliedCategory = new AppliedCategory();
        appliedCategory.setCategories(new Reference[]{category});
        appliedCategory.setClassification(classification);
        AppliedCategory[] appliedCategories = new AppliedCategory[]{appliedCategory};
        CategoriesResult[] result2 = this.classificationService.setCategories(predicate, appliedCategories);
        ClassificationServiceSystemTest.assertNotNull((Object)result2);
        ClassificationServiceSystemTest.assertEquals((int)1, (int)result2.length);
        CategoriesResult[] result3 = this.classificationService.getCategories(predicate);
        ClassificationServiceSystemTest.assertNotNull((Object)result3);
        ClassificationServiceSystemTest.assertEquals((int)1, (int)result3.length);
        CategoriesResult categoryResult = result3[0];
        ClassificationServiceSystemTest.assertEquals((String)reference.getUuid(), (String)categoryResult.getNode().getUuid());
        AppliedCategory[] appCats = categoryResult.getCategories();
        ClassificationServiceSystemTest.assertNotNull((Object)appCats);
        ClassificationServiceSystemTest.assertEquals((int)1, (int)appCats.length);
        AppliedCategory appCat = appCats[0];
        ClassificationServiceSystemTest.assertEquals((String)classification, (String)appCat.getClassification());
        Reference[] refs = appCat.getCategories();
        ClassificationServiceSystemTest.assertNotNull((Object)refs);
        ClassificationServiceSystemTest.assertEquals((int)1, (int)refs.length);
        Reference ref = refs[0];
        ClassificationServiceSystemTest.assertEquals((String)category.getUuid(), (String)ref.getUuid());
    }

    public void testDescribeClassification() throws Exception {
        Classification[] classifications = this.classificationService.getClassifications(BaseWebServiceSystemTest.store);
        String classification = classifications[0].getClassification();
        ClassDefinition classDefinition = this.classificationService.describeClassification(classification);
        ClassificationServiceSystemTest.assertNotNull((Object)classDefinition);
    }
}

