/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webservice.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.alfresco.webservice.content.Content;
import org.alfresco.webservice.repository.UpdateResult;
import org.alfresco.webservice.test.BaseWebServiceSystemTest;
import org.alfresco.webservice.types.CML;
import org.alfresco.webservice.types.CMLCreate;
import org.alfresco.webservice.types.ContentFormat;
import org.alfresco.webservice.types.NamedValue;
import org.alfresco.webservice.types.ParentReference;
import org.alfresco.webservice.types.Predicate;
import org.alfresco.webservice.types.Reference;
import org.alfresco.webservice.util.Constants;
import org.alfresco.webservice.util.ContentUtils;

public class TimeoutSystemTest
extends BaseWebServiceSystemTest {
    public void testContentService() throws Exception {
        ParentReference parentRef = new ParentReference();
        parentRef.setStore(BaseWebServiceSystemTest.store);
        parentRef.setUuid(BaseWebServiceSystemTest.rootReference.getUuid());
        parentRef.setAssociationType(Constants.ASSOC_CHILDREN);
        parentRef.setChildName(Constants.ASSOC_CHILDREN);
        NamedValue[] properties = new NamedValue[]{new NamedValue(Constants.PROP_NAME, false, "test.jpg", null)};
        CMLCreate create = new CMLCreate("1", parentRef, null, null, null, Constants.TYPE_CONTENT, properties);
        CML cml = new CML();
        cml.setCreate(new CMLCreate[]{create});
        UpdateResult[] result = this.repositoryService.update(cml);
        Reference myCreatedNode = result[0].getDestination();
        ContentFormat format = new ContentFormat("image/jpeg", "UTF-8");
        InputStream viewStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/webservice/test/resources/test.jpg");
        byte[] bytes = ContentUtils.convertToByteArray(viewStream);
        Content myContent = this.contentService.write(myCreatedNode, Constants.PROP_CONTENT, bytes, format);
        ContentUtils.copyContentToFile(myContent, File.createTempFile("temp", "jpg"));
        InputStream viewStream2 = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/webservice/test/resources/test.jpg");
        File testFile = File.createTempFile("temp", "jpg");
        FileOutputStream fos = new FileOutputStream(testFile);
        ContentUtils.copy(viewStream2, fos);
        viewStream.close();
        fos.close();
        ContentUtils.putContent(testFile);
        for (int i = 0; i < 5; ++i) {
            this.repositoryService.get(new Predicate(new Reference[]{myCreatedNode}, null, null));
            Thread.sleep(30000L);
        }
    }
}

