/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webservice.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.alfresco.webservice.authentication.AuthenticationFault;
import org.alfresco.webservice.authentication.AuthenticationResult;
import org.alfresco.webservice.util.AuthenticationDetails;
import org.alfresco.webservice.util.WebServiceException;
import org.alfresco.webservice.util.WebServiceFactory;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.configuration.FileProvider;
import org.apache.ws.security.WSPasswordCallback;

public class AuthenticationUtils
implements CallbackHandler {
    private static final String WS_SECURITY_INFO = "<deployment xmlns='http://xml.apache.org/axis/wsdd/' xmlns:java='http://xml.apache.org/axis/wsdd/providers/java'>   <transport name='http' pivot='java:org.apache.axis.transport.http.HTTPSender'/>   <globalConfiguration >     <requestFlow >       <handler type='java:org.apache.ws.axis.security.WSDoAllSender' >               <parameter name='action' value='UsernameToken Timestamp'/>               <parameter name='user' value='ticket'/>               <parameter name='passwordCallbackClass' value='org.alfresco.webservice.util.AuthenticationUtils'/>               <parameter name='passwordType' value='PasswordText'/>           </handler>       <handler name='cookieHandler' type='java:org.alfresco.webservice.util.CookieHandler' />     </requestFlow >   </globalConfiguration></deployment>";
    private static ThreadLocal<AuthenticationDetails> authenticationDetails = new ThreadLocal();

    public static void startSession(String username, String password) throws AuthenticationFault {
        try {
            AuthenticationResult result = WebServiceFactory.getAuthenticationService().startSession(username, password);
            authenticationDetails.set(new AuthenticationDetails(result.getUsername(), result.getTicket(), result.getSessionid()));
        }
        catch (RemoteException exception) {
            if (exception instanceof AuthenticationFault) {
                throw (AuthenticationFault)((Object)exception);
            }
            throw new WebServiceException("Error starting session.", exception);
        }
    }

    public static void endSession() {
        AuthenticationDetails authenticationDetails = AuthenticationUtils.authenticationDetails.get();
        if (authenticationDetails != null) {
            try {
                WebServiceFactory.getAuthenticationService().endSession(authenticationDetails.getTicket());
                AuthenticationUtils.authenticationDetails.remove();
            }
            catch (RemoteException exception) {
                exception.printStackTrace();
                throw new WebServiceException("Error ending session.", exception);
            }
        }
    }

    public static String getTicket() {
        String result = null;
        AuthenticationDetails authDetails = authenticationDetails.get();
        if (authDetails != null) {
            result = authDetails.getTicket();
        }
        return result;
    }

    public static AuthenticationDetails getAuthenticationDetails() {
        return authenticationDetails.get();
    }

    public static void setAuthenticationDetails(AuthenticationDetails authenticationDetails) {
        AuthenticationUtils.authenticationDetails.set(authenticationDetails);
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            String ticket;
            WSPasswordCallback pc;
            if (callbacks[i] instanceof WSPasswordCallback) {
                pc = (WSPasswordCallback)callbacks[i];
                ticket = AuthenticationUtils.getTicket();
                if (ticket == null) {
                    throw new WebServiceException("Ticket could not be found when calling callback handler.");
                }
            } else {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
            pc.setPassword(ticket);
        }
    }

    public static EngineConfiguration getEngineConfiguration() {
        return new FileProvider((InputStream)new ByteArrayInputStream(WS_SECURITY_INFO.getBytes()));
    }
}

