/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.example;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.transaction.TransactionUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.debug.NodeStoreInspector;
import org.springframework.context.ApplicationContext;

public class SimpleExampleWithContent {
    private static final String NAMESPACE = "http://www.alfresco.org/test/SimpleExampleWithContent";

    public static void main(String[] args) {
        ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
        final ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        TransactionService transactionService = serviceRegistry.getTransactionService();
        TransactionUtil.TransactionWork<Object> exampleWork = new TransactionUtil.TransactionWork<Object>(){

            @Override
            public Object doWork() throws Exception {
                SimpleExampleWithContent.doExample(serviceRegistry);
                return null;
            }
        };
        TransactionUtil.executeInUserTransaction(transactionService, exampleWork);
        System.exit(0);
    }

    private static void doExample(ServiceRegistry serviceRegistry) throws Exception {
        NodeService nodeService = serviceRegistry.getNodeService();
        ContentService contentService = serviceRegistry.getContentService();
        AuthenticationService authenticationService = serviceRegistry.getAuthenticationService();
        authenticationService.authenticate("admin", "admin".toCharArray());
        StoreRef storeRef = new StoreRef("workspace", "SimpleExampleWithContent-" + GUID.generate());
        if (!nodeService.exists(storeRef)) {
            nodeService.createStore(storeRef.getProtocol(), storeRef.getIdentifier());
        }
        NodeRef rootNodeRef = nodeService.getRootNode(storeRef);
        HashMap<QName, Serializable> nodeProperties = new HashMap<QName, Serializable>(7);
        nodeProperties.clear();
        nodeProperties.put(ContentModel.PROP_NAME, (Serializable)((Object)"My First Folder"));
        ChildAssociationRef assocRef = nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName(NAMESPACE, QName.createValidLocalName("My First Folder")), ContentModel.TYPE_FOLDER, nodeProperties);
        NodeRef folderRef = assocRef.getChildRef();
        nodeProperties.clear();
        nodeProperties.put(ContentModel.PROP_NAME, (Serializable)((Object)"My First File"));
        assocRef = nodeService.createNode(folderRef, ContentModel.ASSOC_CONTAINS, QName.createQName(NAMESPACE, QName.createValidLocalName("My First File")), ContentModel.TYPE_CONTENT, nodeProperties);
        NodeRef fileRef = assocRef.getChildRef();
        ContentWriter writer = contentService.getWriter(fileRef, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        String content = "The quick brown fox jumps over the lazy dog";
        writer.putContent(content);
        File file = TempFileProvider.createTempFile((String)"sample", (String)".txt");
        ContentReader reader = contentService.getReader(fileRef, ContentModel.PROP_CONTENT);
        reader.getContent(file);
        String dump = NodeStoreInspector.dumpNodeStore(nodeService, storeRef);
        System.out.println("Node Store: \n" + dump);
    }
}

