/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys;

import java.io.IOException;
import java.io.PrintStream;
import java.net.SocketException;
import java.util.Vector;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.netbios.server.NetBIOSNameServer;
import org.alfresco.filesys.server.NetworkServer;
import org.alfresco.filesys.server.config.ServerConfiguration;
import org.alfresco.filesys.smb.server.SMBServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class CIFSServer
implements ApplicationListener {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.smb.server");
    private ServerConfiguration filesysConfig;
    private Vector<NetworkServer> serverList = new Vector();

    public CIFSServer(ServerConfiguration serverConfig) {
        this.filesysConfig = serverConfig;
    }

    public final ServerConfiguration getConfiguration() {
        return this.filesysConfig;
    }

    public boolean isStarted() {
        return this.filesysConfig != null && this.filesysConfig.isSMBServerEnabled();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            try {
                this.startServer();
            }
            catch (SocketException e) {
                throw new AlfrescoRuntimeException("Failed to start CIFS server", (Throwable)e);
            }
            catch (IOException e) {
                throw new AlfrescoRuntimeException("Failed to start CIFS server", (Throwable)e);
            }
        }
    }

    public final void startServer() throws SocketException, IOException {
        try {
            if (this.filesysConfig.isSMBServerEnabled()) {
                if (this.filesysConfig.hasNetBIOSSMB()) {
                    this.serverList.add(new NetBIOSNameServer(this.filesysConfig));
                }
                this.serverList.add(new SMBServer(this.filesysConfig));
                for (NetworkServer server : this.serverList) {
                    this.filesysConfig.addServer(server);
                }
            }
            for (NetworkServer server : this.serverList) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Starting server " + server.getProtocolName() + " ..."));
                }
                String serverName = server.getConfiguration().getServerName();
                server.startServer();
            }
        }
        catch (Throwable e) {
            this.filesysConfig = null;
            throw new AlfrescoRuntimeException("Failed to start CIFS Server", e);
        }
    }

    public final void stopServer() {
        if (this.filesysConfig == null) {
            return;
        }
        for (NetworkServer server : this.serverList) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Shutting server " + server.getProtocolName() + " ..."));
            }
            server.shutdownServer(false);
            this.getConfiguration().removeServer(server.getProtocolName());
        }
        this.serverList.clear();
        this.filesysConfig = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PrintStream out = System.out;
        out.println("CIFS Server Test");
        out.println("----------------");
        try {
            ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("alfresco/application-context.xml");
            CIFSServer server = (CIFSServer)ctx.getBean("cifsServer");
            if (server == null) {
                throw new AlfrescoRuntimeException("Server bean 'cifsServer' not defined");
            }
            server.getConfiguration().setFTPServerEnabled(false);
            NetworkServer srv = server.getConfiguration().findServer("FTP");
            if (srv != null) {
                srv.shutdownServer(true);
            }
            if (server.getConfiguration().isSMBServerEnabled()) {
                out.println("Enter 'x' to shutdown ...");
                boolean shutdown = false;
                while (!shutdown) {
                    int ch = System.in.read();
                    if (ch == 120 || ch == 88) {
                        shutdown = true;
                    }
                    CIFSServer cIFSServer = server;
                    synchronized (cIFSServer) {
                        server.wait(20L);
                    }
                }
                server.stopServer();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(1);
    }
}

