/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys;

import java.io.IOException;
import java.io.PrintStream;
import java.net.SocketException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.ftp.FTPNetworkServer;
import org.alfresco.filesys.server.NetworkServer;
import org.alfresco.filesys.server.config.ServerConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class FTPServer
implements ApplicationListener {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.ftp.server");
    private ServerConfiguration filesysConfig;
    private FTPNetworkServer ftpServer;

    public FTPServer(ServerConfiguration serverConfig) {
        this.filesysConfig = serverConfig;
    }

    public final ServerConfiguration getConfiguration() {
        return this.filesysConfig;
    }

    public boolean isStarted() {
        return this.filesysConfig != null && this.filesysConfig.isFTPServerEnabled();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            try {
                this.startServer();
            }
            catch (SocketException e) {
                throw new AlfrescoRuntimeException("Failed to start FTP server", (Throwable)e);
            }
            catch (IOException e) {
                throw new AlfrescoRuntimeException("Failed to start FTP server", (Throwable)e);
            }
        }
    }

    public final void startServer() throws SocketException, IOException {
        try {
            if (this.filesysConfig.isFTPServerEnabled()) {
                this.ftpServer = new FTPNetworkServer(this.filesysConfig);
                this.filesysConfig.addServer(this.ftpServer);
            }
            if (this.ftpServer != null) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Starting server " + this.ftpServer.getProtocolName() + " ..."));
                }
                this.ftpServer.startServer();
            }
        }
        catch (Throwable e) {
            this.filesysConfig = null;
            throw new AlfrescoRuntimeException("Failed to start FTP Server", e);
        }
    }

    public final void stopServer() {
        if (this.filesysConfig == null) {
            return;
        }
        if (this.ftpServer != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Shutting server " + this.ftpServer.getProtocolName() + " ..."));
            }
            this.ftpServer.shutdownServer(false);
            this.getConfiguration().removeServer(this.ftpServer.getProtocolName());
            this.ftpServer = null;
        }
        this.filesysConfig = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PrintStream out = System.out;
        out.println("FTP Server Test");
        out.println("---------------");
        try {
            ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("alfresco/application-context.xml");
            FTPServer server = (FTPServer)ctx.getBean("ftpServer");
            if (server == null) {
                throw new AlfrescoRuntimeException("Server bean 'ftpServer' not defined");
            }
            NetworkServer srv = server.getConfiguration().findServer("SMB");
            if (srv != null) {
                srv.shutdownServer(true);
            }
            if ((srv = server.getConfiguration().findServer("NetBIOS")) != null) {
                srv.shutdownServer(true);
            }
            if (server.getConfiguration().isFTPServerEnabled()) {
                out.println("Enter 'x' to shutdown ...");
                boolean shutdown = false;
                while (!shutdown) {
                    int ch = System.in.read();
                    if (ch == 120 || ch == 88) {
                        shutdown = true;
                    }
                    FTPServer fTPServer = server;
                    synchronized (fTPServer) {
                        server.wait(20L);
                    }
                }
                server.stopServer();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(1);
    }
}

