/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.ftp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.alfresco.filesys.ftp.FTPSrvSession;

public class FTPDataSession
implements Runnable {
    private FTPSrvSession m_cmdSess;
    private InetAddress m_clientAddr;
    private int m_clientPort;
    private int m_localPort;
    private Socket m_activeSock;
    private ServerSocket m_passiveSock;
    private InetAddress m_bindAddr;
    private boolean m_transfer;
    private boolean m_abort;
    private long m_bytCount;

    protected FTPDataSession(FTPSrvSession sess) throws IOException {
        this.m_cmdSess = sess;
        this.m_passiveSock = new ServerSocket(0, 1, null);
    }

    protected FTPDataSession(FTPSrvSession sess, int localPort, InetAddress bindAddr) throws IOException {
        this.m_cmdSess = sess;
        this.m_localPort = localPort;
        this.m_passiveSock = new ServerSocket(localPort, 1, bindAddr);
    }

    protected FTPDataSession(FTPSrvSession sess, InetAddress bindAddr) throws IOException {
        this.m_cmdSess = sess;
        this.m_passiveSock = new ServerSocket(0, 1, bindAddr);
    }

    protected FTPDataSession(FTPSrvSession sess, InetAddress addr, int port) {
        this.m_cmdSess = sess;
        this.m_clientAddr = addr;
        this.m_clientPort = port;
    }

    protected FTPDataSession(FTPSrvSession sess, int localPort, InetAddress addr, int port) {
        this.m_cmdSess = sess;
        this.m_localPort = localPort;
        this.m_clientAddr = addr;
        this.m_clientPort = port;
    }

    public final FTPSrvSession getCommandSession() {
        return this.m_cmdSess;
    }

    public final int getLocalPort() {
        if (this.m_passiveSock != null) {
            return this.m_passiveSock.getLocalPort();
        }
        if (this.m_activeSock != null) {
            return this.m_activeSock.getLocalPort();
        }
        return -1;
    }

    protected final int getAllocatedPort() {
        return this.m_localPort;
    }

    public final InetAddress getPassiveAddress() {
        if (this.m_passiveSock != null) {
            InetAddress addr = this.m_passiveSock.getInetAddress();
            if (addr.getHostAddress().compareTo("0.0.0.0") == 0) {
                try {
                    addr = InetAddress.getLocalHost();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            return addr;
        }
        return null;
    }

    public final int getPassivePort() {
        if (this.m_passiveSock != null) {
            return this.m_passiveSock.getLocalPort();
        }
        return -1;
    }

    public final boolean isTransferActive() {
        return this.m_transfer;
    }

    public final void abortTransfer() {
        this.m_abort = true;
    }

    public final synchronized long getTransferByteCount() {
        return this.m_bytCount;
    }

    public final Socket getSocket() throws IOException {
        this.m_activeSock = this.m_passiveSock != null ? this.m_passiveSock.accept() : (this.m_localPort != 0 ? new Socket(this.m_clientAddr, this.m_clientPort, null, this.m_localPort) : new Socket(this.m_clientAddr, this.m_clientPort));
        this.m_activeSock.setSoLinger(false, 0);
        this.m_activeSock.setTcpNoDelay(true);
        return this.m_activeSock;
    }

    public final void closeSession() {
        if (this.m_activeSock != null) {
            try {
                this.m_activeSock.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.m_activeSock = null;
        }
        if (this.m_passiveSock != null) {
            try {
                this.m_passiveSock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_passiveSock = null;
        }
    }

    public void run() {
    }
}

