/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.ftp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import org.alfresco.filesys.ftp.FTPDataSession;
import org.alfresco.filesys.ftp.FTPPath;
import org.alfresco.filesys.ftp.FTPSessionList;
import org.alfresco.filesys.ftp.FTPSrvSession;
import org.alfresco.filesys.ftp.InvalidPathException;
import org.alfresco.filesys.server.SrvSession;
import org.alfresco.filesys.server.config.ServerConfiguration;
import org.alfresco.filesys.server.core.SharedDeviceList;
import org.alfresco.filesys.server.filesys.NetworkFileServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FTPNetworkServer
extends NetworkFileServer
implements Runnable {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.ftp.protocol");
    private static final ThreadGroup THREAD_GROUP_SESSION = new ThreadGroup("FTP_SESSION_GROUP");
    private static final String ServerVersion = "3.5.0";
    protected static final int LISTEN_BACKLOG = 10;
    protected static final int SERVER_PORT = 21;
    private ServerSocket m_srvSock;
    private FTPSessionList m_sessions;
    private SharedDeviceList m_shares;
    private int m_sessId;
    private FTPPath m_rootPath;
    private Thread m_srvThread;
    private String m_localFTPaddress;

    public FTPNetworkServer(ServerConfiguration config) {
        super("FTP", config);
        this.setVersion(ServerVersion);
        this.m_sessions = new FTPSessionList();
        if (this.getConfiguration().getFTPDebug() != 0) {
            this.setDebug(true);
        }
        if (this.getConfiguration().hasFTPRootPath()) {
            try {
                this.m_rootPath = new FTPPath(this.getConfiguration().getFTPRootPath());
            }
            catch (InvalidPathException ex) {
                logger.error((Object)ex);
            }
        }
    }

    protected final void addSession(FTPSrvSession sess) {
        this.m_sessions.addSession(sess);
        if (this.hasDebug()) {
            sess.setDebug(this.getConfiguration().getFTPDebug());
        }
    }

    protected final void removeSession(FTPSrvSession sess) {
        if (this.m_sessions.removeSession(sess) != null) {
            this.fireSessionClosedEvent(sess);
        }
    }

    protected final FTPDataSession allocateDataSession(FTPSrvSession sess, InetAddress remAddr, int remPort) throws IOException {
        FTPDataSession dataSess = null;
        dataSess = remAddr != null ? new FTPDataSession(sess, remAddr, remPort) : new FTPDataSession(sess, this.getBindAddress());
        return dataSess;
    }

    protected final void releaseDataSession(FTPDataSession dataSess) {
        dataSess.closeSession();
    }

    public final SharedDeviceList getShareList() {
        if (this.m_shares == null) {
            this.m_shares = this.getConfiguration().getShareMapper().getShareList(this.getConfiguration().getServerName(), null, false);
        }
        return this.m_shares;
    }

    public final boolean hasBindAddress() {
        return this.getConfiguration().getFTPBindAddress() != null;
    }

    public final InetAddress getBindAddress() {
        return this.getConfiguration().getFTPBindAddress();
    }

    public final boolean hasRootPath() {
        return this.m_rootPath != null;
    }

    public final boolean allowAnonymous() {
        return this.getConfiguration().allowAnonymousFTP();
    }

    public final String getAnonymousAccount() {
        return this.getConfiguration().getAnonymousFTPAccount();
    }

    public final String getLocalFTPAddressString() {
        return this.m_localFTPaddress;
    }

    protected final synchronized int getNextSessionId() {
        return this.m_sessId++;
    }

    public final int getPort() {
        return this.getConfiguration().getFTPPort();
    }

    protected final ServerSocket getSocket() {
        return this.m_srvSock;
    }

    public final FTPPath getRootPath() {
        return this.m_rootPath;
    }

    protected final void sessionLoggedOn(SrvSession sess) {
        this.fireSessionLoggedOnEvent(sess);
    }

    public void run() {
        if (logger.isDebugEnabled() && this.hasDebug()) {
            logger.debug((Object)("FTP Server starting on port " + this.getPort()));
            logger.debug((Object)("Version " + this.isVersion()));
        }
        try {
            this.m_srvSock = this.hasBindAddress() ? new ServerSocket(this.getPort(), 10, this.getBindAddress()) : new ServerSocket(this.getPort(), 10);
            if (logger.isDebugEnabled() && this.hasDebug()) {
                String ftpAddr = "ALL";
                if (this.hasBindAddress()) {
                    ftpAddr = this.getBindAddress().getHostAddress();
                }
                logger.debug((Object)("FTP Binding to local address " + ftpAddr));
            }
            if (this.hasBindAddress()) {
                this.m_localFTPaddress = this.getBindAddress().getHostAddress().replace('.', ',');
            }
            this.setActive(true);
            this.fireServerEvent(1);
            while (!this.hasShutdown()) {
                Socket sessSock = this.getSocket().accept();
                if (this.m_localFTPaddress == null && sessSock.getLocalAddress() != null) {
                    this.m_localFTPaddress = sessSock.getLocalAddress().getHostAddress().replace('.', ',');
                }
                sessSock.setTcpNoDelay(true);
                if (logger.isDebugEnabled() && this.hasDebug()) {
                    logger.debug((Object)("FTP session request received from " + sessSock.getInetAddress().getHostAddress()));
                }
                FTPSrvSession srvSess = new FTPSrvSession(sessSock, this);
                srvSess.setSessionId(this.getNextSessionId());
                srvSess.setUniqueId("FTP" + srvSess.getSessionId());
                srvSess.setDebugPrefix("[FTP" + srvSess.getSessionId() + "] ");
                if (this.hasRootPath()) {
                    srvSess.setRootPath(this.getRootPath());
                }
                this.addSession(srvSess);
                this.fireSessionOpenEvent(srvSess);
                Thread srvThread = new Thread(THREAD_GROUP_SESSION, srvSess);
                srvThread.setDaemon(true);
                srvThread.setName("Sess_FTP" + srvSess.getSessionId() + "_" + sessSock.getInetAddress().getHostAddress());
                srvThread.start();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {}
            }
        }
        catch (SocketException ex) {
            if (!this.hasShutdown()) {
                logger.error((Object)"FTP Socket error", (Throwable)ex);
                this.setException(ex);
                this.fireServerEvent(3);
            }
        }
        catch (Exception ex) {
            if (!this.hasShutdown()) {
                logger.error((Object)"FTP Server error", (Throwable)ex);
            }
            this.setException(ex);
            this.fireServerEvent(3);
        }
        Enumeration enm = this.m_sessions.enumerate();
        while (enm.hasMoreElements()) {
            Integer sessId = (Integer)enm.nextElement();
            FTPSrvSession sess = this.m_sessions.findSession(sessId);
            if (logger.isDebugEnabled() && this.hasDebug()) {
                logger.debug((Object)("FTP Close session, id = " + sess.getSessionId()));
            }
            sess.closeSession();
        }
        if (logger.isDebugEnabled() && this.hasDebug()) {
            logger.debug((Object)"FTP Server shutting down ...");
        }
        this.setActive(false);
        this.fireServerEvent(2);
    }

    public void shutdownServer(boolean immediate) {
        this.setShutdown(true);
        try {
            if (this.getSocket() != null) {
                this.getSocket().close();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (this.m_srvThread != null) {
            try {
                this.m_srvThread.join(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.fireServerEvent(2);
    }

    public void startServer() {
        this.m_srvThread = new Thread(this);
        this.m_srvThread.setName("FTP Server");
        this.m_srvThread.start();
        this.fireServerEvent(0);
    }
}

