/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.ftp;

import org.alfresco.filesys.ftp.FTPCommand;

public class FTPRequest {
    private int m_cmd;
    private String m_arg;

    public FTPRequest() {
        this.m_cmd = -1;
    }

    public FTPRequest(int cmd, String arg) {
        this.m_cmd = cmd;
        this.m_arg = arg;
    }

    public FTPRequest(String cmdLine) {
        this.parseCommandLine(cmdLine);
    }

    public final int isCommand() {
        return this.m_cmd;
    }

    public final boolean hasArgument() {
        return this.m_arg != null;
    }

    public final String getArgument() {
        return this.m_arg;
    }

    public final int setCommandLine(String cmdLine) {
        this.m_cmd = -1;
        this.m_arg = null;
        this.parseCommandLine(cmdLine);
        return this.isCommand();
    }

    protected final void parseCommandLine(String cmdLine) {
        int pos = cmdLine.indexOf(32);
        String cmd = null;
        if (pos != -1) {
            cmd = cmdLine.substring(0, pos);
            this.m_arg = cmdLine.substring(pos + 1);
        } else {
            cmd = cmdLine;
        }
        this.m_cmd = FTPCommand.getCommandId(cmd);
    }

    protected final void updateArgument(String arg) {
        this.m_arg = arg;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(FTPCommand.getCommandName(this.m_cmd));
        str.append(":");
        str.append(this.m_arg);
        str.append("]");
        return str.toString();
    }
}

