/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.ftp;

import com.sun.star.uno.RuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.transaction.UserTransaction;
import org.alfresco.filesys.ftp.FTPCommand;
import org.alfresco.filesys.ftp.FTPDataSession;
import org.alfresco.filesys.ftp.FTPDate;
import org.alfresco.filesys.ftp.FTPNetworkServer;
import org.alfresco.filesys.ftp.FTPPath;
import org.alfresco.filesys.ftp.FTPRequest;
import org.alfresco.filesys.ftp.InvalidPathException;
import org.alfresco.filesys.server.SrvSession;
import org.alfresco.filesys.server.auth.ClientInfo;
import org.alfresco.filesys.server.auth.acl.AccessControlManager;
import org.alfresco.filesys.server.core.SharedDevice;
import org.alfresco.filesys.server.core.SharedDeviceList;
import org.alfresco.filesys.server.filesys.AccessDeniedException;
import org.alfresco.filesys.server.filesys.DiskDeviceContext;
import org.alfresco.filesys.server.filesys.DiskFullException;
import org.alfresco.filesys.server.filesys.DiskInterface;
import org.alfresco.filesys.server.filesys.DiskSharedDevice;
import org.alfresco.filesys.server.filesys.FileInfo;
import org.alfresco.filesys.server.filesys.FileOpenParams;
import org.alfresco.filesys.server.filesys.NetworkFile;
import org.alfresco.filesys.server.filesys.SearchContext;
import org.alfresco.filesys.server.filesys.SrvDiskInfo;
import org.alfresco.filesys.server.filesys.TreeConnection;
import org.alfresco.filesys.server.filesys.TreeConnectionHash;
import org.alfresco.filesys.smb.server.repo.ContentContext;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTPSrvSession
extends SrvSession
implements Runnable {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.ftp.protocol");
    public static final int DBG_STATE = 1;
    public static final int DBG_SEARCH = 2;
    public static final int DBG_INFO = 4;
    public static final int DBG_FILE = 8;
    public static final int DBG_FILEIO = 16;
    public static final int DBG_ERROR = 32;
    public static final int DBG_PKTTYPE = 64;
    public static final int DBG_TIMING = 128;
    public static final int DBG_DATAPORT = 256;
    public static final int DBG_DIRECTORY = 512;
    private static final String USER_ANONYMOUS = "anonymous";
    private static final String ROOT_DIRECTORY = "/";
    private static final String FTP_SEPERATOR = "/";
    private static final char FTP_SEPERATOR_CHAR = '/';
    private static final String DIR_SEPERATOR = "\\";
    private static final char DIR_SEPERATOR_CHAR = '\\';
    private static final int DEFAULT_BUFFERSIZE = 64000;
    protected static final String CRLF = "\r\n";
    protected static final String LIST_OPTION_HIDDEN = "-a";
    private Socket m_sock;
    private InputStreamReader m_in;
    private char[] m_inbuf;
    private OutputStreamWriter m_out;
    private StringBuffer m_outbuf;
    private FTPDataSession m_dataSess;
    private FTPPath m_cwd;
    private boolean m_binary = false;
    private long m_restartPos = 0L;
    private FTPPath m_renameFrom;
    private SharedDeviceList m_shares;
    private TreeConnectionHash m_connections;

    public FTPSrvSession(Socket sock, FTPNetworkServer srv) {
        super(-1, srv, "FTP", null);
        this.m_sock = sock;
        try {
            this.m_sock.setSoLinger(false, 0);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        this.setLoggedOn(false);
        this.m_cwd = new FTPPath();
        this.m_connections = new TreeConnectionHash();
    }

    @Override
    public final void closeSession() {
        super.closeSession();
        if (this.m_dataSess != null) {
            this.getFTPServer().releaseDataSession(this.m_dataSess);
            this.m_dataSess = null;
        }
        if (this.m_sock != null) {
            try {
                this.m_sock.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.m_sock = null;
        }
        if (this.m_in != null) {
            try {
                this.m_in.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.m_in = null;
        }
        if (this.m_out != null) {
            try {
                this.m_out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_out = null;
        }
        this.getFTPServer().removeSession(this);
        if (logger.isDebugEnabled() && this.hasDebug(1)) {
            logger.debug((Object)("Session closed, " + this.getSessionId()));
        }
    }

    public final String getCurrentWorkingDirectory() {
        return this.m_cwd.getFTPPath();
    }

    public final FTPNetworkServer getFTPServer() {
        return (FTPNetworkServer)this.getServer();
    }

    @Override
    public final InetAddress getRemoteAddress() {
        return this.m_sock.getInetAddress();
    }

    public final boolean hasCurrentWorkingDirectory() {
        return this.m_cwd != null;
    }

    public final void setRootPath(FTPPath rootPath) {
        this.m_cwd = new FTPPath(rootPath);
        if (rootPath.hasSharedDevice()) {
            this.m_cwd.setSharedDevice(rootPath.getSharedDevice());
        } else {
            this.m_cwd.setSharedDevice(this.getShareList(), this);
        }
    }

    protected final FTPPath generatePathForRequest(FTPRequest req, boolean filePath) {
        return this.generatePathForRequest(req, filePath, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final FTPPath generatePathForRequest(FTPRequest req, boolean filePath, boolean checkExists) {
        FTPPath ftpPath;
        block25: {
            SharedDeviceList shareList = null;
            shareList = this.getClientInformation().isGuest() ? this.getDynamicShareList() : this.getShareList();
            String path = this.convertToFTPSeperators(req.getArgument());
            ftpPath = null;
            if (path.compareTo("/") == 0) {
                FTPNetworkServer ftpSrv = (FTPNetworkServer)this.getServer();
                if (ftpSrv.hasRootPath()) {
                    ftpPath = ftpSrv.getRootPath();
                    break block25;
                } else {
                    try {
                        return new FTPPath("/");
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    return ftpPath;
                }
            }
            if (!FTPPath.isRelativePath(path)) {
                try {
                    ftpPath = new FTPPath(path);
                }
                catch (InvalidPathException ex) {
                    return null;
                }
                if (!ftpPath.setSharedDevice(shareList, this)) {
                    return null;
                }
            } else {
                if (path.equals(".")) {
                    return this.m_cwd;
                }
                if (path.equals("..")) {
                    if (this.m_cwd.isRootPath()) return null;
                    this.m_cwd.removeDirectory();
                    this.m_cwd.setSharedDevice(shareList, this);
                    return this.m_cwd;
                }
                ftpPath = new FTPPath(this.m_cwd);
                if (ftpPath.isRootPath()) {
                    try {
                        ftpPath.setSharePath(path, null);
                    }
                    catch (InvalidPathException ex) {
                        return null;
                    }
                } else if (filePath) {
                    ftpPath.addFile(path);
                } else {
                    ftpPath.addDirectory(path);
                }
                if (!ftpPath.hasSharedDevice() && !ftpPath.setSharedDevice(shareList, this)) {
                    return null;
                }
            }
        }
        if (!checkExists) return ftpPath;
        DiskInterface disk = null;
        TreeConnection tree = null;
        try {
            tree = this.getTreeConnection(ftpPath.getSharedDevice());
            disk = (DiskInterface)ftpPath.getSharedDevice().getInterface();
            int sts = disk.fileExists(this, tree, ftpPath.getSharePath());
            if (sts == 0) {
                String pathStr = req.getArgument();
                if (!pathStr.startsWith("/")) {
                    pathStr = "/" + pathStr;
                }
                if (!(ftpPath = new FTPPath(pathStr)).setSharedDevice(this.getShareList(), this)) {
                    return null;
                }
                sts = disk.fileExists(this, tree, ftpPath.getSharePath());
                if (sts != 0) return ftpPath;
                return null;
            }
            if (sts == 1) {
                if (!filePath) return null;
            }
            if (sts != 2) return ftpPath;
            if (!filePath) return ftpPath;
            return null;
        }
        catch (Exception ex) {
            if (!logger.isErrorEnabled()) return null;
            logger.error((Object)"Error generating FTP path", (Throwable)ex);
            return null;
        }
    }

    protected final String convertToFTPSeperators(String path) {
        if (path == null || path.indexOf(DIR_SEPERATOR) == -1) {
            return path;
        }
        return path.replace('\\', '/');
    }

    protected final DiskSharedDevice findShare(String name) {
        if (name == null) {
            return null;
        }
        SharedDevice shr = this.getFTPServer().getShareList().findShare(this.m_cwd.getShareName());
        if (shr != null && shr instanceof DiskSharedDevice) {
            return (DiskSharedDevice)shr;
        }
        return null;
    }

    protected final void setBinary(boolean bin) {
        this.m_binary = bin;
    }

    protected final void sendFTPResponse(int stsCode, String msg) throws IOException {
        this.m_outbuf.setLength(0);
        this.m_outbuf.append(stsCode);
        this.m_outbuf.append(" ");
        if (msg != null) {
            this.m_outbuf.append(msg);
        }
        if (logger.isDebugEnabled() && this.hasDebug(32) && stsCode >= 500) {
            logger.debug((Object)("Error status=" + stsCode + ", msg=" + msg));
        }
        this.m_outbuf.append(CRLF);
        if (this.m_out != null) {
            this.m_out.write(this.m_outbuf.toString());
            this.m_out.flush();
        }
    }

    protected final void sendFTPResponse(StringBuffer msg) throws IOException {
        if (this.m_out != null) {
            this.m_out.write(msg.toString());
            this.m_out.write(CRLF);
            this.m_out.flush();
        }
    }

    protected final void procUser(FTPRequest req) throws IOException {
        this.setClientInformation(null);
        this.setLoggedOn(false);
        if (!req.hasArgument()) {
            this.sendFTPResponse(501, "Syntax error in parameters or arguments");
            return;
        }
        if (this.getFTPServer().allowAnonymous() && req.getArgument().equalsIgnoreCase(this.getFTPServer().getAnonymousAccount())) {
            ClientInfo cinfo = new ClientInfo(this.getFTPServer().getAnonymousAccount(), null);
            cinfo.setGuest(true);
            this.setClientInformation(cinfo);
            this.sendFTPResponse(331, "Guest login ok, send your complete e-mail address as password");
            return;
        }
        this.setClientInformation(new ClientInfo(req.getArgument(), null));
        this.sendFTPResponse(331, "User name okay, need password for " + req.getArgument());
    }

    protected final void procPassword(FTPRequest req) throws IOException {
        ClientInfo cInfo;
        block17: {
            if (!this.hasClientInformation()) {
                this.sendFTPResponse(500, "Syntax error, command " + FTPCommand.getCommandName(req.isCommand()) + " unrecognized");
                return;
            }
            cInfo = this.getClientInformation();
            if (cInfo.isGuest()) {
                if (this.getFTPServer().allowAnonymous()) {
                    AuthenticationComponent authComponent = this.getServer().getConfiguration().getAuthenticationComponent();
                    cInfo.setUserName(authComponent.getGuestUserName());
                } else {
                    this.sendFTPResponse(530, "Access denied");
                    if (logger.isDebugEnabled() && this.hasDebug(1)) {
                        logger.debug((Object)"Anonymous logon not allowed");
                    }
                    this.closeSession();
                }
            }
            cInfo.setPassword(req.getArgument());
            AuthenticationService authService = this.getServer().getConfiguration().getAuthenticationService();
            try {
                if (cInfo.isGuest()) {
                    authService.authenticateAsGuest();
                } else {
                    authService.authenticate(cInfo.getUserName(), cInfo.getPasswordAsCharArray());
                }
                this.sendFTPResponse(230, "User logged in, proceed");
                this.setLoggedOn(true);
                if (logger.isDebugEnabled() && this.hasDebug(1)) {
                    logger.debug((Object)("User " + this.getClientInformation().getUserName() + ", logon successful"));
                }
            }
            catch (AuthenticationException ex) {
                if (!logger.isDebugEnabled()) break block17;
                logger.debug((Object)"Logon failed", (Throwable)((Object)ex));
            }
        }
        if (this.isLoggedOn()) {
            this.getFTPServer().sessionLoggedOn(this);
            if (cInfo.isGuest()) {
                FTPPath guestRoot;
                block18: {
                    DiskSharedDevice guestShare = this.createHomeDiskShare(cInfo);
                    this.addDynamicShare(guestShare);
                    StringBuilder rootPath = new StringBuilder();
                    rootPath.append("/");
                    rootPath.append(guestShare.getName());
                    rootPath.append("/");
                    guestRoot = null;
                    try {
                        guestRoot = new FTPPath(rootPath.toString());
                        guestRoot.setSharedDevice(guestShare);
                        this.setRootPath(guestRoot);
                    }
                    catch (InvalidPathException ex) {
                        if (!logger.isErrorEnabled()) break block18;
                        logger.error((Object)"Error setting guest FTP root path", (Throwable)ex);
                    }
                }
                if (logger.isDebugEnabled() && this.hasDebug(1)) {
                    logger.debug((Object)("  Using root path " + guestRoot));
                }
            }
        } else {
            this.sendFTPResponse(530, "Access denied");
            if (logger.isDebugEnabled() && this.hasDebug(1)) {
                logger.debug((Object)("User " + this.getClientInformation().getUserName() + ", logon failed"));
            }
            this.closeSession();
        }
    }

    protected final void procPort(FTPRequest req) throws IOException {
        if (!this.isLoggedOn()) {
            this.sendFTPResponse(500, "");
            return;
        }
        if (!req.hasArgument()) {
            this.sendFTPResponse(501, "Required argument missing");
            return;
        }
        StringTokenizer token = new StringTokenizer(req.getArgument(), ",");
        if (token.countTokens() != 6) {
            this.sendFTPResponse(501, "Invalid argument");
            return;
        }
        String addrStr = token.nextToken() + "." + token.nextToken() + "." + token.nextToken() + "." + token.nextToken();
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(addrStr);
        }
        catch (UnknownHostException ex) {
            this.sendFTPResponse(501, "Invalid argument (address)");
            return;
        }
        int port = -1;
        try {
            port = Integer.parseInt(token.nextToken()) * 256;
        }
        catch (NumberFormatException ex) {
            this.sendFTPResponse(501, "Invalid argument (port)");
            return;
        }
        this.m_dataSess = this.getFTPServer().allocateDataSession(this, addr, port += Integer.parseInt(token.nextToken()));
        this.sendFTPResponse(200, "Port OK");
        if (logger.isDebugEnabled() && this.hasDebug(256)) {
            logger.debug((Object)("Port open addr=" + addr + ", port=" + port));
        }
    }

    protected final void procPassive(FTPRequest req) throws IOException {
        if (!this.isLoggedOn()) {
            this.sendFTPResponse(500, "");
            return;
        }
        try {
            this.m_dataSess = this.getFTPServer().allocateDataSession(this, null, 0);
        }
        catch (IOException ex) {
            this.m_dataSess = null;
        }
        if (this.m_dataSess == null) {
            this.sendFTPResponse(550, "Requested action not taken");
            return;
        }
        int pasvPort = this.m_dataSess.getPassivePort();
        StringBuffer msg = new StringBuffer();
        msg.append("227 Entering Passive Mode (");
        msg.append(this.getFTPServer().getLocalFTPAddressString());
        msg.append(",");
        msg.append(pasvPort >> 8);
        msg.append(",");
        msg.append(pasvPort & 0xFF);
        msg.append(")");
        this.sendFTPResponse(msg);
        if (logger.isDebugEnabled() && this.hasDebug(256)) {
            logger.debug((Object)("Passive open addr=" + this.getFTPServer().getLocalFTPAddressString() + ", port=" + pasvPort));
        }
    }

    protected final void procPrintWorkDir(FTPRequest req) throws IOException {
        if (!this.isLoggedOn()) {
            this.sendFTPResponse(500, "");
            return;
        }
        this.sendFTPResponse(257, "\"" + this.m_cwd.getFTPPath() + "\"");
        if (logger.isDebugEnabled() && this.hasDebug(512)) {
            logger.debug((Object)("Pwd ftp=" + this.m_cwd.getFTPPath() + ", share=" + this.m_cwd.getShareName() + ", path=" + this.m_cwd.getSharePath()));
        }
    }

    protected final void procChangeWorkDir(FTPRequest req) throws IOException {
        if (!this.isLoggedOn()) {
            this.sendFTPResponse(500, "");
            return;
        }
        if (!req.hasArgument()) {
            this.sendFTPResponse(501, "Path not specified");
            return;
        }
        FTPPath newPath = this.generatePathForRequest(req, false);
        if (newPath == null) {
            this.sendFTPResponse(550, "Invalid path " + req.getArgument());
            return;
        }
        this.m_cwd = newPath;
        this.sendFTPResponse(250, "Requested file action OK");
        if (logger.isDebugEnabled() && this.hasDebug(512)) {
            logger.debug((Object)("Cwd ftp=" + this.m_cwd.getFTPPath() + ", share=" + this.m_cwd.getShareName() + ", path=" + this.m_cwd.getSharePath()));
        }
    }

    protected final void procCdup(FTPRequest req) throws IOException {
        if (!this.isLoggedOn()) {
            this.sendFTPResponse(500, "");
            return;
        }
        if (this.m_cwd.isRootPath()) {
            this.sendFTPResponse(550, "Already at root directory");
            return;
        }
        this.m_cwd.removeDirectory();
        if (!this.m_cwd.isRootPath() && this.m_cwd.getSharedDevice() == null) {
            this.m_cwd.setSharedDevice(this.getShareList(), this);
        }
        this.sendFTPResponse(250, "Requested file action OK");
        if (logger.isDebugEnabled() && this.hasDebug(512)) {
            logger.debug((Object)("Cdup ftp=" + this.m_cwd.getFTPPath() + ", share=" + this.m_cwd.getShareName() + ", path=" + this.m_cwd.getSharePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void procList(FTPRequest req) throws IOException {
        TreeConnection tree;
        if (!this.isLoggedOn()) {
            this.sendFTPResponse(500, "");
            return;
        }
        boolean hidden = false;
        if (req.hasArgument() && req.getArgument().startsWith(LIST_OPTION_HIDDEN)) {
            hidden = true;
            String arg = req.getArgument();
            int pos = arg.indexOf(" ");
            arg = pos > 0 ? arg.substring(pos + 1) : null;
            req.updateArgument(arg);
        }
        FTPPath ftpPath = this.m_cwd;
        if (req.hasArgument()) {
            ftpPath = this.generatePathForRequest(req, true);
        }
        if (ftpPath == null) {
            this.sendFTPResponse(500, "Invalid path");
            return;
        }
        if (!(ftpPath.isRootPath() || (tree = this.getTreeConnection(ftpPath.getSharedDevice())) != null && tree.hasReadAccess())) {
            this.sendFTPResponse(550, "Access denied");
            return;
        }
        this.sendFTPResponse(150, "File status okay, about to open data connection");
        if (this.m_dataSess == null) {
            this.sendFTPResponse(425, "Can't open data connection");
            return;
        }
        Socket dataSock = null;
        try {
            dataSock = this.m_dataSess.getSocket();
        }
        catch (Exception ex) {
            logger.debug((Object)ex);
        }
        if (dataSock == null) {
            this.sendFTPResponse(426, "Connection closed; transfer aborted");
            return;
        }
        OutputStreamWriter dataWrt = null;
        try {
            dataWrt = new OutputStreamWriter(dataSock.getOutputStream());
            Vector<FileInfo> files = null;
            if (req.hasArgument()) {
                // empty if block
            }
            if ((files = this.listFilesForPath(ftpPath, false, hidden)) != null) {
                if (logger.isDebugEnabled() && this.hasDebug(2)) {
                    logger.debug((Object)("List found " + files.size() + " files in " + ftpPath.getFTPPath()));
                }
                StringBuffer str = new StringBuffer(256);
                for (FileInfo finfo : files) {
                    str.setLength(0);
                    str.append(finfo.isDirectory() ? "d" : "-");
                    str.append("rw-rw-rw-   1 user group ");
                    str.append(finfo.getSize());
                    str.append(" ");
                    FTPDate.packUnixDate(str, new Date(finfo.getModifyDateTime()));
                    str.append(" ");
                    str.append(finfo.getFileName());
                    str.append(CRLF);
                    dataWrt.write(str.toString());
                }
                ((Writer)dataWrt).flush();
            }
            ((Writer)dataWrt).close();
            dataWrt = null;
            this.getFTPServer().releaseDataSession(this.m_dataSess);
            this.m_dataSess = null;
            this.sendFTPResponse(226, "Closing data connection");
        }
        catch (Exception ex) {
            this.sendFTPResponse(451, "Error reading file list");
        }
        finally {
            if (dataWrt != null) {
                ((Writer)dataWrt).close();
            }
            if (this.m_dataSess != null) {
                this.getFTPServer().releaseDataSession(this.m_dataSess);
                this.m_dataSess = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void procNList(FTPRequest req) throws IOException {
        TreeConnection tree;
        if (!this.isLoggedOn()) {
            this.sendFTPResponse(500, "");
            return;
        }
        FTPPath ftpPath = this.m_cwd;
        if (req.hasArgument()) {
            ftpPath = this.generatePathForRequest(req, true);
        }
        if (ftpPath == null) {
            this.sendFTPResponse(500, "Invalid path");
            return;
        }
        if (!(ftpPath.isRootPath() || (tree = this.getTreeConnection(ftpPath.getSharedDevice())) != null && tree.hasReadAccess())) {
            this.sendFTPResponse(550, "Access denied");
            return;
        }
        this.sendFTPResponse(150, "File status okay, about to open data connection");
        if (this.m_dataSess == null) {
            this.sendFTPResponse(425, "Can't open data connection");
            return;
        }
        Socket dataSock = null;
        try {
            dataSock = this.m_dataSess.getSocket();
        }
        catch (Exception ex) {
            logger.error((Object)"Data socket error", (Throwable)ex);
        }
        if (dataSock == null) {
            this.sendFTPResponse(426, "Connection closed; transfer aborted");
            return;
        }
        OutputStreamWriter dataWrt = null;
        try {
            dataWrt = new OutputStreamWriter(dataSock.getOutputStream());
            Vector<FileInfo> files = null;
            if (req.hasArgument()) {
                // empty if block
            }
            if ((files = this.listFilesForPath(ftpPath, false, false)) != null) {
                if (logger.isDebugEnabled() && this.hasDebug(2)) {
                    logger.debug((Object)("List found " + files.size() + " files in " + ftpPath.getFTPPath()));
                }
                for (FileInfo finfo : files) {
                    dataWrt.write(finfo.getFileName());
                    dataWrt.write(CRLF);
                }
            }
            this.sendFTPResponse(226, "Closing data connection");
        }
        catch (Exception ex) {
            this.sendFTPResponse(451, "Error reading file list");
        }
        finally {
            if (dataWrt != null) {
                ((Writer)dataWrt).close();
            }
            if (this.m_dataSess != null) {
                this.getFTPServer().releaseDataSession(this.m_dataSess);
                this.m_dataSess = null;
            }
        }
    }

    protected final void procSystemStatus(FTPRequest req) throws IOException {
        this.sendFTPResponse(215, "UNIX Type: Java FTP Server");
    }

    protected final void procServerStatus(FTPRequest req) throws IOException {
        this.sendFTPResponse(211, "JLAN Server - Java FTP Server");
    }

    protected final void procHelp(FTPRequest req) throws IOException {
        this.sendFTPResponse(211, "HELP text");
    }

    protected final void procNoop(FTPRequest req) throws IOException {
        this.sendFTPResponse(200, "");
    }

    protected final void procQuit(FTPRequest req) throws IOException {
        this.sendFTPResponse(221, "Bye");
        if (logger.isDebugEnabled() && this.hasDebug(1)) {
            logger.debug((Object)"Quit closing connection(s) to client");
        }
        this.closeSession();
    }

    protected final void procType(FTPRequest req) throws IOException {
        if (!req.hasArgument()) {
            this.sendFTPResponse(501, "Syntax error, parameter required");
            return;
        }
        String arg = req.getArgument().toUpperCase();
        if (arg.startsWith("A")) {
            this.setBinary(false);
        } else if (arg.startsWith("I") || arg.startsWith("L")) {
            this.setBinary(true);
        } else {
            this.sendFTPResponse(501, "Syntax error, invalid parameter");
            return;
        }
        this.sendFTPResponse(200, "Command OK");
        if (logger.isDebugEnabled() && this.hasDebug(1)) {
            logger.debug((Object)("Type arg=" + req.getArgument() + ", binary=" + this.m_binary));
        }
    }

    protected final void procRestart(FTPRequest req) throws IOException {
        if (!this.isLoggedOn()) {
            this.sendFTPResponse(500, "");
            return;
        }
        if (!req.hasArgument()) {
            this.sendFTPResponse(501, "Syntax error, parameter required");
            return;
        }
        try {
            this.m_restartPos = Integer.parseInt(req.getArgument());
        }
        catch (NumberFormatException ex) {
            this.sendFTPResponse(501, "Invalid restart position");
            return;
        }
        this.sendFTPResponse(350, "Restart OK");
        if (logger.isDebugEnabled() && this.hasDebug(16)) {
            logger.debug((Object)("Restart pos=" + this.m_restartPos));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void procReturnFile(FTPRequest req) throws IOException {
        OutputStream os;
        block31: {
            if (!this.isLoggedOn()) {
                this.sendFTPResponse(500, "");
                return;
            }
            if (!req.hasArgument()) {
                this.sendFTPResponse(501, "Syntax error, parameter required");
                return;
            }
            FTPPath ftpPath = this.generatePathForRequest(req, true);
            if (ftpPath == null) {
                this.sendFTPResponse(500, "Invalid path");
                return;
            }
            if (ftpPath.isRootPath() || ftpPath.isRootSharePath()) {
                this.sendFTPResponse(550, "That is a directory");
                return;
            }
            this.sendFTPResponse(150, "Connection accepted");
            if (this.m_dataSess == null) {
                this.sendFTPResponse(425, "Can't open data connection");
                return;
            }
            Socket dataSock = null;
            try {
                dataSock = this.m_dataSess.getSocket();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (dataSock == null) {
                this.sendFTPResponse(426, "Connection closed; transfer aborted");
                return;
            }
            if (logger.isDebugEnabled() && this.hasDebug(8)) {
                logger.debug((Object)("Returning ftp=" + ftpPath.getFTPPath() + ", share=" + ftpPath.getShareName() + ", path=" + ftpPath.getSharePath()));
            }
            os = null;
            DiskInterface disk = null;
            TreeConnection tree = null;
            NetworkFile netFile = null;
            try {
                os = dataSock.getOutputStream();
                tree = this.getTreeConnection(ftpPath.getSharedDevice());
                disk = (DiskInterface)ftpPath.getSharedDevice().getInterface();
                FileOpenParams params = new FileOpenParams(ftpPath.getSharePath(), 1, 0, 0);
                int sts = disk.fileExists(this, tree, ftpPath.getSharePath());
                if (sts == 1) {
                    netFile = disk.openFile(this, tree, params);
                }
                if (netFile == null) {
                    this.sendFTPResponse(550, "File " + req.getArgument() + " not available");
                    if (netFile != null && disk != null && tree != null) {
                        disk.closeFile(this, tree, netFile);
                    }
                    if (os != null) {
                        os.close();
                    }
                    if (this.m_dataSess == null) return;
                    this.getFTPServer().releaseDataSession(this.m_dataSess);
                    this.m_dataSess = null;
                    return;
                }
                byte[] buf = new byte[64000];
                long filePos = this.m_restartPos;
                int len = -1;
                while (filePos < netFile.getFileSize()) {
                    len = disk.readFile(this, tree, netFile, buf, 0, buf.length, filePos);
                    if (logger.isDebugEnabled() && this.hasDebug(16)) {
                        logger.debug((Object)(" Write len=" + len + " bytes"));
                    }
                    if (len <= 0) continue;
                    os.write(buf, 0, len);
                    filePos += (long)len;
                }
                os.close();
                os = null;
                this.sendFTPResponse(226, "Closing data connection");
                this.getFTPServer().releaseDataSession(this.m_dataSess);
                this.m_dataSess = null;
                disk.closeFile(this, tree, netFile);
                netFile = null;
                if (logger.isDebugEnabled() && this.hasDebug(16)) {
                    logger.debug((Object)" Transfer complete, file closed");
                }
                if (netFile == null || disk == null || tree == null) break block31;
            }
            catch (SocketException ex) {
                if (logger.isDebugEnabled() && this.hasDebug(32)) {
                    logger.debug((Object)" Error during transfer", (Throwable)ex);
                }
                if (this.m_dataSess != null) {
                    this.m_dataSess.closeSession();
                    this.m_dataSess = null;
                }
                this.sendFTPResponse(426, "Data connection closed by client");
                return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                catch (Exception ex2) {
                    if (logger.isDebugEnabled() && this.hasDebug(32)) {
                        logger.debug((Object)" Error during transfer", (Throwable)ex2);
                    }
                    this.sendFTPResponse(426, "Error during transmission");
                    return;
                }
            }
            finally {
                if (netFile != null && disk != null && tree != null) {
                    disk.closeFile(this, tree, netFile);
                }
                if (os != null) {
                    os.close();
                }
                if (this.m_dataSess != null) {
                    this.getFTPServer().releaseDataSession(this.m_dataSess);
                    this.m_dataSess = null;
                }
            }
            disk.closeFile(this, tree, netFile);
        }
        if (os != null) {
            os.close();
        }
        if (this.m_dataSess == null) return;
        this.getFTPServer().releaseDataSession(this.m_dataSess);
        this.m_dataSess = null;
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void procStoreFile(FTPRequest req) throws IOException {
        NetworkFile netFile;
        TreeConnection tree;
        DiskInterface disk;
        InputStream is;
        block47: {
            block48: {
                block45: {
                    block46: {
                        block43: {
                            block44: {
                                if (!this.isLoggedOn()) {
                                    this.sendFTPResponse(500, "");
                                    return;
                                }
                                if (!req.hasArgument()) {
                                    this.sendFTPResponse(501, "Syntax error, parameter required");
                                    return;
                                }
                                FTPPath ftpPath = this.generatePathForRequest(req, true, false);
                                if (ftpPath == null) {
                                    this.sendFTPResponse(500, "Invalid path");
                                    return;
                                }
                                is = null;
                                disk = null;
                                tree = null;
                                netFile = null;
                                try {
                                    tree = this.getTreeConnection(ftpPath.getSharedDevice());
                                    if (tree == null || !tree.hasWriteAccess()) {
                                        this.sendFTPResponse(550, "Access denied");
                                        return;
                                    }
                                    disk = (DiskInterface)ftpPath.getSharedDevice().getInterface();
                                    int sts = disk.fileExists(this, tree, ftpPath.getSharePath());
                                    if (sts == 2) {
                                        this.sendFTPResponse(500, "Invalid path (existing directory)");
                                        return;
                                    }
                                    FileOpenParams params = new FileOpenParams(ftpPath.getSharePath(), sts == 1 ? 2 : 16, 2, 0);
                                    netFile = sts == 1 ? disk.openFile(this, tree, params) : disk.createFile(this, tree, params);
                                    DiskDeviceContext diskCtx = (DiskDeviceContext)tree.getContext();
                                    if (diskCtx.hasChangeHandler()) {
                                        diskCtx.getChangeHandler().notifyFileChanged(1, ftpPath.getSharePath());
                                    }
                                    this.sendFTPResponse(150, "File status okay, about to open data connection");
                                    if (this.m_dataSess == null) {
                                        this.sendFTPResponse(425, "Can't open data connection");
                                        if (netFile == null || disk == null || tree == null) break block43;
                                        break block44;
                                    }
                                    Socket dataSock = null;
                                    try {
                                        dataSock = this.m_dataSess.getSocket();
                                    }
                                    catch (Exception ex) {
                                        // empty catch block
                                    }
                                    if (dataSock == null) {
                                        this.sendFTPResponse(426, "Connection closed; transfer aborted");
                                        if (netFile == null) break block45;
                                        break block46;
                                    }
                                    is = dataSock.getInputStream();
                                    if (logger.isDebugEnabled() && this.hasDebug(8)) {
                                        logger.debug((Object)("Storing ftp=" + ftpPath.getFTPPath() + ", share=" + ftpPath.getShareName() + ", path=" + ftpPath.getSharePath()));
                                    }
                                    byte[] buf = new byte[64000];
                                    long filePos = 0L;
                                    int len = is.read(buf, 0, buf.length);
                                    while (len > 0) {
                                        if (logger.isDebugEnabled() && this.hasDebug(16)) {
                                            logger.debug((Object)(" Receive len=" + len + " bytes"));
                                        }
                                        disk.writeFile(this, tree, netFile, buf, 0, len, filePos);
                                        filePos += (long)len;
                                        len = is.read(buf, 0, buf.length);
                                    }
                                    is.close();
                                    is = null;
                                    disk.closeFile(this, tree, netFile);
                                    netFile = null;
                                    this.sendFTPResponse(226, "Closing data connection");
                                    if (logger.isDebugEnabled() && this.hasDebug(16)) {
                                        logger.debug((Object)" Transfer complete, file closed");
                                    }
                                    if (netFile == null) break block47;
                                    break block48;
                                }
                                catch (AccessDeniedException ex) {
                                    if (logger.isDebugEnabled() && this.hasDebug(32)) {
                                        logger.debug((Object)" Access denied", (Throwable)ex);
                                    }
                                    this.sendFTPResponse(550, "Access denied");
                                    return;
                                }
                                catch (SocketException ex) {
                                    if (logger.isDebugEnabled() && this.hasDebug(32)) {
                                        logger.debug((Object)" Error during transfer", (Throwable)ex);
                                    }
                                    if (this.m_dataSess != null) {
                                        this.getFTPServer().releaseDataSession(this.m_dataSess);
                                        this.m_dataSess = null;
                                    }
                                    this.sendFTPResponse(426, "Data connection closed by client");
                                    return;
                                }
                                catch (DiskFullException ex) {
                                    if (logger.isDebugEnabled() && this.hasDebug(32)) {
                                        logger.debug((Object)" Error during transfer", (Throwable)ex);
                                    }
                                    if (this.m_dataSess != null) {
                                        this.getFTPServer().releaseDataSession(this.m_dataSess);
                                        this.m_dataSess = null;
                                    }
                                    this.sendFTPResponse(451, "Disk full");
                                    return;
                                }
                                catch (Exception ex) {
                                    if (logger.isDebugEnabled() && this.hasDebug(32)) {
                                        logger.debug((Object)" Error during transfer", (Throwable)ex);
                                    }
                                    this.sendFTPResponse(426, "Error during transmission");
                                    return;
                                }
                            }
                            disk.closeFile(this, tree, netFile);
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (this.m_dataSess == null) return;
                        this.getFTPServer().releaseDataSession(this.m_dataSess);
                        this.m_dataSess = null;
                        return;
                    }
                    if (disk != null && tree != null) {
                        disk.closeFile(this, tree, netFile);
                    }
                }
                if (is != null) {
                    is.close();
                }
                if (this.m_dataSess == null) return;
                this.getFTPServer().releaseDataSession(this.m_dataSess);
                this.m_dataSess = null;
                return;
            }
            if (disk != null && tree != null) {
                disk.closeFile(this, tree, netFile);
            }
        }
        if (is != null) {
            is.close();
        }
        if (this.m_dataSess == null) return;
        this.getFTPServer().releaseDataSession(this.m_dataSess);
        this.m_dataSess = null;
        return;
        finally {
            if (netFile != null && disk != null && tree != null) {
                disk.closeFile(this, tree, netFile);
            }
            if (is != null) {
                is.close();
            }
            if (this.m_dataSess != null) {
                this.getFTPServer().releaseDataSession(this.m_dataSess);
                this.m_dataSess = null;
            }
        }
    }

    protected final void procDeleteFile(FTPRequest req) throws IOException {
        block11: {
            if (!this.isLoggedOn()) {
                this.sendFTPResponse(500, "");
                return;
            }
            if (!req.hasArgument()) {
                this.sendFTPResponse(501, "Syntax error, parameter required");
                return;
            }
            FTPPath ftpPath = this.generatePathForRequest(req, true);
            if (ftpPath == null) {
                this.sendFTPResponse(550, "Invalid path specified");
                return;
            }
            DiskInterface disk = null;
            TreeConnection tree = null;
            try {
                tree = this.getTreeConnection(ftpPath.getSharedDevice());
                if (tree == null || !tree.hasWriteAccess()) {
                    this.sendFTPResponse(550, "Access denied");
                    return;
                }
                disk = (DiskInterface)ftpPath.getSharedDevice().getInterface();
                int sts = disk.fileExists(this, tree, ftpPath.getSharePath());
                if (sts == 1) {
                    disk.deleteFile(this, tree, ftpPath.getSharePath());
                    DiskDeviceContext diskCtx = (DiskDeviceContext)tree.getContext();
                    if (diskCtx.hasChangeHandler()) {
                        diskCtx.getChangeHandler().notifyFileChanged(2, ftpPath.getSharePath());
                    }
                    if (logger.isDebugEnabled() && this.hasDebug(8)) {
                        logger.debug((Object)("Deleted ftp=" + ftpPath.getFTPPath() + ", share=" + ftpPath.getShareName() + ", path=" + ftpPath.getSharePath()));
                    }
                    break block11;
                }
                this.sendFTPResponse(550, "File " + req.getArgument() + (sts == 0 ? " not available" : " is a directory"));
                return;
            }
            catch (AccessDeniedException ex) {
                if (logger.isDebugEnabled() && this.hasDebug(32)) {
                    logger.debug((Object)" Access denied", (Throwable)ex);
                }
                this.sendFTPResponse(550, "Access denied");
            }
            catch (Exception ex) {
                this.sendFTPResponse(450, "File action not taken");
                return;
            }
        }
        this.sendFTPResponse(250, "File " + req.getArgument() + " deleted");
    }

    protected final void procRenameFrom(FTPRequest req) throws IOException {
        block8: {
            if (!this.isLoggedOn()) {
                this.sendFTPResponse(500, "");
                return;
            }
            if (!req.hasArgument()) {
                this.sendFTPResponse(501, "Syntax error, parameter required");
                return;
            }
            this.m_renameFrom = null;
            FTPPath ftpPath = this.generatePathForRequest(req, false, false);
            if (ftpPath == null) {
                this.sendFTPResponse(550, "Invalid path specified");
                return;
            }
            DiskInterface disk = null;
            TreeConnection tree = null;
            try {
                tree = this.getTreeConnection(ftpPath.getSharedDevice());
                if (tree == null || !tree.hasWriteAccess()) {
                    this.sendFTPResponse(550, "Access denied");
                    return;
                }
                disk = (DiskInterface)ftpPath.getSharedDevice().getInterface();
                int sts = disk.fileExists(this, tree, ftpPath.getSharePath());
                if (sts != 0) {
                    this.m_renameFrom = ftpPath;
                    if (logger.isDebugEnabled() && this.hasDebug(8)) {
                        logger.debug((Object)("RenameFrom ftp=" + ftpPath.getFTPPath() + ", share=" + ftpPath.getShareName() + ", path=" + ftpPath.getSharePath()));
                    }
                    break block8;
                }
                this.sendFTPResponse(550, "File " + req.getArgument() + (sts == 0 ? " not available" : " is a directory"));
                return;
            }
            catch (Exception ex) {
                this.sendFTPResponse(450, "File action not taken");
                return;
            }
        }
        this.sendFTPResponse(350, "File " + req.getArgument() + " OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void procRenameTo(FTPRequest req) throws IOException {
        block15: {
            if (!this.isLoggedOn()) {
                this.sendFTPResponse(500, "");
                return;
            }
            if (!req.hasArgument()) {
                this.sendFTPResponse(501, "Syntax error, parameter required");
                return;
            }
            if (this.m_renameFrom == null) {
                this.sendFTPResponse(550, "Rename from not set");
                return;
            }
            FTPPath ftpPath = this.generatePathForRequest(req, true, false);
            if (ftpPath == null) {
                this.sendFTPResponse(550, "Invalid path specified");
                return;
            }
            if (this.m_renameFrom.getShareName().compareTo(ftpPath.getShareName()) != 0) {
                this.sendFTPResponse(550, "Cannot rename across shares");
                return;
            }
            DiskInterface disk = null;
            TreeConnection tree = null;
            try {
                tree = this.getTreeConnection(ftpPath.getSharedDevice());
                if (tree == null || !tree.hasWriteAccess()) {
                    this.sendFTPResponse(550, "Access denied");
                    return;
                }
                disk = (DiskInterface)ftpPath.getSharedDevice().getInterface();
                int sts = disk.fileExists(this, tree, ftpPath.getSharePath());
                if (sts == 0) {
                    disk.renameFile(this, tree, this.m_renameFrom.getSharePath(), ftpPath.getSharePath());
                    DiskDeviceContext diskCtx = (DiskDeviceContext)tree.getContext();
                    if (diskCtx.hasChangeHandler()) {
                        diskCtx.getChangeHandler().notifyRename(this.m_renameFrom.getSharePath(), ftpPath.getSharePath());
                    }
                    if (logger.isDebugEnabled() && this.hasDebug(8)) {
                        logger.debug((Object)("RenameTo ftp=" + ftpPath.getFTPPath() + ", share=" + ftpPath.getShareName() + ", path=" + ftpPath.getSharePath()));
                    }
                    break block15;
                }
                this.sendFTPResponse(550, "File " + req.getArgument() + (sts == 0 ? " not available" : " is a directory"));
                return;
            }
            catch (Exception ex) {
                this.sendFTPResponse(450, "File action not taken");
                return;
            }
            finally {
                this.m_renameFrom = null;
            }
        }
        this.sendFTPResponse(250, "File renamed OK");
    }

    protected final void procCreateDirectory(FTPRequest req) throws IOException {
        FTPPath ftpPath;
        block9: {
            if (!this.isLoggedOn()) {
                this.sendFTPResponse(500, "");
                return;
            }
            if (!req.hasArgument()) {
                this.sendFTPResponse(501, "Syntax error, parameter required");
                return;
            }
            ftpPath = this.generatePathForRequest(req, false, false);
            if (ftpPath == null) {
                this.sendFTPResponse(550, "Invalid path " + req.getArgument());
                return;
            }
            DiskInterface disk = null;
            TreeConnection tree = null;
            Object netFile = null;
            try {
                tree = this.getTreeConnection(ftpPath.getSharedDevice());
                if (tree == null || !tree.hasWriteAccess()) {
                    this.sendFTPResponse(550, "Access denied");
                    return;
                }
                disk = (DiskInterface)ftpPath.getSharedDevice().getInterface();
                int sts = disk.fileExists(this, tree, ftpPath.getSharePath());
                if (sts == 0) {
                    FileOpenParams params = new FileOpenParams(ftpPath.getSharePath(), 16, 2, 16);
                    disk.createDirectory(this, tree, params);
                    DiskDeviceContext diskCtx = (DiskDeviceContext)tree.getContext();
                    if (diskCtx.hasChangeHandler()) {
                        diskCtx.getChangeHandler().notifyFileChanged(1, ftpPath.getSharePath());
                    }
                    if (logger.isDebugEnabled() && this.hasDebug(512)) {
                        logger.debug((Object)("CreateDir ftp=" + ftpPath.getFTPPath() + ", share=" + ftpPath.getShareName() + ", path=" + ftpPath.getSharePath()));
                    }
                    break block9;
                }
                this.sendFTPResponse(450, sts == 1 ? "File exists with that name" : "Directory already exists");
                return;
            }
            catch (Exception ex) {
                this.sendFTPResponse(450, "Failed to create directory");
                return;
            }
        }
        this.sendFTPResponse(250, ftpPath.getFTPPath());
    }

    protected final void procRemoveDirectory(FTPRequest req) throws IOException {
        block10: {
            if (!this.isLoggedOn()) {
                this.sendFTPResponse(500, "");
                return;
            }
            if (!req.hasArgument()) {
                this.sendFTPResponse(501, "Syntax error, parameter required");
                return;
            }
            FTPPath ftpPath = this.generatePathForRequest(req, false);
            if (ftpPath == null) {
                this.sendFTPResponse(550, "Invalid path " + req.getArgument());
                return;
            }
            if (ftpPath.isRootPath() || ftpPath.isRootSharePath()) {
                this.sendFTPResponse(550, "Access denied, cannot delete directory in root");
                return;
            }
            DiskInterface disk = null;
            TreeConnection tree = null;
            Object netFile = null;
            try {
                tree = this.getTreeConnection(ftpPath.getSharedDevice());
                if (tree == null || !tree.hasWriteAccess()) {
                    this.sendFTPResponse(550, "Access denied");
                    return;
                }
                disk = (DiskInterface)ftpPath.getSharedDevice().getInterface();
                int sts = disk.fileExists(this, tree, ftpPath.getSharePath());
                if (sts == 2) {
                    disk.deleteDirectory(this, tree, ftpPath.getSharePath());
                    DiskDeviceContext diskCtx = (DiskDeviceContext)tree.getContext();
                    if (diskCtx.hasChangeHandler()) {
                        diskCtx.getChangeHandler().notifyFileChanged(2, ftpPath.getSharePath());
                    }
                    if (logger.isDebugEnabled() && this.hasDebug(512)) {
                        logger.debug((Object)("DeleteDir ftp=" + ftpPath.getFTPPath() + ", share=" + ftpPath.getShareName() + ", path=" + ftpPath.getSharePath()));
                    }
                    break block10;
                }
                this.sendFTPResponse(550, sts == 1 ? "File exists with that name" : "Directory does not exist");
                return;
            }
            catch (Exception ex) {
                this.sendFTPResponse(550, "Failed to delete directory");
                return;
            }
        }
        this.sendFTPResponse(250, "Directory deleted OK");
    }

    protected final void procModifyDateTime(FTPRequest req) throws IOException {
        this.sendFTPResponse(550, "Not implemented yet");
    }

    protected final void procFileSize(FTPRequest req) throws IOException {
        if (!this.isLoggedOn()) {
            this.sendFTPResponse(500, "");
            return;
        }
        if (!req.hasArgument()) {
            this.sendFTPResponse(501, "Syntax error, parameter required");
            return;
        }
        FTPPath ftpPath = this.generatePathForRequest(req, true);
        if (ftpPath == null) {
            this.sendFTPResponse(500, "Invalid path");
            return;
        }
        DiskInterface disk = null;
        TreeConnection tree = null;
        try {
            tree = this.getTreeConnection(ftpPath.getSharedDevice());
            disk = (DiskInterface)ftpPath.getSharedDevice().getInterface();
            FileInfo finfo = disk.getFileInformation(this, tree, ftpPath.getSharePath());
            if (finfo == null) {
                this.sendFTPResponse(550, "File " + req.getArgument() + " not available");
                return;
            }
            this.sendFTPResponse(213, "" + finfo.getSize());
            if (logger.isDebugEnabled() && this.hasDebug(8)) {
                logger.debug((Object)("File size ftp=" + ftpPath.getFTPPath() + ", share=" + ftpPath.getShareName() + ", size=" + finfo.getSize()));
            }
        }
        catch (Exception ex) {
            this.sendFTPResponse(550, "Error retrieving file size");
        }
    }

    protected final void procStructure(FTPRequest req) throws IOException {
        if (req.hasArgument() && req.getArgument().equalsIgnoreCase("F")) {
            this.sendFTPResponse(200, "OK");
        }
        this.sendFTPResponse(504, "Obsolete");
    }

    protected final void procMode(FTPRequest req) throws IOException {
        if (req.hasArgument() && req.getArgument().equalsIgnoreCase("S")) {
            this.sendFTPResponse(200, "OK");
        }
        this.sendFTPResponse(504, "Obsolete");
    }

    protected final void procAllocate(FTPRequest req) throws IOException {
        this.sendFTPResponse(202, "Obsolete");
    }

    protected final Vector<FileInfo> listFilesForPath(FTPPath path, boolean nameOnly, boolean hidden) {
        Vector<FileInfo> files;
        block11: {
            block12: {
                if (path == null) {
                    return null;
                }
                files = new Vector<FileInfo>();
                if (path.hasSharedDevice()) break block12;
                SharedDeviceList shares = null;
                shares = this.getClientInformation().isGuest() ? this.getDynamicShareList() : this.getShareList();
                if (shares == null) break block11;
                Enumeration<SharedDevice> enm = shares.enumerateShares();
                while (enm.hasMoreElements()) {
                    SharedDevice shr = enm.nextElement();
                    if (!nameOnly) {
                        FileInfo finfo = new FileInfo(shr.getName(), 0L, 16);
                        files.add(finfo);
                        continue;
                    }
                    files.add(new FileInfo(shr.getName(), 0L, 16));
                }
                break block11;
            }
            String searchPath = path.getSharePath();
            if (path.isDirectory()) {
                searchPath = path.makeSharePathToFile("*");
            }
            TreeConnection tree = new TreeConnection(path.getSharedDevice());
            DiskInterface disk = null;
            SearchContext ctx = null;
            int searchAttr = 16;
            if (hidden) {
                searchAttr += 2;
            }
            try {
                disk = (DiskInterface)path.getSharedDevice().getInterface();
                ctx = disk.startSearch(this, tree, searchPath, searchAttr);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (ctx != null) {
                while (ctx.hasMoreFiles()) {
                    if (nameOnly) {
                        files.add(new FileInfo(ctx.nextFileName(), 0L, 0));
                        continue;
                    }
                    FileInfo finfo = new FileInfo();
                    if (ctx.nextFileInfo(finfo)) {
                        if (finfo.getFileName() == null) continue;
                        files.add(finfo);
                        continue;
                    }
                    break;
                }
            }
        }
        return files;
    }

    protected final SharedDeviceList getShareList() {
        if (this.m_shares == null) {
            SharedDeviceList shares = this.getFTPServer().getShareMapper().getShareList(this.getFTPServer().getServerName(), this, false);
            this.m_shares = new SharedDeviceList();
            Enumeration<SharedDevice> enm = shares.enumerateShares();
            while (enm.hasMoreElements()) {
                SharedDevice shr = enm.nextElement();
                if (!(shr instanceof DiskSharedDevice)) continue;
                this.m_shares.addShare(shr);
            }
            if (this.getServer().hasAccessControlManager()) {
                AccessControlManager aclMgr = this.getServer().getAccessControlManager();
                this.m_shares = aclMgr.filterShareList(this, this.m_shares);
            }
        }
        return this.m_shares;
    }

    protected final TreeConnection getTreeConnection(SharedDevice share) {
        if (share == null) {
            return null;
        }
        TreeConnection tree = this.m_connections.findConnection(share.getName());
        if (tree == null) {
            AccessControlManager aclMgr;
            int access;
            tree = new TreeConnection(share);
            if (!share.isTemporary()) {
                this.m_connections.addConnection(tree);
            }
            if (this.getServer().hasAccessControlManager() && (access = (aclMgr = this.getServer().getAccessControlManager()).checkAccessControl(this, share)) != -1) {
                tree.setPermission(access);
            }
        }
        return tree;
    }

    private final DiskSharedDevice createHomeDiskShare(ClientInfo client) {
        if (!client.hasHomeFolder()) {
            NodeService nodeService = this.getServer().getConfiguration().getNodeService();
            PersonService personService = this.getServer().getConfiguration().getPersonService();
            TransactionService transService = this.getServer().getConfiguration().getTransactionService();
            UserTransaction tx = transService.getUserTransaction();
            NodeRef homeSpaceRef = null;
            try {
                tx.begin();
                homeSpaceRef = (NodeRef)nodeService.getProperty(personService.getPerson(client.getUserName()), ContentModel.PROP_HOMEFOLDER);
                client.setHomeFolder(homeSpaceRef);
                tx.commit();
            }
            catch (Throwable ex) {
                try {
                    tx.rollback();
                }
                catch (Exception ex2) {
                    logger.error((Object)"Failed to rollback transaction", (Throwable)ex2);
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException("Failed to get home folder", (Object)ex);
            }
        }
        DiskInterface diskDrv = this.getServer().getConfiguration().getDiskInterface();
        ContentContext diskCtx = new ContentContext("", "", client.getHomeFolder());
        diskCtx.setDiskInformation(new SrvDiskInfo(2560, 64, 512, 2304));
        return new DiskSharedDevice(client.getUserName(), diskDrv, diskCtx, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (logger.isDebugEnabled() && this.hasDebug(1)) {
                logger.debug((Object)"FTP session started");
            }
            this.m_in = new InputStreamReader(this.m_sock.getInputStream());
            this.m_out = new OutputStreamWriter(this.m_sock.getOutputStream());
            this.m_inbuf = new char[512];
            this.m_outbuf = new StringBuffer(256);
            this.sendFTPResponse(220, "FTP server ready");
            long startTime = 0L;
            long endTime = 0L;
            FTPRequest ftpReq = new FTPRequest();
            int rdlen = -1;
            String cmd = null;
            while (this.m_sock != null) {
                long duration;
                rdlen = this.m_in.read(this.m_inbuf);
                if (rdlen == -1) {
                    this.closeSession();
                    continue;
                }
                if (rdlen > 0) {
                    while (rdlen > 0 && this.m_inbuf[rdlen - 1] == '\r' || this.m_inbuf[rdlen - 1] == '\n') {
                        --rdlen;
                    }
                }
                cmd = new String(this.m_inbuf, 0, rdlen);
                if (logger.isDebugEnabled() && this.hasDebug(128)) {
                    startTime = System.currentTimeMillis();
                }
                if (logger.isDebugEnabled() && this.hasDebug(64)) {
                    logger.debug((Object)("Cmd " + ftpReq));
                }
                ftpReq.setCommandLine(cmd);
                ++this.m_reqCount;
                switch (ftpReq.isCommand()) {
                    case 0: {
                        this.procUser(ftpReq);
                        break;
                    }
                    case 1: {
                        this.procPassword(ftpReq);
                        break;
                    }
                    case 7: {
                        this.procQuit(ftpReq);
                        break;
                    }
                    case 10: {
                        this.procType(ftpReq);
                        break;
                    }
                    case 8: {
                        this.procPort(ftpReq);
                        break;
                    }
                    case 9: {
                        this.procPassive(ftpReq);
                        break;
                    }
                    case 18: {
                        this.procRestart(ftpReq);
                        break;
                    }
                    case 13: {
                        this.procReturnFile(ftpReq);
                        this.m_restartPos = 0L;
                        break;
                    }
                    case 14: {
                        this.procStoreFile(ftpReq);
                        break;
                    }
                    case 25: 
                    case 37: {
                        this.procPrintWorkDir(ftpReq);
                        break;
                    }
                    case 3: 
                    case 41: {
                        this.procChangeWorkDir(ftpReq);
                        break;
                    }
                    case 4: 
                    case 40: {
                        this.procCdup(ftpReq);
                        break;
                    }
                    case 26: {
                        this.procList(ftpReq);
                        break;
                    }
                    case 27: {
                        this.procNList(ftpReq);
                        break;
                    }
                    case 22: {
                        this.procDeleteFile(ftpReq);
                        break;
                    }
                    case 19: {
                        this.procRenameFrom(ftpReq);
                        break;
                    }
                    case 20: {
                        this.procRenameTo(ftpReq);
                        break;
                    }
                    case 24: 
                    case 38: {
                        this.procCreateDirectory(ftpReq);
                        break;
                    }
                    case 23: 
                    case 39: {
                        this.procRemoveDirectory(ftpReq);
                        break;
                    }
                    case 34: {
                        this.procFileSize(ftpReq);
                        break;
                    }
                    case 33: {
                        this.procModifyDateTime(ftpReq);
                        break;
                    }
                    case 29: {
                        this.procSystemStatus(ftpReq);
                        break;
                    }
                    case 30: {
                        this.procServerStatus(ftpReq);
                        break;
                    }
                    case 31: {
                        this.procHelp(ftpReq);
                        break;
                    }
                    case 32: {
                        this.procNoop(ftpReq);
                        break;
                    }
                    case 11: {
                        this.procStructure(ftpReq);
                        break;
                    }
                    case 12: {
                        this.procMode(ftpReq);
                        break;
                    }
                    case 17: {
                        this.procAllocate(ftpReq);
                        break;
                    }
                    default: {
                        if (ftpReq.isCommand() != -1) {
                            this.sendFTPResponse(502, "Command " + FTPCommand.getCommandName(ftpReq.isCommand()) + " not implemented");
                            break;
                        }
                        this.sendFTPResponse(502, "Command not implemented");
                    }
                }
                if (logger.isDebugEnabled() && this.hasDebug(128) && (duration = (endTime = System.currentTimeMillis()) - startTime) > 20L) {
                    logger.debug((Object)("Processed cmd " + FTPCommand.getCommandName(ftpReq.isCommand()) + " in " + duration + "ms"));
                }
                try {
                    this.endTransaction();
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)"Error committing transaction", (Throwable)ex);
                }
            }
        }
        catch (SocketException ex) {
            if (logger.isErrorEnabled() && this.hasDebug(1)) {
                logger.error((Object)"Socket closed by remote client");
            }
        }
        catch (Exception ex) {
            if (!this.isShutdown()) {
                logger.debug((Object)ex);
            }
        }
        finally {
            if (this.hasUserTransaction()) {
                try {
                    this.getUserTransaction().rollback();
                }
                catch (Exception ex) {
                    logger.warn((Object)"Failed to rollback transaction", (Throwable)ex);
                }
            }
        }
        this.closeSession();
        if (this.hasDebug(1)) {
            logger.debug((Object)"Server session closed");
        }
    }
}

