/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.netbios;

import org.alfresco.filesys.netbios.NetBIOSName;
import org.alfresco.filesys.netbios.NetBIOSNameList;
import org.alfresco.filesys.netbios.NetBIOSSession;
import org.alfresco.filesys.util.DataPacker;
import org.alfresco.filesys.util.HexDump;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NetBIOSPacket {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.smb.protocol.netbios");
    public static final int MIN_RXLEN = 4;
    public static final int NAME_QUERY = 0;
    public static final int NAME_REGISTER = 5;
    public static final int NAME_RELEASE = 6;
    public static final int WACK = 7;
    public static final int REFRESH = 8;
    public static final int NAME_REGISTER_MULTI = 15;
    public static final int RESP_QUERY = 16;
    public static final int RESP_REGISTER = 21;
    public static final int RESP_RELEASE = 22;
    public static final int MASK_OPCODE = 63488;
    public static final int MASK_NMFLAGS = 2032;
    public static final int MASK_RCODE = 15;
    public static final int MASK_NOOPCODE = 2047;
    public static final int MASK_NOFLAGS = 63503;
    public static final int MASK_NORCODE = 65520;
    public static final int MASK_RESPONSE = 16;
    public static final int FLG_BROADCAST = 1;
    public static final int FLG_RECURSION = 8;
    public static final int FLG_RECURSDES = 16;
    public static final int FLG_TRUNCATION = 32;
    public static final int FLG_AUTHANSWER = 64;
    public static final int NAME_TYPE_NB = 32;
    public static final int NAME_TYPE_NBSTAT = 33;
    public static final int NAME_LEN = 32;
    public static final int NAME_CLASS_IN = 1;
    private static final int SHIFT_FLAGS = 4;
    private static final int SHIFT_OPCODE = 11;
    public static final int DEFAULT_BUFSIZE = 1024;
    private static final int NB_TRANSID = 0;
    private static final int NB_OPCODE = 2;
    private static final int NB_QDCOUNT = 4;
    private static final int NB_ANCOUNT = 6;
    private static final int NB_NSCOUNT = 8;
    private static final int NB_ARCOUNT = 10;
    private static final int NB_DATA = 12;
    public static final int FMT_ERR = 1;
    public static final int SRV_ERR = 2;
    public static final int IMP_ERR = 4;
    public static final int RFS_ERR = 5;
    public static final int ACT_ERR = 6;
    public static final int CFT_ERR = 7;
    public static final int NAME_PERM = 2;
    public static final int NAME_ACTIVE = 4;
    public static final int NAME_CONFLICT = 8;
    public static final int NAME_DEREG = 16;
    public static final int NAME_GROUP = 128;
    private byte[] m_nbbuf;
    private int m_datalen;

    public NetBIOSPacket() {
        this.m_nbbuf = new byte[1024];
        this.m_datalen = 12;
    }

    public NetBIOSPacket(byte[] buf) {
        this.m_nbbuf = buf;
        this.m_datalen = 12;
    }

    public NetBIOSPacket(int siz) {
        this.m_nbbuf = new byte[siz];
        this.m_datalen = 12;
    }

    public void DumpPacket(boolean sessPkt) {
        logger.debug((Object)"NetBIOS Packet Dump :-");
        if (sessPkt) {
            switch (this.getPacketType()) {
                case 129: {
                    StringBuffer name = new StringBuffer();
                    for (int i = 0; i < 32; ++i) {
                        name.append((char)this.m_nbbuf[39 + i]);
                    }
                    logger.debug((Object)("Session request from " + NetBIOSSession.DecodeName(name.toString())));
                    break;
                }
            }
        } else {
            logger.debug((Object)(" Transaction Id : " + this.getTransactionId()));
            String opCode = null;
            switch (this.getOpcode()) {
                case 0: {
                    opCode = "QUERY";
                    break;
                }
                case 16: {
                    opCode = "QUERY (Response)";
                    break;
                }
                case 5: {
                    opCode = "NAME REGISTER";
                    break;
                }
                case 21: {
                    opCode = "NAME REGISTER (Response)";
                    break;
                }
                case 6: {
                    opCode = "NAME RELEASE";
                    break;
                }
                case 22: {
                    opCode = "NAME RELEASE (Response)";
                    break;
                }
                case 7: {
                    opCode = "WACK";
                    break;
                }
                case 8: {
                    opCode = "REFRESH";
                    break;
                }
                default: {
                    opCode = Integer.toHexString(this.getOpcode());
                }
            }
            logger.debug((Object)(" Opcode : " + opCode));
            logger.debug((Object)(" Flags  : " + Integer.toHexString(this.getFlags())));
            logger.debug((Object)(" QDCount : " + this.getQuestionCount()));
            logger.debug((Object)(" ANCount : " + this.getAnswerCount()));
            logger.debug((Object)(" NSCount : " + this.getNameServiceCount()));
            logger.debug((Object)(" ARCount : " + this.getAdditionalCount()));
            if (this.getQuestionCount() > 0) {
                StringBuffer encName = new StringBuffer();
                for (int i = 1; i <= 32; ++i) {
                    encName.append((char)this.m_nbbuf[12 + i]);
                }
                String name = NetBIOSSession.DecodeName(encName.toString());
                logger.debug((Object)(" QName : " + name + " <" + NetBIOSName.TypeAsString(name.charAt(15)) + ">"));
            }
        }
        logger.debug((Object)"********** Raw NetBIOS Data Dump **********");
        HexDump.Dump(this.getBuffer(), this.getLength(), 0);
    }

    public final int getAdditionalCount() {
        return DataPacker.getShort(this.m_nbbuf, 10);
    }

    public final String getAnswerName() {
        return NetBIOSSession.DecodeName(this.m_nbbuf, 13);
    }

    public final int getAnswerCount() {
        return DataPacker.getShort(this.m_nbbuf, 6);
    }

    public final NetBIOSNameList getAnswerNameList() {
        int cnt = this.getAnswerCount();
        if (cnt == 0) {
            return null;
        }
        NetBIOSNameList nameList = new NetBIOSNameList();
        int pos = 12;
        while (cnt-- > 0) {
            int nameLen = NetBIOSName.decodeNetBIOSNameLength(this.m_nbbuf, pos);
            NetBIOSName name = NetBIOSName.decodeNetBIOSName(this.m_nbbuf, pos);
            pos += nameLen;
            pos += 2;
            for (int dataCnt = DataPacker.getShort(this.m_nbbuf, pos += 8); dataCnt > 0; dataCnt -= 6) {
                int flags = DataPacker.getShort(this.m_nbbuf, pos);
                pos += 2;
                if ((flags & 0x80) != 0) {
                    name.setGroup(true);
                }
                byte[] ipaddr = new byte[4];
                for (int i = 0; i < 4; ++i) {
                    ipaddr[i] = this.m_nbbuf[pos++];
                }
                name.addIPAddress(ipaddr);
            }
            nameList.addName(name);
        }
        return nameList;
    }

    public final NetBIOSNameList getAdapterStatusNameList() {
        int cnt = this.getAnswerCount();
        if (cnt == 0) {
            return null;
        }
        NetBIOSNameList nameList = new NetBIOSNameList();
        int pos = 12;
        int nameLen = this.m_nbbuf[pos++] & 0xFF;
        pos += nameLen;
        pos = DataPacker.wordAlign(pos);
        int dataCnt = DataPacker.getShort(this.m_nbbuf, pos += 8);
        pos += 2;
        for (int nameCnt = this.m_nbbuf[pos++] & 0xFF; nameCnt > 0 && dataCnt > 0; dataCnt -= 18, --nameCnt) {
            NetBIOSName nbName = new NetBIOSName(this.m_nbbuf, pos);
            int typ = DataPacker.getShort(this.m_nbbuf, pos += 16);
            pos += 2;
            if ((typ & 0x80) != 0) {
                nbName.setGroup(true);
            }
            nameList.addName(nbName);
        }
        return nameList;
    }

    public final byte[] getBuffer() {
        return this.m_nbbuf;
    }

    public final int getFlags() {
        int flags = DataPacker.getShort(this.m_nbbuf, 4) & 0x7F0;
        return flags >>= 4;
    }

    public final int getHeaderFlags() {
        return this.m_nbbuf[1] & 0xFF;
    }

    public final int getHeaderLength() {
        return DataPacker.getIntelShort(this.m_nbbuf, 2) & 0xFFFF;
    }

    public final int getHeaderType() {
        return this.m_nbbuf[0] & 0xFF;
    }

    public final int getLength() {
        return this.m_datalen;
    }

    public final int getNameServiceCount() {
        return DataPacker.getShort(this.m_nbbuf, 8);
    }

    public final int getOpcode() {
        int op = DataPacker.getShort(this.m_nbbuf, 2) & 0xF800;
        return op >>= 11;
    }

    public final int getPacketType() {
        return this.m_nbbuf[0] & 0xFF;
    }

    public final int getQuestionCount() {
        return DataPacker.getShort(this.m_nbbuf, 4);
    }

    public final String getQuestionName() {
        return NetBIOSSession.DecodeName(this.m_nbbuf, 13);
    }

    public final int getQuestionNameLength() {
        return this.m_nbbuf[12] & 0xFF;
    }

    public final int getResultCode() {
        int res = DataPacker.getShort(this.m_nbbuf, 2) & 0xF;
        return res;
    }

    public final int getTransactionId() {
        return DataPacker.getShort(this.m_nbbuf, 0);
    }

    public final boolean isResponse() {
        return (this.getOpcode() & 0x10) != 0;
    }

    public final void setAdditionalCount(int cnt) {
        DataPacker.putShort((short)cnt, this.m_nbbuf, 10);
    }

    public final void setAnswerCount(int cnt) {
        DataPacker.putShort((short)cnt, this.m_nbbuf, 6);
    }

    public final int setAnswerName(String name, char ntyp, int qtyp, int qcls) {
        String encName = NetBIOSSession.ConvertName(name, ntyp);
        byte[] nameByts = encName.getBytes();
        int pos = 12;
        this.m_nbbuf[pos++] = 32;
        for (int i = 0; i < 32; ++i) {
            this.m_nbbuf[pos++] = nameByts[i];
        }
        this.m_nbbuf[pos++] = 0;
        DataPacker.putShort((short)qtyp, this.m_nbbuf, pos);
        DataPacker.putShort((short)qcls, this.m_nbbuf, pos += 2);
        if ((pos += 2) > this.m_datalen) {
            this.setLength(pos);
        }
        return pos;
    }

    public final void setFlags(int flg) {
        int val = DataPacker.getShort(this.m_nbbuf, 2) & 0xF80F;
        DataPacker.putShort((short)(val += flg << 4), this.m_nbbuf, 2);
    }

    public final void setHeaderFlags(int flg) {
        this.m_nbbuf[1] = (byte)(flg & 0xFF);
    }

    public final void setHeaderLength(int len) {
        DataPacker.putIntelShort(len, this.m_nbbuf, 2);
    }

    public final void setHeaderType(int typ) {
        this.m_nbbuf[0] = (byte)(typ & 0xFF);
    }

    public final int setIPAddress(int off, byte[] ipaddr) {
        for (int i = 0; i < 4; ++i) {
            this.m_nbbuf[off + i] = ipaddr[i];
        }
        int pos = off + 4;
        if (pos > this.m_datalen) {
            this.setLength(pos);
        }
        return pos;
    }

    public final void setLength(int len) {
        this.m_datalen = len;
    }

    public final int setNameRegistrationFlags(int off, int flg) {
        DataPacker.putShort(6, this.m_nbbuf, off);
        DataPacker.putShort((short)flg, this.m_nbbuf, off + 2);
        int pos = off + 4;
        if (pos > this.m_datalen) {
            this.setLength(pos);
        }
        return pos;
    }

    public final void setNameServiceCount(int cnt) {
        DataPacker.putShort((short)cnt, this.m_nbbuf, 8);
    }

    public final void setOpcode(int op) {
        int val = DataPacker.getShort(this.m_nbbuf, 2) & 0x7FF;
        DataPacker.putShort((short)(val += op << 11), this.m_nbbuf, 2);
    }

    public final void setQuestionCount(int cnt) {
        DataPacker.putShort((short)cnt, this.m_nbbuf, 4);
    }

    public final int setQuestionName(NetBIOSName name, int qtyp, int qcls) {
        byte[] nameByts = name.encodeName();
        int pos = 12;
        System.arraycopy(nameByts, 0, this.m_nbbuf, pos, nameByts.length);
        DataPacker.putShort((short)qtyp, this.m_nbbuf, pos += nameByts.length);
        DataPacker.putShort((short)qcls, this.m_nbbuf, pos += 2);
        if ((pos += 2) > this.m_datalen) {
            this.setLength(pos);
        }
        return pos;
    }

    public final int setQuestionName(String name, char ntyp, int qtyp, int qcls) {
        String encName = NetBIOSSession.ConvertName(name, ntyp);
        byte[] nameByts = encName.getBytes();
        int pos = 12;
        this.m_nbbuf[pos++] = 32;
        for (int i = 0; i < 32; ++i) {
            this.m_nbbuf[pos++] = nameByts[i];
        }
        this.m_nbbuf[pos++] = 0;
        DataPacker.putShort((short)qtyp, this.m_nbbuf, pos);
        DataPacker.putShort((short)qcls, this.m_nbbuf, pos += 2);
        if ((pos += 2) > this.m_datalen) {
            this.setLength(pos);
        }
        return pos;
    }

    public final int setResourceData(int off, int flg, byte[] data, int len) {
        DataPacker.putShort((short)flg, this.m_nbbuf, off);
        int pos = off + 2;
        for (int i = 0; i < len; ++i) {
            this.m_nbbuf[pos++] = data[i];
        }
        if (pos > this.m_datalen) {
            this.setLength(pos);
        }
        return pos;
    }

    public final int setResourceDataLength(int off, int len) {
        DataPacker.putShort((short)len, this.m_nbbuf, off);
        int pos = off + 2;
        if (pos > this.m_datalen) {
            this.setLength(pos);
        }
        return pos;
    }

    public final int setResourceRecord(int pktoff, int rroff, int qtyp, int qcls) {
        DataPacker.putShort((short)(49152 + rroff), this.m_nbbuf, pktoff);
        DataPacker.putShort((short)qtyp, this.m_nbbuf, pktoff + 2);
        DataPacker.putShort((short)qcls, this.m_nbbuf, pktoff + 4);
        int pos = pktoff + 6;
        if (pos > this.m_datalen) {
            this.setLength(pos);
        }
        return pos;
    }

    public final void setTransactionId(int id) {
        DataPacker.putShort((short)id, this.m_nbbuf, 0);
    }

    public final int setTTL(int off, int ttl) {
        DataPacker.putInt(ttl, this.m_nbbuf, off);
        int pos = off + 4;
        if (pos > this.m_datalen) {
            this.setLength(pos);
        }
        return pos;
    }

    public static final String getTypeAsString(int typ) {
        String typStr = "";
        switch (typ) {
            case 130: {
                typStr = "SessionAck";
                break;
            }
            case 133: {
                typStr = "SessionKeepAlive";
                break;
            }
            case 0: {
                typStr = "SessionMessage";
                break;
            }
            case 131: {
                typStr = "SessionReject";
                break;
            }
            case 129: {
                typStr = "SessionRequest";
                break;
            }
            case 132: {
                typStr = "SessionRetarget";
                break;
            }
            default: {
                typStr = "Unknown 0x" + Integer.toHexString(typ);
            }
        }
        return typStr;
    }

    public final int buildNameQueryResponse(NetBIOSName name) {
        this.setOpcode(16);
        this.setFlags(80);
        this.setQuestionCount(0);
        this.setAnswerCount(1);
        this.setAdditionalCount(0);
        this.setNameServiceCount(0);
        int pos = this.setAnswerName(name.getName(), name.getType(), 32, 1);
        pos = this.setTTL(pos, 10000);
        pos = this.setResourceDataLength(pos, name.numberOfAddresses() * 6);
        for (int i = 0; i < name.numberOfAddresses(); ++i) {
            byte[] ipaddr = name.getIPAddress(i);
            DataPacker.putShort(0, this.m_nbbuf, pos);
            pos += 2;
            for (int j = 0; j < 4; ++j) {
                this.m_nbbuf[pos++] = ipaddr[j];
            }
        }
        this.setLength(pos);
        return this.getLength();
    }

    public final int buildAddNameRequest(NetBIOSName name, int addrIdx, int tranId) {
        this.setTransactionId(tranId);
        this.setOpcode(5);
        this.setFlags(9);
        this.setQuestionCount(1);
        this.setAnswerCount(0);
        this.setNameServiceCount(0);
        this.setAdditionalCount(1);
        int pos = this.setQuestionName(name.getName(), name.getType(), 32, 1);
        pos = this.setResourceRecord(pos, 12, 32, 1);
        pos = name.getTimeToLive() == 0 ? this.setTTL(pos, 28800) : this.setTTL(pos, name.getTimeToLive());
        int flg = 0;
        if (name.isGroupName()) {
            flg = Short.MIN_VALUE;
        }
        pos = this.setNameRegistrationFlags(pos, flg);
        pos = this.setIPAddress(pos, name.getIPAddress(addrIdx));
        this.setLength(pos);
        return pos;
    }

    public final int buildRefreshNameRequest(NetBIOSName name, int addrIdx, int tranId) {
        this.setTransactionId(tranId);
        this.setOpcode(8);
        this.setFlags(9);
        this.setQuestionCount(1);
        this.setAnswerCount(0);
        this.setNameServiceCount(0);
        this.setAdditionalCount(1);
        int pos = this.setQuestionName(name.getName(), name.getType(), 32, 1);
        pos = this.setResourceRecord(pos, 12, 32, 1);
        pos = name.getTimeToLive() == 0 ? this.setTTL(pos, 28800) : this.setTTL(pos, name.getTimeToLive());
        int flg = 0;
        if (name.isGroupName()) {
            flg = Short.MIN_VALUE;
        }
        pos = this.setNameRegistrationFlags(pos, flg);
        pos = this.setIPAddress(pos, name.getIPAddress(addrIdx));
        this.setLength(pos);
        return pos;
    }

    public final int buildDeleteNameRequest(NetBIOSName name, int addrIdx, int tranId) {
        this.setTransactionId(tranId);
        this.setOpcode(6);
        this.setFlags(9);
        this.setQuestionCount(1);
        this.setAnswerCount(0);
        this.setNameServiceCount(0);
        this.setAdditionalCount(1);
        int pos = this.setQuestionName(name.getName(), name.getType(), 32, 1);
        pos = this.setResourceRecord(pos, 12, 32, 1);
        pos = this.setTTL(pos, 30000);
        int flg = 0;
        if (name.isGroupName()) {
            flg = Short.MIN_VALUE;
        }
        pos = this.setNameRegistrationFlags(pos, flg);
        pos = this.setIPAddress(pos, name.getIPAddress(addrIdx));
        this.setLength(pos);
        return pos;
    }

    public final int buildNameQueryRequest(NetBIOSName name, int tranId) {
        this.setTransactionId(tranId);
        this.setOpcode(0);
        this.setFlags(NetBIOSSession.hasWINSServer() ? 0 : 1);
        this.setQuestionCount(1);
        return this.setQuestionName(name, 32, 1);
    }

    public final int buildSessionSetupRequest(NetBIOSName fromName, NetBIOSName toName) {
        this.m_nbbuf[0] = -127;
        this.m_nbbuf[1] = 0;
        int pos = 4;
        byte[] encToName = toName.encodeName();
        System.arraycopy(encToName, 0, this.m_nbbuf, pos, encToName.length);
        byte[] encFromName = fromName.encodeName();
        System.arraycopy(encFromName, 0, this.m_nbbuf, pos += encToName.length, encFromName.length);
        this.setLength(pos += encFromName.length);
        DataPacker.putShort((short)(pos - 4), this.m_nbbuf, 2);
        return pos;
    }
}

