/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.netbios;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;
import org.alfresco.filesys.netbios.NameTemplateException;
import org.alfresco.filesys.netbios.NetBIOSName;
import org.alfresco.filesys.netbios.NetBIOSNameList;
import org.alfresco.filesys.netbios.NetBIOSPacket;
import org.alfresco.filesys.smb.NetworkSession;
import org.alfresco.filesys.util.DataPacker;
import org.alfresco.filesys.util.HexDump;
import org.alfresco.filesys.util.StringList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class NetBIOSSession
implements NetworkSession {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.smb.protocol.netbios");
    public static final int MaxCallerNameTemplateLength = 8;
    public static final char SessionIdChar = '#';
    public static final char JVMIdChar = '@';
    public static final String ValidTemplateChars = "@#_";
    private static final int FindNameBufferSize = 2048;
    private static int _defTimeout = 30000;
    private int m_remotePort;
    private Socket m_nbSocket;
    private DataInputStream m_nbIn;
    private DataOutputStream m_nbOut;
    private int m_tmo = _defTimeout;
    private char m_locNameType = (char)32;
    private char m_remNameType = (char)32;
    private static int m_sessIdx = 0;
    private static int m_jvmIdx = 0;
    private static String m_callerTemplate = "_##";
    private static String m_localNamePart;
    private static short m_tranIdx;
    private static DatagramSocket m_dgramSock;
    private static boolean m_debug;
    private static String m_subnetMask;
    private static InetAddress m_winsServer;
    public static final int DNSOnly = 1;
    public static final int WINSOnly = 2;
    public static final int WINSAndDNS = 3;
    private static int m_lookupType;
    private static int m_lookupTmo;
    private static boolean m_useWildcardFileServer;

    public NetBIOSSession() {
        this.m_remotePort = 139;
        this.m_nbSocket = null;
    }

    public NetBIOSSession(int tmo) {
        this.m_tmo = tmo;
        this.m_remotePort = 139;
        this.m_nbSocket = null;
    }

    public NetBIOSSession(int tmo, int port) {
        this.m_tmo = tmo;
        this.m_remotePort = port;
        this.m_nbSocket = null;
    }

    public final String getProtocolName() {
        return "TCP/IP NetBIOS";
    }

    public final boolean isConnected() {
        return this.m_nbSocket != null;
    }

    public final boolean hasData() throws IOException {
        if (this.m_nbSocket == null || this.m_nbIn == null) {
            return false;
        }
        return this.m_nbIn.available() > 0;
    }

    public static String ConvertName(String hostName) {
        return NetBIOSSession.ConvertName(hostName, ' ');
    }

    public static String ConvertName(String hostName, char nameType) {
        StringBuffer hName = new StringBuffer(hostName.toUpperCase());
        if (hName.length() > 15) {
            hName.setLength(15);
        }
        while (hName.length() < 15) {
            hName.append(' ');
        }
        hName.append(nameType);
        String convstr = new String("ABCDEFGHIJKLMNOP");
        StringBuffer nameBuf = new StringBuffer(32);
        int idx = 0;
        while (idx < hName.length()) {
            char ch;
            if ((ch = hName.charAt(idx++)) == ' ') {
                nameBuf.append("CA");
                continue;
            }
            nameBuf.append(convstr.charAt(ch / 16));
            nameBuf.append(convstr.charAt(ch % 16));
        }
        return nameBuf.toString();
    }

    public static String DecodeName(byte[] buf, int off) {
        String convstr = new String("ABCDEFGHIJKLMNOP");
        StringBuffer nameBuf = new StringBuffer(16);
        for (int idx = 0; idx < 32; idx += 2) {
            char ch1 = (char)buf[off + idx];
            char ch2 = (char)buf[off + idx + 1];
            if (ch1 == 'C' && ch2 == 'A') {
                nameBuf.append(' ');
                continue;
            }
            int val = convstr.indexOf(ch1) << 4;
            nameBuf.append((char)((val += convstr.indexOf(ch2)) & 0xFF));
        }
        return nameBuf.toString();
    }

    public static String DecodeName(String encnam) {
        if (encnam == null || encnam.length() != 32) {
            return "";
        }
        String convstr = new String("ABCDEFGHIJKLMNOP");
        StringBuffer nameBuf = new StringBuffer(16);
        for (int idx = 0; idx < 32; idx += 2) {
            char ch1 = encnam.charAt(idx);
            char ch2 = encnam.charAt(idx + 1);
            if (ch1 == 'C' && ch2 == 'A') {
                nameBuf.append(' ');
                continue;
            }
            int val = convstr.indexOf(ch1) << 4;
            nameBuf.append((char)((val += convstr.indexOf(ch2)) & 0xFF));
        }
        return nameBuf.toString();
    }

    public static int EncodeName(String hostName, char nameType, byte[] buf, int off) {
        StringBuffer hName = new StringBuffer(hostName.toUpperCase());
        if (hName.length() > 15) {
            hName.setLength(15);
        }
        while (hName.length() < 15) {
            hName.append(' ');
        }
        hName.append(nameType);
        String convstr = new String("ABCDEFGHIJKLMNOP");
        int idx = 0;
        int bufpos = off;
        buf[bufpos++] = 32;
        while (idx < hName.length()) {
            char ch;
            if ((ch = hName.charAt(idx++)) == ' ') {
                buf[bufpos++] = 67;
                buf[bufpos++] = 65;
                continue;
            }
            buf[bufpos++] = (byte)convstr.charAt(ch / 16);
            buf[bufpos++] = (byte)convstr.charAt(ch % 16);
        }
        buf[bufpos++] = 0;
        return bufpos;
    }

    public static NetBIOSName FindName(String nbName, char nbType, int tmo) throws IOException {
        return NetBIOSSession.FindName(new NetBIOSName(nbName, nbType, false), tmo);
    }

    public static NetBIOSName FindName(NetBIOSName nbName, int tmo) throws IOException {
        InetAddress locAddr = InetAddress.getLocalHost();
        if (m_dgramSock == null) {
            m_dgramSock = new DatagramSocket();
        }
        m_dgramSock.setSoTimeout(tmo);
        NetBIOSPacket nbpkt = new NetBIOSPacket();
        short s = m_tranIdx;
        m_tranIdx = (short)(s + 1);
        nbpkt.buildNameQueryRequest(nbName, s);
        String locIP = locAddr.getHostAddress();
        int dotIdx = locIP.indexOf(46);
        if (dotIdx == -1) {
            return null;
        }
        InetAddress destAddr = null;
        if (!NetBIOSSession.hasWINSServer()) {
            if (NetBIOSSession.getSubnetMask() == null) {
                NetBIOSSession.GenerateSubnetMask(null);
            }
            destAddr = InetAddress.getByName(NetBIOSSession.getSubnetMask());
        } else {
            destAddr = NetBIOSSession.getWINSServer();
        }
        DatagramPacket dgram = new DatagramPacket(nbpkt.getBuffer(), nbpkt.getLength(), destAddr, 137);
        byte[] rxbuf = new byte[2048];
        DatagramPacket rxdgram = new DatagramPacket(rxbuf, rxbuf.length);
        NetBIOSPacket rxpkt = new NetBIOSPacket(rxbuf);
        if (m_debug) {
            nbpkt.DumpPacket(false);
        }
        m_dgramSock.send(dgram);
        boolean rxOK = false;
        do {
            m_dgramSock.receive(rxdgram);
            if (logger.isDebugEnabled() && m_debug) {
                logger.debug((Object)"NetBIOS: Rx Datagram");
                rxpkt.DumpPacket(false);
            }
            if (!rxpkt.isResponse() || rxpkt.getOpcode() != 16) continue;
            rxOK = true;
        } while (!rxOK);
        NetBIOSNameList nameList = rxpkt.getAnswerNameList();
        if (nameList != null && nameList.numberOfNames() > 0) {
            return nameList.getName(0);
        }
        return null;
    }

    public static StringList FindNameList(String nbName, char nbType, int tmo) throws IOException {
        InetAddress locAddr = InetAddress.getLocalHost();
        if (m_dgramSock == null) {
            m_dgramSock = new DatagramSocket();
        }
        m_dgramSock.setSoTimeout(tmo);
        NetBIOSPacket nbpkt = new NetBIOSPacket();
        short s = m_tranIdx;
        m_tranIdx = (short)(s + 1);
        nbpkt.setTransactionId(s);
        nbpkt.setOpcode(0);
        nbpkt.setFlags(1);
        nbpkt.setQuestionCount(1);
        nbpkt.setQuestionName(nbName, nbType, 32, 1);
        String locIP = locAddr.getHostAddress();
        int dotIdx = locIP.indexOf(46);
        if (dotIdx == -1) {
            return null;
        }
        InetAddress destAddr = null;
        if (!NetBIOSSession.hasWINSServer()) {
            if (NetBIOSSession.getSubnetMask() == null) {
                NetBIOSSession.GenerateSubnetMask(null);
            }
            destAddr = InetAddress.getByName(NetBIOSSession.getSubnetMask());
        } else {
            destAddr = NetBIOSSession.getWINSServer();
        }
        DatagramPacket dgram = new DatagramPacket(nbpkt.getBuffer(), nbpkt.getLength(), destAddr, 137);
        byte[] rxbuf = new byte[2048];
        DatagramPacket rxdgram = new DatagramPacket(rxbuf, rxbuf.length);
        NetBIOSPacket rxpkt = new NetBIOSPacket(rxbuf);
        if (m_debug) {
            nbpkt.DumpPacket(false);
        }
        Vector<InetAddress> addrList = new Vector<InetAddress>();
        long endTime = System.currentTimeMillis() + (long)tmo;
        m_dgramSock.send(dgram);
        do {
            try {
                m_dgramSock.receive(rxdgram);
                if (logger.isDebugEnabled() && m_debug) {
                    logger.debug((Object)"NetBIOS: Rx Datagram");
                    rxpkt.DumpPacket(false);
                }
                if (!rxpkt.isResponse() || rxpkt.getOpcode() != 16) continue;
                addrList.add(rxdgram.getAddress());
            }
            catch (IOException ex) {
                if (!logger.isDebugEnabled() || !m_debug) continue;
                logger.debug((Object)ex.toString());
            }
        } while (System.currentTimeMillis() < endTime);
        if (addrList.size() == 0) {
            return null;
        }
        StringList nameList = new StringList();
        for (int i = 0; i < addrList.size(); ++i) {
            InetAddress addr = (InetAddress)addrList.elementAt(i);
            String name = NetBIOSSession.NetBIOSName(addr.getHostName());
            if (nameList.containsString(name)) continue;
            nameList.addString(name);
        }
        return nameList;
    }

    public static NetBIOSNameList FindNamesForAddress(String ipAddr) throws UnknownHostException, SocketException {
        if (m_dgramSock == null) {
            m_dgramSock = new DatagramSocket();
        }
        m_dgramSock.setSoTimeout(2000);
        NetBIOSPacket nbpkt = new NetBIOSPacket();
        short s = m_tranIdx;
        m_tranIdx = (short)(s + 1);
        nbpkt.setTransactionId(s);
        nbpkt.setOpcode(0);
        nbpkt.setFlags(1);
        nbpkt.setQuestionCount(1);
        nbpkt.setQuestionName("*\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000", '\u0000', 33, 1);
        InetAddress destAddr = InetAddress.getByName(ipAddr);
        DatagramPacket dgram = new DatagramPacket(nbpkt.getBuffer(), nbpkt.getLength(), destAddr, 137);
        byte[] rxbuf = new byte[2048];
        DatagramPacket rxdgram = new DatagramPacket(rxbuf, rxbuf.length);
        NetBIOSPacket rxpkt = new NetBIOSPacket(rxbuf);
        if (logger.isDebugEnabled() && m_debug) {
            nbpkt.DumpPacket(false);
        }
        NetBIOSNameList nameList = null;
        try {
            m_dgramSock.send(dgram);
            m_dgramSock.receive(rxdgram);
            if (logger.isDebugEnabled() && m_debug) {
                logger.debug((Object)"NetBIOS: Rx Datagram");
                rxpkt.DumpPacket(false);
            }
            if (rxpkt.isResponse() && rxpkt.getOpcode() == 16 && rxpkt.getAnswerCount() >= 1 && (nameList = rxpkt.getAdapterStatusNameList()) != null) {
                for (int i = 0; i < nameList.numberOfNames(); ++i) {
                    NetBIOSName nbName = nameList.getName(i);
                    nbName.addIPAddress(destAddr.getAddress());
                }
            }
        }
        catch (IOException ex) {
            if (logger.isDebugEnabled() && m_debug) {
                logger.debug((Object)ex.toString());
            }
            throw new UnknownHostException(ipAddr);
        }
        return nameList;
    }

    public static String GenerateSubnetMask(String addr) throws UnknownHostException {
        int dotPos;
        String localIP = addr;
        if (localIP == null) {
            localIP = InetAddress.getLocalHost().getHostAddress();
        }
        if ((dotPos = localIP.indexOf(46)) != -1) {
            String ipStr = localIP.substring(0, dotPos);
            int ipVal = Integer.valueOf(ipStr);
            if (ipVal <= 127) {
                m_subnetMask = "" + ipVal + ".255.255.255";
            } else if (ipVal <= 191) {
                ++dotPos;
                while (localIP.charAt(dotPos) != '.' && dotPos < localIP.length()) {
                    ++dotPos;
                }
                if (dotPos < localIP.length()) {
                    m_subnetMask = localIP.substring(0, dotPos) + ".255.255";
                }
            } else if (ipVal <= 223) {
                ++dotPos;
                int dotCnt = 1;
                while (dotCnt < 3 && dotPos < localIP.length()) {
                    if (localIP.charAt(dotPos++) != '.') continue;
                    ++dotCnt;
                }
                if (dotPos < localIP.length()) {
                    m_subnetMask = localIP.substring(0, dotPos - 1) + ".255";
                }
            }
        }
        if (m_subnetMask == null) {
            m_subnetMask = "255.255.255.255";
        }
        if (logger.isDebugEnabled() && m_debug) {
            logger.debug((Object)("NetBIOS: Set subnet mask to " + m_subnetMask));
        }
        return m_subnetMask;
    }

    public static int getLookupTimeout() {
        return m_lookupTmo;
    }

    public static int getLookupType() {
        return m_lookupType;
    }

    public static String getSubnetMask() {
        return m_subnetMask;
    }

    public static final boolean hasWINSServer() {
        return m_winsServer != null;
    }

    public static final InetAddress getWINSServer() {
        return m_winsServer;
    }

    public static boolean isDebug() {
        return m_debug;
    }

    private static final synchronized int getSessionId() {
        return m_sessIdx++;
    }

    public static final int getJVMIndex() {
        return m_jvmIdx;
    }

    public static String NetBIOSName(String hostName) {
        String nbName = new String(hostName.toUpperCase());
        int pos = nbName.indexOf(".");
        if (pos != -1) {
            nbName = nbName.substring(0, pos);
        }
        return nbName;
    }

    public static void setDebug(boolean dbg) {
        m_debug = dbg;
    }

    public static void setLookupTimeout(int tmo) {
        if (tmo >= 250) {
            m_lookupTmo = tmo;
        }
    }

    public static void setLookupType(int typ) {
        if (typ >= 1 && typ <= 3) {
            m_lookupType = typ;
        }
    }

    public static void setSubnetMask(String subnet) {
        m_subnetMask = subnet;
    }

    public static final void setWINSServer(InetAddress addr) {
        m_winsServer = addr;
    }

    private static Vector AdapterStatus(String nodeName) throws IOException {
        DatagramSocket nameSock = new DatagramSocket();
        nameSock.setSoTimeout(2000);
        NetBIOSPacket nbpkt = new NetBIOSPacket();
        nbpkt.setTransactionId(9999);
        nbpkt.setOpcode(0);
        nbpkt.setFlags(1);
        nbpkt.setQuestionCount(1);
        nbpkt.setQuestionName(nodeName, '\u0000', 33, 1);
        InetAddress destAddr = InetAddress.getByName(nodeName);
        DatagramPacket dgram = new DatagramPacket(nbpkt.getBuffer(), nbpkt.getLength(), destAddr, 137);
        byte[] rxbuf = new byte[512];
        DatagramPacket rxdgram = new DatagramPacket(rxbuf, rxbuf.length);
        NetBIOSPacket rxpkt = new NetBIOSPacket(rxbuf);
        if (logger.isDebugEnabled() && m_debug) {
            nbpkt.DumpPacket(false);
        }
        nameSock.send(dgram);
        boolean rxOK = false;
        do {
            nameSock.receive(rxdgram);
            if (logger.isDebugEnabled() && m_debug) {
                logger.debug((Object)"NetBIOS: Rx Datagram");
                rxpkt.DumpPacket(false);
            }
            if (!rxpkt.isResponse() || rxpkt.getOpcode() != 16) continue;
            rxOK = true;
        } while (!rxOK);
        return null;
    }

    public void Open(String remHost, String locName, String remAddr) throws IOException, UnknownHostException {
        if (logger.isDebugEnabled() && m_debug) {
            logger.debug((Object)("NetBIOS: Call " + remHost));
        }
        boolean dnsLookup = false;
        InetAddress addr = null;
        if (remAddr != null) {
            addr = InetAddress.getByName(remAddr);
        } else {
            if (NetBIOSSession.getLookupType() != 1) {
                try {
                    NetBIOSName netName = NetBIOSSession.FindName(remHost, ' ', 500);
                    if (netName != null && netName.numberOfAddresses() > 0) {
                        addr = InetAddress.getByName(netName.getIPAddressString(0));
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (addr == null && NetBIOSSession.getLookupType() != 2) {
                addr = InetAddress.getByName(remHost);
                dnsLookup = true;
            }
        }
        if (addr == null) {
            throw new UnknownHostException(remHost);
        }
        if (logger.isDebugEnabled() && m_debug) {
            logger.debug((Object)("NetBIOS: Remote node hase address " + addr.getHostAddress() + " (" + (dnsLookup ? "DNS" : "WINS") + ")"));
        }
        String remoteName = null;
        remoteName = this.getRemoteNameType() == ' ' && NetBIOSSession.useWildcardFileServerName() ? "*SMBSERVER" : remHost;
        int resp = this.openSession(remoteName, addr);
        if (resp == 130) {
            return;
        }
        if (resp == 131) {
            if (!remoteName.equals(remHost)) {
                resp = this.openSession(remHost, addr);
            }
            if (resp == 130) {
                return;
            }
            throw new IOException("NetBIOS session reject");
        }
        if (resp == 132) {
            throw new IOException("NetBIOS ReTarget");
        }
        this.Close();
        throw new IOException("Invalid NetBIOS response, 0x" + Integer.toHexString(resp));
    }

    private final int openSession(String remoteName, InetAddress addr) throws IOException {
        this.m_nbSocket = new Socket(addr, this.m_remotePort);
        this.m_nbSocket.setSoTimeout(this.m_tmo);
        this.m_nbSocket.setTcpNoDelay(true);
        this.m_nbIn = new DataInputStream(this.m_nbSocket.getInputStream());
        this.m_nbOut = new DataOutputStream(this.m_nbSocket.getOutputStream());
        byte[] inpkt = new byte[9];
        NetBIOSName fromName = this.createUniqueCallerName();
        NetBIOSName toName = new NetBIOSName(remoteName, this.getRemoteNameType(), false);
        if (logger.isDebugEnabled() && m_debug) {
            logger.debug((Object)("NetBIOS: Call from " + fromName + " to " + toName));
        }
        NetBIOSPacket nbPkt = new NetBIOSPacket();
        nbPkt.buildSessionSetupRequest(fromName, toName);
        this.m_nbOut.write(nbPkt.getBuffer(), 0, nbPkt.getLength());
        int resp = -1;
        if (this.m_nbIn.read(inpkt, 0, 9) >= 4) {
            resp = inpkt[0] & 0xFF;
            if (logger.isDebugEnabled() && m_debug) {
                logger.debug((Object)("NetBIOS: Rx " + NetBIOSPacket.getTypeAsString(resp)));
            }
        }
        if (resp != 130) {
            this.m_nbIn.close();
            this.m_nbIn = null;
            this.m_nbOut.close();
            this.m_nbOut = null;
            this.m_nbSocket.close();
            this.m_nbSocket = null;
        }
        return resp;
    }

    public char getLocalNameType() {
        return this.m_locNameType;
    }

    public char getRemoteNameType() {
        return this.m_remNameType;
    }

    public int getTimeout() {
        return this.m_tmo;
    }

    public void Close() throws IOException {
        if (logger.isDebugEnabled() && m_debug) {
            logger.debug((Object)"NetBIOS: HangUp");
        }
        if (this.m_nbSocket != null) {
            this.m_nbSocket.close();
            this.m_nbSocket = null;
        }
    }

    public int Receive(byte[] buf, int tmo) throws IOException {
        int rdlen;
        int pkttyp;
        if (tmo != this.m_tmo) {
            this.m_nbSocket.setSoTimeout(tmo);
            this.m_tmo = tmo;
        }
        do {
            rdlen = this.m_nbIn.read(buf, 0, 4);
            if (logger.isDebugEnabled() && m_debug) {
                logger.debug((Object)("NetBIOS: Read " + rdlen + " bytes"));
            }
            if (rdlen >= 4) continue;
            throw new IOException("NetBIOS Short Read");
        } while ((pkttyp = buf[0] & 0xFF) == 133);
        if (logger.isDebugEnabled() && m_debug) {
            logger.debug((Object)("NetBIOS: Rx Pkt Type = " + pkttyp + ", " + Integer.toHexString(pkttyp)));
        }
        if (pkttyp != 0) {
            throw new IOException("NetBIOS Unknown Packet Type, " + pkttyp);
        }
        int pktlen = DataPacker.getShort(buf, 2);
        if (logger.isDebugEnabled() && m_debug) {
            logger.debug((Object)("NetBIOS: Rx Data Len = " + pktlen));
        }
        if (buf.length < pktlen + 4) {
            logger.debug((Object)("NetBIOS: Rx Pkt Type = " + pkttyp + ", " + Integer.toHexString(pkttyp)));
            logger.debug((Object)("NetBIOS: Rx Buf Too Small pkt=" + pktlen + " buflen=" + buf.length));
            HexDump.Dump(buf, 16, 0);
            throw new IOException("NetBIOS Recv Buffer Too Small (pkt=" + pktlen + "/buf=" + buf.length + ")");
        }
        int totlen = 0;
        int offset = 4;
        while (pktlen > 0) {
            rdlen = this.m_nbIn.read(buf, offset, pktlen);
            totlen += rdlen;
            pktlen -= rdlen;
            offset += rdlen;
        }
        return totlen;
    }

    public boolean Send(byte[] data, int siz) throws IOException {
        if (this.m_nbSocket == null) {
            return false;
        }
        if (logger.isDebugEnabled() && m_debug) {
            logger.debug((Object)("NetBIOS: Tx " + siz + " bytes"));
        }
        data[0] = 0;
        data[1] = 0;
        DataPacker.putShort((short)siz, data, 2);
        int bufSiz = siz + 4;
        this.m_nbOut.write(data, 0, bufSiz);
        return true;
    }

    public void setLocalNameType(char nameType) {
        this.m_locNameType = nameType;
    }

    public void setRemoteNameType(char nameType) {
        this.m_remNameType = nameType;
    }

    public void setTimeout(int tmo) {
        this.m_tmo = tmo;
    }

    public static final void setCallerNameTemplate(String template) throws NameTemplateException {
        if (template == null || template.length() == 0 || template.length() > 8) {
            throw new NameTemplateException("Invalid template string, " + template);
        }
        if (template.indexOf(35) == -1) {
            throw new NameTemplateException("No session id character in template");
        }
        for (int i = 0; i < template.length(); ++i) {
            if (ValidTemplateChars.indexOf(template.charAt(i)) != -1) continue;
            throw new NameTemplateException("Invalid character in template, '" + template.charAt(i) + "'");
        }
        m_callerTemplate = template;
        m_localNamePart = null;
    }

    public static final void setJVMIndex(int jvmIdx) {
        if (jvmIdx >= 0) {
            m_jvmIdx = jvmIdx;
        }
    }

    private final NetBIOSName createUniqueCallerName() {
        if (m_localNamePart == null) {
            String localName = null;
            try {
                localName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception ex) {
                // empty catch block
            }
            int pos = localName.indexOf(".");
            if (pos != -1) {
                localName = localName.substring(0, pos);
            }
            int nameLen = 16 - m_callerTemplate.length();
            if (localName.length() > nameLen) {
                localName = localName.substring(0, nameLen - 1);
            }
            m_localNamePart = localName.toUpperCase();
        }
        int sessId = NetBIOSSession.getSessionId();
        int jvmId = NetBIOSSession.getJVMIndex();
        StringBuffer nameBuf = new StringBuffer(16);
        nameBuf.append(m_localNamePart);
        int idx = 0;
        int len = -1;
        block6: while (idx < m_callerTemplate.length()) {
            char ch = m_callerTemplate.charAt(idx++);
            switch (ch) {
                case '#': {
                    len = this.findRepeatLength(m_callerTemplate, idx, '#');
                    this.appendZeroPaddedHexValue(sessId, len, nameBuf);
                    idx += len - 1;
                    continue block6;
                }
                case '@': {
                    len = this.findRepeatLength(m_callerTemplate, idx, '@');
                    this.appendZeroPaddedHexValue(jvmId, len, nameBuf);
                    idx += len - 1;
                    continue block6;
                }
            }
            nameBuf.append(ch);
        }
        return new NetBIOSName(nameBuf.toString(), this.getLocalNameType(), false);
    }

    private final int findRepeatLength(String str, int pos, char ch) {
        int len = 1;
        while (pos < str.length() && str.charAt(pos++) == ch) {
            ++len;
        }
        return len;
    }

    private final void appendZeroPaddedHexValue(int val, int len, StringBuffer str) {
        String hex = Integer.toHexString(val);
        for (int i = 0; i < len - hex.length(); ++i) {
            str.append("0");
        }
        str.append(hex);
    }

    public static final int getDefaultTimeout() {
        return _defTimeout;
    }

    public static final void setDefaultTimeout(int tmo) {
        _defTimeout = tmo;
    }

    public static final boolean useWildcardFileServerName() {
        return m_useWildcardFileServer;
    }

    public static final void setWildcardFileServerName(boolean useWildcard) {
        m_useWildcardFileServer = useWildcard;
    }

    protected void finalize() {
        if (this.m_nbSocket != null) {
            try {
                this.m_nbSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_nbSocket = null;
        }
    }

    static {
        m_tranIdx = 1;
        m_dgramSock = null;
        m_debug = false;
        m_subnetMask = null;
        m_lookupType = 3;
        m_lookupTmo = 500;
        m_useWildcardFileServer = true;
    }
}

