/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.netbios.server;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.alfresco.filesys.netbios.NetBIOSName;
import org.alfresco.filesys.netbios.NetBIOSPacket;
import org.alfresco.filesys.netbios.NetworkSettings;
import org.alfresco.filesys.netbios.server.AddNameListener;
import org.alfresco.filesys.netbios.server.NetBIOSNameEvent;
import org.alfresco.filesys.netbios.server.NetBIOSRequest;
import org.alfresco.filesys.netbios.server.QueryNameListener;
import org.alfresco.filesys.netbios.server.RemoteNameListener;
import org.alfresco.filesys.server.NetworkServer;
import org.alfresco.filesys.server.config.ServerConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetBIOSNameServer
extends NetworkServer
implements Runnable {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.smb.protocol.netbios");
    private static final String ServerVersion = "3.5.0";
    public static final int AddNameSize = 256;
    public static final int DeleteNameSize = 256;
    public static final int RefreshNameSize = 256;
    private static final int AddNameInterval = 2000;
    private static final int AddNameRetries = 5;
    private static final int AddNameWINSInterval = 250;
    private static final int DeleteNameInterval = 200;
    private static final int DeleteNameRetries = 1;
    public static final int RefreshNameRetries = 2;
    public static final int GroupName = 32768;
    public static final int DefaultTTL = 10800;
    public static final long NameRefreshWakeupInterval = 180000L;
    private static int m_tranId;
    private DatagramSocket m_socket;
    private boolean m_shutdown;
    private InetAddress m_bindAddress;
    private InetAddress m_bcastAddr;
    private int m_port = 137;
    private InetAddress m_winsPrimary;
    private InetAddress m_winsSecondary;
    private Vector<AddNameListener> m_addListeners;
    private Vector<QueryNameListener> m_queryListeners;
    private Vector<RemoteNameListener> m_remoteListeners;
    private Vector<NetBIOSName> m_localNames;
    private Hashtable<NetBIOSName, byte[]> m_remoteNames;
    private Vector<NetBIOSRequest> m_reqList;
    private NetBIOSRequestHandler m_reqHandler;
    private NetBIOSNameRefresh m_refreshThread;
    private Thread m_srvThread;

    public NetBIOSNameServer(ServerConfiguration config) throws SocketException {
        super("NetBIOS", config);
        this.commonConstructor();
    }

    private final void commonConstructor() throws SocketException {
        this.setVersion(ServerVersion);
        this.m_localNames = new Vector();
        this.m_remoteNames = new Hashtable();
        if (this.getConfiguration().hasNetBIOSDebug()) {
            this.setDebug(true);
        }
        this.setBindAddress(this.getConfiguration().getNetBIOSBindAddress());
        this.setServerPort(137);
        this.setPrimaryWINSServer(this.getConfiguration().getPrimaryWINSServer());
        this.setSecondaryWINSServer(this.getConfiguration().getSecondaryWINSServer());
        if (!this.hasPrimaryWINSServer()) {
            try {
                this.m_bcastAddr = InetAddress.getByName(this.getConfiguration().getBroadcastMask());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final InetAddress getBindAddress() {
        return this.m_bindAddress;
    }

    protected final synchronized int getNextTransactionId() {
        return m_tranId++;
    }

    public final int getPort() {
        return this.m_port;
    }

    public final boolean hasBindAddress() {
        return this.m_bindAddress != null;
    }

    public final Hashtable<NetBIOSName, byte[]> getNameTable() {
        return this.m_remoteNames;
    }

    public final InetAddress getBroadcastAddress() {
        return this.m_bcastAddr;
    }

    public final boolean hasPrimaryWINSServer() {
        return this.m_winsPrimary != null;
    }

    public final InetAddress getPrimaryWINSServer() {
        return this.m_winsPrimary;
    }

    public final boolean hasSecondaryWINSServer() {
        return this.m_winsSecondary != null;
    }

    public final InetAddress getSecondaryWINSServer() {
        return this.m_winsSecondary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void AddName(NetBIOSName name) throws IOException {
        if (this.m_socket == null) {
            throw new IOException("NetBIOS name socket not initialized");
        }
        NetBIOSRequest nbReq = new NetBIOSRequest(0, name, this.getNextTransactionId());
        if (this.hasPrimaryWINSServer()) {
            nbReq.setRetryInterval(250L);
        } else {
            nbReq.setRetryInterval(2000L);
        }
        this.m_localNames.addElement(name);
        Vector<NetBIOSRequest> vector = this.m_reqList;
        synchronized (vector) {
            this.m_reqList.addElement(nbReq);
            this.m_reqList.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void DeleteName(NetBIOSName name) throws IOException {
        if (this.m_socket == null) {
            throw new IOException("NetBIOS name socket not initialized");
        }
        NetBIOSRequest nbReq = new NetBIOSRequest(1, name, this.getNextTransactionId(), 1);
        nbReq.setRetryInterval(200L);
        Vector<NetBIOSRequest> vector = this.m_reqList;
        synchronized (vector) {
            this.m_reqList.addElement(nbReq);
            this.m_reqList.notify();
        }
    }

    public final synchronized void addAddNameListener(AddNameListener l) {
        if (this.m_addListeners == null) {
            this.m_addListeners = new Vector();
        }
        this.m_addListeners.addElement(l);
    }

    public final synchronized void addQueryListener(QueryNameListener l) {
        if (this.m_queryListeners == null) {
            this.m_queryListeners = new Vector();
        }
        this.m_queryListeners.addElement(l);
    }

    public final synchronized void addRemoteListener(RemoteNameListener l) {
        if (this.m_remoteListeners == null) {
            this.m_remoteListeners = new Vector();
        }
        this.m_remoteListeners.addElement(l);
    }

    protected final synchronized void fireAddNameEvent(NetBIOSName name, int sts) {
        if (this.m_addListeners == null || this.m_addListeners.size() == 0) {
            return;
        }
        NetBIOSNameEvent evt = new NetBIOSNameEvent(name, sts);
        for (int i = 0; i < this.m_addListeners.size(); ++i) {
            AddNameListener addListener = this.m_addListeners.get(i);
            addListener.netbiosNameAdded(evt);
        }
    }

    protected final synchronized void fireQueryNameEvent(NetBIOSName name, InetAddress addr) {
        if (this.m_queryListeners == null || this.m_queryListeners.size() == 0) {
            return;
        }
        NetBIOSNameEvent evt = new NetBIOSNameEvent(name, 4);
        for (int i = 0; i < this.m_queryListeners.size(); ++i) {
            QueryNameListener queryListener = this.m_queryListeners.get(i);
            queryListener.netbiosNameQuery(evt, addr);
        }
    }

    protected final synchronized void fireNameRegisterEvent(NetBIOSName name, InetAddress addr) {
        if (this.m_remoteListeners == null || this.m_remoteListeners.size() == 0) {
            return;
        }
        NetBIOSNameEvent evt = new NetBIOSNameEvent(name, 5);
        for (int i = 0; i < this.m_remoteListeners.size(); ++i) {
            RemoteNameListener nameListener = this.m_remoteListeners.get(i);
            nameListener.netbiosAddRemoteName(evt, addr);
        }
    }

    protected final synchronized void fireNameReleaseEvent(NetBIOSName name, InetAddress addr) {
        if (this.m_remoteListeners == null || this.m_remoteListeners.size() == 0) {
            return;
        }
        NetBIOSNameEvent evt = new NetBIOSNameEvent(name, 5);
        for (int i = 0; i < this.m_remoteListeners.size(); ++i) {
            RemoteNameListener nameListener = this.m_remoteListeners.get(i);
            nameListener.netbiosReleaseRemoteName(evt, addr);
        }
    }

    private void openSocket() throws SocketException {
        this.m_socket = this.hasBindAddress() ? new DatagramSocket(this.getPort(), this.m_bindAddress) : new DatagramSocket(this.getPort());
    }

    protected final void processNameQuery(NetBIOSPacket pkt, InetAddress fromAddr, int fromPort) {
        int len;
        if (pkt.getQuestionCount() != 1) {
            return;
        }
        String searchName = pkt.getQuestionName();
        char nameType = searchName.charAt(15);
        for (len = 0; len <= 14 && searchName.charAt(len) != ' '; ++len) {
        }
        searchName = searchName.substring(0, len);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("%% Query name=" + searchName + ", type=" + NetBIOSName.TypeAsString(nameType) + ", len=" + len));
        }
        Enumeration<NetBIOSName> enm = this.m_localNames.elements();
        NetBIOSName nbName = null;
        boolean foundName = false;
        while (enm.hasMoreElements() && !foundName) {
            nbName = enm.nextElement();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("NetBIOS Name - " + nbName.getName() + ", len=" + nbName.getName().length() + ",type=" + NetBIOSName.TypeAsString(nbName.getType())));
            }
            if (nbName.getType() != nameType || nbName.getName().compareTo(searchName) != 0) continue;
            foundName = true;
        }
        if (foundName) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("%% Found name " + searchName + " in local name table : " + nbName.toString()));
            }
            int pktLen = pkt.buildNameQueryResponse(nbName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("%% NetBIOS Reply to " + fromAddr.getHostAddress() + " :-"));
                pkt.DumpPacket(false);
            }
            try {
                this.sendPacket(pkt, pktLen, fromAddr, fromPort);
            }
            catch (IOException ex) {
                logger.error((Object)"Name query response error", (Throwable)ex);
            }
            this.fireQueryNameEvent(nbName, fromAddr);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("%% Failed to find match for name " + searchName));
        }
    }

    protected final void processNameRegister(NetBIOSPacket pkt, InetAddress fromAddr, int fromPort) {
        int len;
        if (pkt.getQuestionCount() != 1) {
            return;
        }
        String regName = pkt.getQuestionName();
        char nameType = regName.charAt(15);
        for (len = 0; len <= 14 && regName.charAt(len) != ' '; ++len) {
        }
        regName = regName.substring(0, len);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("%% Register name=" + regName + ", type=" + NetBIOSName.TypeAsString(nameType) + ", len=" + len));
        }
        byte[] hostIP = fromAddr.getAddress();
        NetBIOSName nbName = new NetBIOSName(regName, nameType, false, hostIP);
        this.m_remoteNames.put(nbName, hostIP);
        this.fireNameRegisterEvent(nbName, fromAddr);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("%% Added remote name " + nbName.toString() + " to remote names table"));
        }
    }

    protected final void processNameRelease(NetBIOSPacket pkt, InetAddress fromAddr, int fromPort) {
        int len;
        if (pkt.getQuestionCount() != 1) {
            return;
        }
        String regName = pkt.getQuestionName();
        char nameType = regName.charAt(15);
        for (len = 0; len <= 14 && regName.charAt(len) != ' '; ++len) {
        }
        regName = regName.substring(0, len);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("%% Release name=" + regName + ", type=" + NetBIOSName.TypeAsString(nameType) + ", len=" + len));
        }
        byte[] hostIP = fromAddr.getAddress();
        NetBIOSName nbName = new NetBIOSName(regName, nameType, false, hostIP);
        this.m_remoteNames.remove(nbName);
        this.fireNameReleaseEvent(nbName, fromAddr);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("%% Released remote name " + nbName.toString() + " from remote names table"));
        }
    }

    protected final void processQueryResponse(NetBIOSPacket pkt, InetAddress fromAddr, int fromPort) {
    }

    protected final void processRegisterResponse(NetBIOSPacket pkt, InetAddress fromAddr, int fromPort) {
        if (pkt.getAnswerCount() == 0) {
            return;
        }
        int tranId = pkt.getTransactionId();
        NetBIOSRequest req = this.findRequest(tranId);
        if (req == null) {
            return;
        }
        int errCode = pkt.getResultCode();
        if (errCode != 0) {
            int len;
            req.setErrorStatus(true);
            String regName = pkt.getAnswerName();
            char nameType = regName.charAt(15);
            for (len = 0; len <= 14 && regName.charAt(len) != ' '; ++len) {
            }
            regName = regName.substring(0, len);
            byte[] hostIP = fromAddr.getAddress();
            NetBIOSName nbName = new NetBIOSName(regName, nameType, false, hostIP);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("%% Negative Name Registration name=" + nbName));
            }
            this.fireAddNameEvent(req.getNetBIOSName(), 1);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("%% Name Registration Successful name=" + req.getNetBIOSName().getName()));
            }
            this.fireAddNameEvent(req.getNetBIOSName(), 0);
        }
    }

    protected final void processReleaseResponse(NetBIOSPacket pkt, InetAddress fromAddr, int fromPort) {
    }

    protected final void processWack(NetBIOSPacket pkt, InetAddress fromAddr, int fromPort) {
    }

    public final synchronized void removeAddNameListener(AddNameListener l) {
        if (this.m_addListeners == null) {
            return;
        }
        this.m_addListeners.removeElement(l);
    }

    public final synchronized void removeQueryNameListener(QueryNameListener l) {
        if (this.m_queryListeners == null) {
            return;
        }
        this.m_queryListeners.removeElement(l);
    }

    public final synchronized void removeRemoteListener(RemoteNameListener l) {
        if (this.m_remoteListeners == null) {
            return;
        }
        this.m_remoteListeners.removeElement(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        NetBIOSPacket nbPkt = null;
        DatagramPacket pkt = null;
        byte[] buf = null;
        try {
            Vector<byte[]> ipList = new Vector<byte[]>();
            if (this.hasBindAddress()) {
                ipList.add(this.getBindAddress().getAddress());
            } else {
                int i;
                InetAddress[] addrs = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
                for (i = 0; i < addrs.length; ++i) {
                    if (addrs[i].getHostAddress().equals("127.0.0.1") || addrs[i].getHostAddress().equals("0.0.0.0")) continue;
                    ipList.add(addrs[i].getAddress());
                }
                if (ipList.size() == 0) {
                    logger.error((Object)"Failed to get IP address(es) for NetBIOS name");
                    for (i = 0; i < addrs.length; ++i) {
                        logger.error((Object)("  Address: " + addrs[i]));
                    }
                    logger.error((Object)"Check hosts file and/or DNS setup");
                    logger.error((Object)"NetBIOS name server is shutting down");
                    return;
                }
            }
            if (this.m_socket == null) {
                this.openSocket();
            }
            this.m_reqList = new Vector();
            this.AddName(new NetBIOSName(this.getConfiguration().getServerName(), ' ', false, ipList, 10800));
            this.AddName(new NetBIOSName(this.getConfiguration().getServerName(), '\u0000', false, ipList, 10800));
            if (this.getConfiguration().getDomainName() != null) {
                this.AddName(new NetBIOSName(this.getConfiguration().getDomainName(), '\u0000', true, ipList, 10800));
            }
            this.m_reqHandler = new NetBIOSRequestHandler();
            this.m_reqHandler.start();
            this.m_refreshThread = new NetBIOSNameRefresh();
            this.m_refreshThread.start();
            buf = new byte[1024];
            nbPkt = new NetBIOSPacket(buf);
            pkt = new DatagramPacket(buf, buf.length);
        }
        catch (Exception ex) {
            logger.error((Object)"NetBIOSNameServer setup error:", (Throwable)ex);
            this.setException(ex);
            this.fireServerEvent(3);
        }
        if (this.m_reqList != null && this.m_reqList.size() > 0) {
            Vector<NetBIOSRequest> ex = this.m_reqList;
            synchronized (ex) {
                this.m_reqList.notify();
            }
        }
        this.setActive(true);
        this.fireServerEvent(1);
        if (!this.hasException()) {
            this.m_shutdown = false;
            block20: while (!this.m_shutdown) {
                try {
                    this.m_socket.receive(pkt);
                    if (pkt.getLength() == 0) continue;
                    InetAddress fromAddr = pkt.getAddress();
                    int fromPort = pkt.getPort();
                    switch (nbPkt.getOpcode()) {
                        case 0: {
                            this.processNameQuery(nbPkt, fromAddr, fromPort);
                            continue block20;
                        }
                        case 5: {
                            this.processNameRegister(nbPkt, fromAddr, fromPort);
                            continue block20;
                        }
                        case 6: {
                            this.processNameRelease(nbPkt, fromAddr, fromPort);
                            continue block20;
                        }
                        case 21: {
                            this.processRegisterResponse(nbPkt, fromAddr, fromPort);
                            continue block20;
                        }
                        case 16: {
                            this.processQueryResponse(nbPkt, fromAddr, fromPort);
                            continue block20;
                        }
                        case 22: {
                            this.processReleaseResponse(nbPkt, fromAddr, fromPort);
                            continue block20;
                        }
                        case 7: {
                            this.processWack(nbPkt, fromAddr, fromPort);
                            continue block20;
                        }
                        case 8: {
                            this.processNameRegister(nbPkt, fromAddr, fromPort);
                            continue block20;
                        }
                        case 15: {
                            this.processNameRegister(nbPkt, fromAddr, fromPort);
                            continue block20;
                        }
                    }
                    logger.error((Object)("Unknown OpCode 0x" + Integer.toHexString(nbPkt.getOpcode())));
                }
                catch (Exception ex) {
                    if (!this.m_shutdown) {
                        logger.error((Object)"NetBIOSNameServer error", (Throwable)ex);
                    }
                    if (this.m_shutdown) continue;
                    this.setException(ex);
                    this.fireServerEvent(3);
                }
            }
        }
        this.setActive(false);
        this.fireServerEvent(2);
    }

    protected final void sendPacket(NetBIOSPacket nbpkt, int len) throws IOException {
        DatagramPacket pkt = new DatagramPacket(nbpkt.getBuffer(), len, NetworkSettings.getBroadcastAddress(), this.getPort());
        this.m_socket.send(pkt);
    }

    protected final void sendPacket(NetBIOSPacket nbpkt, int len, InetAddress replyAddr, int replyPort) throws IOException {
        DatagramPacket pkt = new DatagramPacket(nbpkt.getBuffer(), len, replyAddr, replyPort);
        this.m_socket.send(pkt);
    }

    public final void setBindAddress(InetAddress addr) {
        this.m_bindAddress = addr;
    }

    public final void setServerPort(int port) {
        this.m_port = port;
    }

    public final void setPrimaryWINSServer(InetAddress addr) {
        this.m_winsPrimary = addr;
    }

    public final void setSecondaryWINSServer(InetAddress addr) {
        this.m_winsSecondary = addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final NetBIOSRequest findRequest(int id) {
        if (this.m_reqList == null) {
            return null;
        }
        NetBIOSRequest req = null;
        Vector<NetBIOSRequest> vector = this.m_reqList;
        synchronized (vector) {
            int idx = 0;
            while (req == null && idx < this.m_reqList.size()) {
                NetBIOSRequest curReq;
                if ((curReq = this.m_reqList.elementAt(idx++)).getTransactionId() != id) continue;
                req = curReq;
            }
        }
        return req;
    }

    @Override
    public void shutdownServer(boolean immediate) {
        block17: {
            try {
                if (this.m_refreshThread != null) {
                    this.m_refreshThread.shutdownRequest();
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Shutdown NetBIOS server error", (Throwable)ex);
            }
            if (this.isActive() && !immediate) {
                for (int i = 0; i < this.m_localNames.size(); ++i) {
                    NetBIOSName nbName = this.m_localNames.elementAt(i);
                    try {
                        this.DeleteName(nbName);
                        continue;
                    }
                    catch (IOException ex) {
                        logger.error((Object)"Shutdown NetBIOS server error", (Throwable)ex);
                    }
                }
                while (this.m_reqList.size() > 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {}
                }
            }
            try {
                if (this.m_reqHandler != null) {
                    this.m_reqHandler.shutdownRequest();
                    this.m_reqHandler.join(1000L);
                    this.m_reqHandler = null;
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Shutdown NetBIOS request handler error", (Throwable)ex);
            }
            this.m_shutdown = true;
            try {
                if (this.m_socket == null) break block17;
                try {
                    this.m_socket.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.m_socket = null;
            }
            catch (Exception ex) {
                logger.error((Object)"Shutdown NetBIOS server error", (Throwable)ex);
            }
        }
        this.fireServerEvent(2);
    }

    @Override
    public void startServer() {
        this.m_srvThread = new Thread(this);
        this.m_srvThread.setName("NetBIOS Name Server");
        this.m_srvThread.setDaemon(true);
        this.m_srvThread.start();
        this.fireServerEvent(0);
    }

    class NetBIOSNameRefresh
    extends Thread {
        private boolean m_hshutdown = false;

        public NetBIOSNameRefresh() {
            this.setDaemon(true);
            this.setName("NetBIOSRefresh");
        }

        public final void shutdownRequest() {
            this.m_hshutdown = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.m_hshutdown) {
                try {
                    NetBIOSNameRefresh.sleep(180000L);
                    if (!this.m_hshutdown) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"NetBIOS name refresh wakeup ...");
                        }
                        Vector vector = NetBIOSNameServer.this.m_localNames;
                        synchronized (vector) {
                            long expireTime = System.currentTimeMillis() + 180000L;
                            for (int i = 0; i < NetBIOSNameServer.this.m_localNames.size(); ++i) {
                                NetBIOSName nbName = (NetBIOSName)NetBIOSNameServer.this.m_localNames.get(i);
                                if (nbName.getExpiryTime() >= expireTime) continue;
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Queuing name refresh for " + nbName));
                                }
                                NetBIOSRequest nbReq = new NetBIOSRequest(2, nbName, NetBIOSNameServer.this.getNextTransactionId());
                                nbReq.setRetryCount(2);
                                Vector vector2 = NetBIOSNameServer.this.m_reqList;
                                synchronized (vector2) {
                                    NetBIOSNameServer.this.m_reqList.addElement(nbReq);
                                    NetBIOSNameServer.this.m_reqList.notify();
                                    continue;
                                }
                            }
                            continue;
                        }
                    }
                    break;
                }
                catch (Exception ex) {
                    if (this.m_hshutdown) continue;
                    logger.error((Object)"NetBIOS Name refresh thread exception", (Throwable)ex);
                }
            }
        }
    }

    class NetBIOSRequestHandler
    extends Thread {
        private boolean m_hshutdown = false;

        public NetBIOSRequestHandler() {
            this.setDaemon(true);
            this.setName("NetBIOSRequest");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void shutdownRequest() {
            this.m_hshutdown = true;
            Vector vector = NetBIOSNameServer.this.m_reqList;
            synchronized (vector) {
                NetBIOSNameServer.this.m_reqList.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.m_hshutdown) {
                try {
                    NetBIOSRequest req = null;
                    Vector vector = NetBIOSNameServer.this.m_reqList;
                    synchronized (vector) {
                        if (NetBIOSNameServer.this.m_reqList.size() == 0) {
                            if (logger.isDebugEnabled() && NetBIOSNameServer.this.hasDebug()) {
                                logger.debug((Object)"NetBIOS handler waiting for request ...");
                            }
                            NetBIOSNameServer.this.m_reqList.wait();
                        }
                        if (NetBIOSNameServer.this.m_reqList.size() > 0) {
                            req = (NetBIOSRequest)NetBIOSNameServer.this.m_reqList.get(0);
                        } else if (this.m_hshutdown) {
                            break;
                        }
                    }
                    int reqRetry = req.getRetryCount();
                    if (NetBIOSNameServer.this.hasPrimaryWINSServer()) {
                        reqRetry = 1;
                    }
                    boolean txsts = true;
                    int retry = 0;
                    while (!req.hasErrorStatus() && retry++ < reqRetry) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("NetBIOS handler, processing " + req));
                        }
                        switch (req.isType()) {
                            case 0: {
                                if (NetBIOSNameServer.this.hasPrimaryWINSServer()) {
                                    txsts = this.sendAddName(req, NetBIOSNameServer.this.getPrimaryWINSServer(), false);
                                    break;
                                }
                                txsts = this.sendAddName(req, NetBIOSNameServer.this.getBroadcastAddress(), true);
                                break;
                            }
                            case 1: {
                                if (NetBIOSNameServer.this.hasPrimaryWINSServer()) {
                                    txsts = this.sendDeleteName(req, NetBIOSNameServer.this.getPrimaryWINSServer(), false);
                                    break;
                                }
                                txsts = this.sendDeleteName(req, NetBIOSNameServer.this.getBroadcastAddress(), true);
                                break;
                            }
                            case 2: {
                                txsts = NetBIOSNameServer.this.hasPrimaryWINSServer() ? this.sendRefreshName(req, NetBIOSNameServer.this.getPrimaryWINSServer(), false) : this.sendRefreshName(req, NetBIOSNameServer.this.getBroadcastAddress(), true);
                            }
                        }
                        if (!txsts || req.getRetryInterval() <= 0L) continue;
                        NetBIOSRequestHandler.sleep(req.getRetryInterval());
                    }
                    if (!req.hasErrorStatus()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("NetBIOS handler successful, " + req));
                        }
                        NetBIOSName nbName = req.getNetBIOSName();
                        switch (req.isType()) {
                            case 0: {
                                if (!NetBIOSNameServer.this.m_localNames.contains(nbName)) {
                                    NetBIOSNameServer.this.m_localNames.addElement(nbName);
                                }
                                nbName.setExpiryTime(System.currentTimeMillis() + (long)nbName.getTimeToLive() * 1000L);
                                NetBIOSNameServer.this.fireAddNameEvent(nbName, 0);
                                break;
                            }
                            case 1: {
                                NetBIOSNameServer.this.m_localNames.remove(req.getNetBIOSName());
                                break;
                            }
                            case 2: {
                                nbName.setExpiryTime(System.currentTimeMillis() + (long)nbName.getTimeToLive() * 1000L);
                            }
                        }
                    } else {
                        switch (req.isType()) {
                            case 0: {
                                NetBIOSNameServer.this.m_localNames.remove(req.getNetBIOSName());
                            }
                        }
                    }
                    Vector vector2 = NetBIOSNameServer.this.m_reqList;
                    synchronized (vector2) {
                        NetBIOSNameServer.this.m_reqList.remove(0);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.m_hshutdown) continue;
                break;
            }
        }

        private final boolean sendAddName(NetBIOSRequest req, InetAddress dest, boolean bcast) {
            try {
                byte[] buf = new byte[256];
                NetBIOSPacket addPkt = new NetBIOSPacket(buf);
                for (int i = 0; i < req.getNetBIOSName().numberOfAddresses(); ++i) {
                    int len = addPkt.buildAddNameRequest(req.getNetBIOSName(), i, req.getTransactionId());
                    if (!bcast) {
                        addPkt.setFlags(0);
                    }
                    DatagramPacket pkt = new DatagramPacket(buf, len, dest, NetBIOSNameServer.this.getPort());
                    if (NetBIOSNameServer.this.m_socket != null) {
                        NetBIOSNameServer.this.m_socket.send(pkt);
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("  Add name " + (bcast ? "broadcast" : "WINS") + ", " + req));
                }
            }
            catch (IOException ex) {
                NetBIOSNameServer.this.fireAddNameEvent(req.getNetBIOSName(), 3);
                req.setErrorStatus(true);
                return false;
            }
            return true;
        }

        private final boolean sendRefreshName(NetBIOSRequest req, InetAddress dest, boolean bcast) {
            try {
                byte[] buf = new byte[256];
                NetBIOSPacket refreshPkt = new NetBIOSPacket(buf);
                for (int i = 0; i < req.getNetBIOSName().numberOfAddresses(); ++i) {
                    int len = refreshPkt.buildRefreshNameRequest(req.getNetBIOSName(), i, req.getTransactionId());
                    if (!bcast) {
                        refreshPkt.setFlags(0);
                    }
                    DatagramPacket pkt = new DatagramPacket(buf, len, dest, NetBIOSNameServer.this.getPort());
                    if (NetBIOSNameServer.this.m_socket != null) {
                        NetBIOSNameServer.this.m_socket.send(pkt);
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("  Refresh name " + (bcast ? "broadcast" : "WINS") + ", " + req));
                }
            }
            catch (IOException ex) {
                req.setErrorStatus(true);
                return false;
            }
            return true;
        }

        private final boolean sendDeleteName(NetBIOSRequest req, InetAddress dest, boolean bcast) {
            try {
                byte[] buf = new byte[256];
                NetBIOSPacket delPkt = new NetBIOSPacket(buf);
                for (int i = 0; i < req.getNetBIOSName().numberOfAddresses(); ++i) {
                    int len = delPkt.buildDeleteNameRequest(req.getNetBIOSName(), i, req.getTransactionId());
                    if (!bcast) {
                        delPkt.setFlags(0);
                    }
                    DatagramPacket pkt = new DatagramPacket(buf, len, dest, NetBIOSNameServer.this.getPort());
                    if (NetBIOSNameServer.this.m_socket != null) {
                        NetBIOSNameServer.this.m_socket.send(pkt);
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("  Delete name " + (bcast ? "broadcast" : "WINS") + ", " + req));
                }
            }
            catch (IOException ex) {
                req.setErrorStatus(true);
                return false;
            }
            return true;
        }
    }
}

