/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.netbios.win32;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.alfresco.filesys.netbios.NetBIOSName;
import org.alfresco.filesys.netbios.win32.WinsockNetBIOSException;
import org.alfresco.filesys.util.DataBuffer;
import org.alfresco.filesys.util.IPAddress;
import org.alfresco.filesys.util.X64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Win32NetBIOS {
    protected static final int FindNameBufferLen = 33;
    private static Throwable m_loadDLLException;

    public static final boolean isInitialized() {
        return m_loadDLLException == null;
    }

    public static final Throwable getInitializationException() {
        return m_loadDLLException;
    }

    public static final boolean isAvailable() {
        if (!Win32NetBIOS.isInitialized()) {
            return false;
        }
        int[] lanas = Win32NetBIOS.LanaEnum();
        return lanas != null && lanas.length > 0;
    }

    public static native int AddName(int var0, byte[] var1);

    public static native int AddGroupName(int var0, byte[] var1);

    public static native int FindNameRaw(int var0, byte[] var1, byte[] var2, int var3);

    public static int FindName(int lana, NetBIOSName nbName) {
        byte[] nameBuf = new byte[nbName.isGroupName() ? 65535 : 4096];
        int sts = Win32NetBIOS.FindNameRaw(lana, nbName.getNetBIOSName(), nameBuf, nameBuf.length);
        if (sts != 0) {
            return -sts;
        }
        DataBuffer buf = new DataBuffer(nameBuf, 0, nameBuf.length);
        int nodeCount = buf.getShort();
        buf.skipBytes(1);
        boolean isGroupName = buf.getByte() != 0;
        int curPos = buf.getPosition();
        for (int i = 0; i < nodeCount; ++i) {
            buf.skipBytes(9);
            if (buf.getByte() != 0 || buf.getByte() != 0) continue;
            byte[] ipAddr = new byte[]{(byte)buf.getByte(), (byte)buf.getByte(), (byte)buf.getByte(), (byte)buf.getByte()};
            nbName.addIPAddress(ipAddr);
            buf.setPosition(curPos += 33);
        }
        return nodeCount;
    }

    public static native int DeleteName(int var0, byte[] var1);

    public static int[] LanaEnumerate() {
        boolean adapterAvail = false;
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements() && !adapterAvail) {
                Enumeration<InetAddress> addrs;
                NetworkInterface ni = nis.nextElement();
                if (ni.getName().equals("lo") || !(addrs = ni.getInetAddresses()).hasMoreElements()) continue;
                adapterAvail = true;
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (!adapterAvail) {
            return null;
        }
        return Win32NetBIOS.LanaEnum();
    }

    private static native int[] LanaEnum();

    public static native int Reset(int var0);

    public static native int Listen(int var0, byte[] var1, byte[] var2, byte[] var3);

    public static native int Receive(int var0, int var1, byte[] var2, int var3, int var4);

    public static native int Send(int var0, int var1, byte[] var2, int var3, int var4);

    public static native int SendDatagram(int var0, int var1, byte[] var2, byte[] var3, int var4, int var5);

    public static native int SendBroadcastDatagram(int var0, byte[] var1, int var2, int var3);

    public static native int ReceiveDatagram(int var0, int var1, byte[] var2, int var3, int var4);

    public static native int ReceiveBroadcastDatagram(int var0, int var1, byte[] var2, int var3, int var4);

    public static native int Hangup(int var0, int var1);

    public static native String GetLocalNetBIOSName();

    public static native String GetLocalDomainName();

    public static native String getWINSServerList();

    public static final String getIPAddressForLANA(int lana) {
        String localName = Win32NetBIOS.GetLocalNetBIOSName();
        if (localName == null) {
            return null;
        }
        NetBIOSName nbName = new NetBIOSName(localName, '\u0000', false);
        int sts = Win32NetBIOS.FindName(lana, nbName);
        if (sts == -52) {
            Win32NetBIOS.Reset(lana);
            sts = Win32NetBIOS.FindName(lana, nbName);
        }
        String ipAddr = null;
        if (sts >= 0) {
            ipAddr = nbName.getIPAddressString(0);
        }
        return ipAddr;
    }

    public static final String getAdapterNameForLANA(int lana) {
        NetworkInterface ni;
        String ipAddr = Win32NetBIOS.getIPAddressForLANA(lana);
        if (ipAddr == null) {
            return null;
        }
        Hashtable<String, NetworkInterface> adapters = Win32NetBIOS.getNetworkAdapterList();
        String adapterName = null;
        if (adapters != null && (ni = adapters.get(ipAddr)) != null) {
            adapterName = ni.getDisplayName();
        }
        return adapterName;
    }

    public static final int getLANAForIPAddress(String addr) {
        if (!IPAddress.isNumericAddress(addr)) {
            return -1;
        }
        int[] lanas = Win32NetBIOS.LanaEnum();
        if (lanas == null || lanas.length == 0) {
            return -1;
        }
        for (int i = 0; i < lanas.length; ++i) {
            String curAddr = Win32NetBIOS.getIPAddressForLANA(lanas[i]);
            if (curAddr == null || !curAddr.equals(addr)) continue;
            return lanas[i];
        }
        return -1;
    }

    public static final int getLANAForAdapterName(String name) {
        Hashtable<String, NetworkInterface> niList = Win32NetBIOS.getNetworkAdapterList();
        Enumeration<String> niEnum = niList.keys();
        while (niEnum.hasMoreElements()) {
            String ipAddr = niEnum.nextElement();
            NetworkInterface ni = niList.get(ipAddr);
            if (!ni.getDisplayName().equalsIgnoreCase(name)) continue;
            return Win32NetBIOS.getLANAForIPAddress(ipAddr);
        }
        return -1;
    }

    private static final Hashtable<String, NetworkInterface> getNetworkAdapterList() {
        Hashtable<String, NetworkInterface> niList = new Hashtable<String, NetworkInterface>();
        try {
            Enumeration<NetworkInterface> niEnum = NetworkInterface.getNetworkInterfaces();
            while (niEnum.hasMoreElements()) {
                NetworkInterface ni = niEnum.nextElement();
                Enumeration<InetAddress> addrEnum = ni.getInetAddresses();
                while (addrEnum.hasMoreElements()) {
                    InetAddress addr = addrEnum.nextElement();
                    niList.put(addr.getHostAddress(), ni);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return niList;
    }

    protected static native void InitializeSockets() throws WinsockNetBIOSException;

    protected static native void ShutdownSockets();

    protected static native int CreateSocket(int var0) throws WinsockNetBIOSException;

    protected static native int CreateDatagramSocket(int var0) throws WinsockNetBIOSException;

    protected static native int BindSocket(int var0, byte[] var1) throws WinsockNetBIOSException;

    protected static native int ListenSocket(int var0, byte[] var1) throws WinsockNetBIOSException;

    protected static native void CloseSocket(int var0);

    protected static native int SendSocket(int var0, byte[] var1, int var2, int var3) throws WinsockNetBIOSException;

    protected static native int ReceiveSocket(int var0, byte[] var1, int var2, int var3) throws WinsockNetBIOSException;

    protected static native int SendSocketDatagram(int var0, byte[] var1, byte[] var2, int var3, int var4) throws WinsockNetBIOSException;

    public static native void waitForNetworkAddressChange();

    static {
        String dllName = "Win32NetBIOS";
        if (X64.isWindows64()) {
            dllName = "Win32NetBIOSx64";
        }
        try {
            System.loadLibrary(dllName);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            m_loadDLLException = ex;
        }
    }
}

