/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server;

import java.util.Vector;
import org.alfresco.filesys.server.NetworkServer;

public class NetworkServerList {
    private Vector<NetworkServer> m_servers = new Vector();

    public final int numberOfServers() {
        return this.m_servers.size();
    }

    public final void addServer(NetworkServer server) {
        this.m_servers.add(server);
    }

    public final NetworkServer getServer(int idx) {
        if (idx < 0 || idx >= this.m_servers.size()) {
            return null;
        }
        return this.m_servers.get(idx);
    }

    public final NetworkServer findServer(String name) {
        for (int i = 0; i < this.m_servers.size(); ++i) {
            NetworkServer server = this.m_servers.get(i);
            if (!server.getProtocolName().equals(name)) continue;
            return server;
        }
        return null;
    }

    public final NetworkServer removeServer(int idx) {
        if (idx < 0 || idx >= this.m_servers.size()) {
            return null;
        }
        NetworkServer server = this.m_servers.get(idx);
        this.m_servers.remove(idx);
        return server;
    }

    public final NetworkServer removeServer(String proto) {
        for (int i = 0; i < this.m_servers.size(); ++i) {
            NetworkServer server = this.m_servers.get(i);
            if (!server.getProtocolName().equals(proto)) continue;
            this.m_servers.remove(i);
            return server;
        }
        return null;
    }

    public final void removeAll() {
        this.m_servers.removeAllElements();
    }
}

