/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server;

import java.net.InetAddress;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.server.NetworkServer;
import org.alfresco.filesys.server.auth.AuthContext;
import org.alfresco.filesys.server.auth.ClientInfo;
import org.alfresco.filesys.server.core.SharedDevice;
import org.alfresco.filesys.server.core.SharedDeviceList;
import org.alfresco.service.transaction.TransactionService;

public abstract class SrvSession {
    private NetworkServer m_server;
    private int m_sessId;
    private String m_uniqueId;
    private int m_processId = -1;
    private boolean m_loggedOn;
    private ClientInfo m_clientInfo;
    private int m_debug;
    private String m_dbgPrefix;
    private boolean m_shutdown;
    private String m_protocol;
    private String m_remoteName;
    private Object m_authToken;
    private AuthContext m_authContext;
    private SharedDeviceList m_dynamicShares;
    private UserTransaction m_transaction;
    private boolean m_readOnlyTrans;
    protected int m_reqCount;
    protected int m_transCount;
    protected int m_transConvCount;

    public SrvSession(int sessId, NetworkServer srv, String proto, String remName) {
        this.m_sessId = sessId;
        this.m_server = srv;
        this.setProtocolName(proto);
        this.setRemoteName(remName);
    }

    public final void addDynamicShare(SharedDevice shrDev) {
        if (this.m_dynamicShares == null) {
            this.m_dynamicShares = new SharedDeviceList();
        }
        this.m_dynamicShares.addShare(shrDev);
    }

    public final Object getAuthenticationToken() {
        return this.m_authToken;
    }

    public final boolean hasAuthenticationToken() {
        return this.m_authToken != null;
    }

    public final int getProcessId() {
        return this.m_processId;
    }

    public abstract InetAddress getRemoteAddress();

    public final int getSessionId() {
        return this.m_sessId;
    }

    public final NetworkServer getServer() {
        return this.m_server;
    }

    public final boolean hasClientInformation() {
        return this.m_clientInfo != null;
    }

    public final ClientInfo getClientInformation() {
        return this.m_clientInfo;
    }

    public final boolean hasAuthenticationContext() {
        return this.m_authContext != null;
    }

    public final AuthContext getAuthenticationContext() {
        return this.m_authContext;
    }

    public final boolean hasDynamicShares() {
        return this.m_dynamicShares != null;
    }

    public final SharedDeviceList getDynamicShareList() {
        return this.m_dynamicShares;
    }

    public final boolean hasProtocolName() {
        return this.m_protocol != null;
    }

    public final String getProtocolName() {
        return this.m_protocol;
    }

    public final boolean hasRemoteName() {
        return this.m_remoteName != null;
    }

    public final String getRemoteName() {
        return this.m_remoteName;
    }

    public final boolean isLoggedOn() {
        return this.m_loggedOn;
    }

    public final boolean isShutdown() {
        return this.m_shutdown;
    }

    public final String getUniqueId() {
        return this.m_uniqueId;
    }

    public final boolean hasDebug(int dbgFlag) {
        return (this.m_debug & dbgFlag) != 0;
    }

    public final void setAuthenticationToken(Object authToken) {
        this.m_authToken = authToken;
    }

    public final void setAuthenticationContext(AuthContext ctx) {
        this.m_authContext = ctx;
    }

    public final void setClientInformation(ClientInfo client) {
        this.m_clientInfo = client;
    }

    public final void setDebug(int flgs) {
        this.m_debug = flgs;
    }

    public final void setDebugPrefix(String prefix) {
        this.m_dbgPrefix = prefix;
    }

    public final void setLoggedOn(boolean loggedOn) {
        this.m_loggedOn = loggedOn;
    }

    public final void setProcessId(int id) {
        this.m_processId = id;
    }

    public final void setProtocolName(String name) {
        this.m_protocol = name;
    }

    public final void setRemoteName(String name) {
        this.m_remoteName = name;
    }

    public final void setSessionId(int id) {
        this.m_sessId = id;
    }

    public final void setUniqueId(String unid) {
        this.m_uniqueId = unid;
    }

    protected final void setShutdown(boolean flg) {
        this.m_shutdown = flg;
    }

    public void closeSession() {
        if (this.hasDynamicShares()) {
            this.getServer().getShareMapper().deleteShares(this);
        }
    }

    public final boolean beginTransaction(TransactionService transService, boolean readOnly) throws AlfrescoRuntimeException {
        boolean created = false;
        if (this.m_transaction != null) {
            try {
                if (this.m_transaction.getStatus() == 1 || this.m_transaction.getStatus() == 4 || this.m_transaction.getStatus() == 9) {
                    this.m_transaction.rollback();
                }
            }
            catch (SystemException ex) {
                // empty catch block
            }
            if (!readOnly && this.m_readOnlyTrans) {
                try {
                    this.m_transaction.commit();
                    ++this.m_transConvCount;
                }
                catch (Exception ex) {
                    throw new AlfrescoRuntimeException("Failed to commit read-only transaction, " + ex.getMessage());
                }
                finally {
                    this.m_transaction = null;
                }
            }
        }
        if (this.m_transaction == null) {
            try {
                this.m_transaction = transService.getUserTransaction(readOnly);
                this.m_transaction.begin();
                created = true;
                this.m_readOnlyTrans = readOnly;
                ++this.m_transCount;
            }
            catch (Exception ex) {
                throw new AlfrescoRuntimeException("Failed to create transaction, " + ex.getMessage());
            }
        }
        return created;
    }

    public final void endTransaction() throws AlfrescoRuntimeException {
        if (this.m_transaction != null) {
            try {
                if (this.m_transaction.getStatus() == 1) {
                    this.m_transaction.rollback();
                } else {
                    this.m_transaction.commit();
                }
            }
            catch (Exception ex) {
                throw new AlfrescoRuntimeException("Failed to end transaction", (Throwable)ex);
            }
            finally {
                this.m_transaction = null;
            }
        }
    }

    public final boolean hasUserTransaction() {
        return this.m_transaction != null;
    }

    public final UserTransaction getUserTransaction() {
        UserTransaction trans = this.m_transaction;
        this.m_transaction = null;
        return trans;
    }
}

