/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.auth;

import java.security.NoSuchAlgorithmException;
import org.alfresco.filesys.server.SrvSession;
import org.alfresco.filesys.server.auth.CifsAuthenticator;
import org.alfresco.filesys.server.auth.ClientInfo;
import org.alfresco.filesys.server.auth.NTLanManAuthContext;
import org.alfresco.filesys.smb.server.SMBSrvSession;
import org.alfresco.repo.security.authentication.NTLMMode;

public class AlfrescoAuthenticator
extends CifsAuthenticator {
    protected boolean validateAuthenticationMode() {
        return this.m_authComponent.getNTLMMode() == NTLMMode.MD4_PROVIDER || this.m_authComponent.getNTLMMode() == NTLMMode.PASS_THROUGH;
    }

    public int authenticateUser(ClientInfo client, SrvSession sess, int alg) {
        if (client.isNullSession() && sess instanceof SMBSrvSession) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Null CIFS logon allowed");
            }
            return 0;
        }
        if (client.getAuthenticationToken() != null && client.getLogonType() != 2) {
            if (client.isGuest()) {
                this.m_authComponent.setGuestUserAsCurrentUser();
            } else {
                this.m_authComponent.setCurrentUser(client.getUserName());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Re-using existing authentication token");
            }
            return client.getLogonType() != 1 ? 0 : 0x10000000;
        }
        int authSts = -1;
        if (client.isGuest() || client.getUserName().equalsIgnoreCase("guest")) {
            if (!this.allowGuest()) {
                return -1;
            }
            this.doGuestLogon(client, sess);
            authSts = 0x10000000;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authenticated user " + client.getUserName() + " sts=" + this.getStatusAsString(authSts)));
            }
            return authSts;
        }
        if (this.m_authComponent.getNTLMMode() == NTLMMode.MD4_PROVIDER) {
            authSts = this.doMD4UserAuthentication(client, sess, alg);
        }
        if (authSts == 0x10000000) {
            if (this.mapUnknownUserToGuest()) {
                this.doGuestLogon(client, sess);
            } else {
                authSts = -1;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authenticated user " + client.getUserName() + " sts=" + this.getStatusAsString(authSts) + " via " + (this.m_authComponent.getNTLMMode() == NTLMMode.MD4_PROVIDER ? "MD4" : "Passthru")));
        }
        return authSts;
    }

    private final int doMD4UserAuthentication(ClientInfo client, SrvSession sess, int alg) {
        String md4hash = this.m_authComponent.getMD4HashedPassword(client.getUserName());
        if (md4hash != null) {
            if (client.getPassword() == null) {
                return -2;
            }
            try {
                byte[] p21 = new byte[21];
                byte[] md4byts = this.m_md4Encoder.decodeHash(md4hash);
                System.arraycopy(md4byts, 0, p21, 0, 16);
                NTLanManAuthContext authCtx = null;
                if (!sess.hasAuthenticationContext() || !(sess.getAuthenticationContext() instanceof NTLanManAuthContext)) {
                    return -1;
                }
                authCtx = (NTLanManAuthContext)sess.getAuthenticationContext();
                byte[] localHash = this.getEncryptor().doNTLM1Encryption(p21, authCtx.getChallenge());
                byte[] clientHash = client.getPassword();
                if (clientHash == null || clientHash.length != localHash.length) {
                    return -2;
                }
                for (int i = 0; i < clientHash.length; ++i) {
                    if (clientHash[i] == localHash[i]) continue;
                    return -2;
                }
                client.setAuthenticationToken(this.m_authComponent.setCurrentUser(client.getUserName()));
                this.getHomeFolderForUser(client);
                return 0;
            }
            catch (NoSuchAlgorithmException ex) {
                return -1;
            }
        }
        if (client.isNullSession() && sess instanceof SMBSrvSession) {
            return 0;
        }
        return this.allowGuest() ? 0x10000000 : -1;
    }
}

