/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.auth;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import javax.transaction.UserTransaction;
import net.sf.acegisecurity.Authentication;
import org.alfresco.config.ConfigElement;
import org.alfresco.filesys.server.SrvSession;
import org.alfresco.filesys.server.auth.AuthContext;
import org.alfresco.filesys.server.auth.AuthenticatorException;
import org.alfresco.filesys.server.auth.ClientInfo;
import org.alfresco.filesys.server.auth.NTLanManAuthContext;
import org.alfresco.filesys.server.auth.PasswordEncryptor;
import org.alfresco.filesys.server.config.InvalidConfigurationException;
import org.alfresco.filesys.server.config.ServerConfiguration;
import org.alfresco.filesys.server.core.SharedDevice;
import org.alfresco.filesys.server.filesys.DiskInterface;
import org.alfresco.filesys.server.filesys.DiskSharedDevice;
import org.alfresco.filesys.server.filesys.SrvDiskInfo;
import org.alfresco.filesys.smb.DialectSelector;
import org.alfresco.filesys.smb.server.SMBSrvException;
import org.alfresco.filesys.smb.server.SMBSrvPacket;
import org.alfresco.filesys.smb.server.SMBSrvSession;
import org.alfresco.filesys.smb.server.repo.ContentContext;
import org.alfresco.filesys.util.DataPacker;
import org.alfresco.filesys.util.HexDump;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.MD4PasswordEncoder;
import org.alfresco.repo.security.authentication.MD4PasswordEncoderImpl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CifsAuthenticator {
    protected static final Log logger = LogFactory.getLog((String)"org.alfresco.smb.protocol.auth");
    public static final int LANMAN = 0;
    public static final int NTLM1 = 1;
    public static final int NTLM2 = 2;
    public static final int AUTH_ALLOW = 0;
    public static final int AUTH_GUEST = 0x10000000;
    public static final int AUTH_DISALLOW = -1;
    public static final int AUTH_BADPASSWORD = -2;
    public static final int AUTH_BADUSER = -3;
    public static final int NoAccess = 0;
    public static final int ReadOnly = 1;
    public static final int Writeable = 2;
    public static final int STANDARD_PASSWORD_LEN = 24;
    public static final int STANDARD_CHALLENGE_LEN = 8;
    protected static final String GUEST_USERNAME = "guest";
    private DialectSelector m_dialects;
    private int m_securityMode = 3;
    private PasswordEncryptor m_encryptor = new PasswordEncryptor();
    private boolean m_allowGuest;
    private boolean m_mapToGuest;
    private String m_guestUserName = "guest";
    protected Random m_random = new Random(System.currentTimeMillis());
    protected ServerConfiguration m_config;
    protected AuthenticationComponent m_authComponent;
    protected MD4PasswordEncoder m_md4Encoder = new MD4PasswordEncoderImpl();
    protected NodeService m_nodeService;
    protected PersonService m_personService;
    protected TransactionService m_transactionService;
    protected AuthenticationService m_authenticationService;

    public int authenticateShareConnect(ClientInfo client, SharedDevice share, String sharePwd, SrvSession sess) {
        return 2;
    }

    public int authenticateUser(ClientInfo client, SrvSession sess, int alg) {
        return -1;
    }

    public void initialize(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        this.m_config = config;
        this.m_authComponent = this.m_config.getAuthenticationComponent();
        if (this.m_authComponent == null) {
            throw new InvalidConfigurationException("Authentication component not available");
        }
        this.m_dialects = new DialectSelector();
        this.m_dialects.AddDialect(2);
        this.m_dialects.AddDialect(4);
        this.m_dialects.AddDialect(3);
        this.m_dialects.AddDialect(5);
        this.m_dialects.AddDialect(6);
        this.m_dialects.AddDialect(7);
        this.m_nodeService = config.getNodeService();
        this.m_personService = config.getPersonService();
        this.m_transactionService = config.getTransactionService();
        this.m_authenticationService = config.getAuthenticationService();
        this.setGuestUserName(this.m_authComponent.getGuestUserName());
        if (!this.validateAuthenticationMode()) {
            throw new InvalidConfigurationException("Required authentication mode not available");
        }
    }

    protected boolean validateAuthenticationMode() {
        return true;
    }

    protected final byte[] generateEncryptedPassword(String plainPwd, byte[] encryptKey, int alg, String userName, String domain) {
        byte[] encPwd = null;
        try {
            encPwd = this.m_encryptor.generateEncryptedPassword(plainPwd, encryptKey, alg, userName, domain);
        }
        catch (NoSuchAlgorithmException ex) {
        }
        catch (InvalidKeyException ex) {
            // empty catch block
        }
        return encPwd;
    }

    public AuthContext getAuthContext(SMBSrvSession sess) {
        NTLanManAuthContext authCtx = null;
        if (sess.hasAuthenticationContext() && sess.getAuthenticationContext() instanceof NTLanManAuthContext) {
            authCtx = (NTLanManAuthContext)sess.getAuthenticationContext();
        } else {
            authCtx = new NTLanManAuthContext();
            sess.setAuthenticationContext(authCtx);
        }
        return authCtx;
    }

    public final DialectSelector getEnabledDialects() {
        return this.m_dialects;
    }

    public final int getSecurityMode() {
        return this.m_securityMode;
    }

    public void generateNegotiateResponse(SMBSrvSession sess, SMBSrvPacket respPkt, boolean extendedSecurity) throws AuthenticatorException {
        String domain;
        NTLanManAuthContext authCtx = (NTLanManAuthContext)this.getAuthContext(sess);
        int pos = respPkt.getByteOffset();
        byte[] buf = respPkt.getBuffer();
        if (authCtx.getChallenge() == null) {
            for (int i = 0; i < 8; ++i) {
                buf[pos++] = 0;
            }
        } else {
            byte[] key = authCtx.getChallenge();
            for (int i = 0; i < key.length; ++i) {
                buf[pos++] = key[i];
            }
        }
        if ((domain = sess.getServer().getConfiguration().getDomainName()) != null) {
            pos = DataPacker.putString(domain, buf, pos, true, true);
        }
        pos = DataPacker.putString(sess.getServer().getServerName(), buf, pos, true, true);
        respPkt.setByteCount(pos - respPkt.getByteOffset());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void processSessionSetup(SMBSrvSession sess, SMBSrvPacket reqPkt, SMBSrvPacket respPkt) throws SMBSrvException {
        boolean isGuest;
        ClientInfo client;
        boolean isUni;
        byte[] buf;
        block17: {
            String user;
            block18: {
                int sts;
                block16: {
                    if (!reqPkt.checkPacketIsValid(13, 0)) {
                        throw new SMBSrvException(-1073741811, 1, 2);
                    }
                    int maxBufSize = reqPkt.getParameter(2);
                    int maxMpx = reqPkt.getParameter(3);
                    int vcNum = reqPkt.getParameter(4);
                    int ascPwdLen = reqPkt.getParameter(7);
                    int uniPwdLen = reqPkt.getParameter(8);
                    int capabs = reqPkt.getParameterLong(11);
                    buf = reqPkt.getBuffer();
                    isUni = reqPkt.isUnicode();
                    byte[] ascPwd = reqPkt.unpackBytes(ascPwdLen);
                    byte[] uniPwd = reqPkt.unpackBytes(uniPwdLen);
                    user = reqPkt.unpackString(isUni);
                    if (user == null) {
                        throw new SMBSrvException(-1073741811, 1, 2);
                    }
                    String domain = "";
                    if (reqPkt.hasMoreData() && (domain = reqPkt.unpackString(isUni)) == null) {
                        throw new SMBSrvException(-1073741811, 1, 2);
                    }
                    String clientOS = "";
                    if (reqPkt.hasMoreData() && (clientOS = reqPkt.unpackString(isUni)) == null) {
                        throw new SMBSrvException(-1073741811, 1, 2);
                    }
                    if (logger.isDebugEnabled() && sess.hasDebug(4)) {
                        logger.debug((Object)("NT Session setup from user=" + user + ", password=" + (uniPwd != null ? HexDump.hexString(uniPwd) : "none") + ", ANSIpwd=" + (ascPwd != null ? HexDump.hexString(ascPwd) : "none") + ", domain=" + domain + ", os=" + clientOS + ", VC=" + vcNum + ", maxBuf=" + maxBufSize + ", maxMpx=" + maxMpx + ", authCtx=" + sess.getAuthenticationContext()));
                        logger.debug((Object)("  MID=" + reqPkt.getMultiplexId() + ", UID=" + reqPkt.getUserId() + ", PID=" + reqPkt.getProcessId()));
                    }
                    sess.setClientMaximumBufferSize(maxBufSize);
                    sess.setClientMaximumMultiplex(maxMpx);
                    sess.setClientCapabilities(capabs);
                    client = new ClientInfo(user, uniPwd);
                    client.setANSIPassword(ascPwd);
                    client.setDomain(domain);
                    client.setOperatingSystem(clientOS);
                    if (sess.hasRemoteAddress()) {
                        client.setClientAddress(sess.getRemoteAddress().getHostAddress());
                    }
                    if (user.length() == 0 && domain.length() == 0 && uniPwdLen == 0 && ascPwdLen == 1) {
                        client.setLogonType(2);
                    }
                    isGuest = false;
                    sts = this.authenticateUser(client, sess, 1);
                    if (sts <= 0 || (sts & 0x10000000) == 0) break block16;
                    isGuest = true;
                    if (logger.isDebugEnabled() && sess.hasDebug(4)) {
                        logger.debug((Object)("User " + user + ", logged on as guest"));
                    }
                    break block17;
                }
                if (sts == 0) break block18;
                if (sess.getClientInformation() != null && client.getUserName().length() == 0) {
                    client = sess.getClientInformation();
                    if (logger.isDebugEnabled() && sess.hasDebug(4)) {
                        logger.debug((Object)("Null client information, reusing existing client=" + client));
                    }
                    break block17;
                } else {
                    if (logger.isDebugEnabled() && sess.hasDebug(4)) {
                        logger.debug((Object)("User " + user + ", access denied"));
                    }
                    throw new SMBSrvException(-1073741715, 5, 1);
                }
            }
            if (logger.isDebugEnabled() && sess.hasDebug(4)) {
                logger.debug((Object)("User " + user + " logged on " + (client != null ? " (type " + client.getLogonTypeString() + ")" : "")));
            }
        }
        if (sess.getClientInformation() == null || sess.getClientInformation().getUserName().length() == 0) {
            sess.setClientInformation(client);
        }
        client.setGuest(isGuest);
        sess.setLoggedOn(true);
        respPkt.setParameterCount(3);
        respPkt.setParameter(0, 0);
        respPkt.setParameter(1, 0);
        respPkt.setParameter(2, isGuest ? 1 : 0);
        respPkt.setByteCount(0);
        respPkt.setTreeId(0);
        respPkt.setUserId(0);
        int flags = respPkt.getFlags();
        respPkt.setFlags(flags &= 0xFFFFFFF7);
        int flags2 = 1;
        if (isUni) {
            flags2 += 32768;
        }
        respPkt.setFlags2(flags2);
        int pos = respPkt.getByteOffset();
        buf = respPkt.getBuffer();
        if (isUni) {
            pos = DataPacker.wordAlign(pos);
        }
        pos = DataPacker.putString("Java", buf, pos, true, isUni);
        pos = DataPacker.putString("Alfresco CIFS Server " + sess.getServer().isVersion(), buf, pos, true, isUni);
        pos = DataPacker.putString(sess.getServer().getConfiguration().getDomainName(), buf, pos, true, isUni);
        respPkt.setByteCount(pos - respPkt.getByteOffset());
    }

    public int getEncryptionKeyLength() {
        return 8;
    }

    public int getServerCapabilities() {
        return 49788;
    }

    public final boolean allowGuest() {
        return this.m_allowGuest;
    }

    public final String getGuestUserName() {
        return this.m_guestUserName;
    }

    public final boolean mapUnknownUserToGuest() {
        return this.m_mapToGuest;
    }

    public final void setAllowGuest(boolean ena) {
        this.m_allowGuest = ena;
    }

    public final void setGuestUserName(String guest) {
        this.m_guestUserName = guest;
    }

    public final void setMapToGuest(boolean ena) {
        this.m_mapToGuest = ena;
    }

    protected final void setSecurityMode(int flg) {
        this.m_securityMode = flg;
    }

    public void closeAuthenticator() {
    }

    protected final boolean validatePassword(String plainPwd, byte[] encryptedPwd, byte[] encryptKey, int alg, String userName, String domain) {
        byte[] encPwd = this.generateEncryptedPassword(plainPwd != null ? plainPwd : "", encryptKey, alg, userName, domain);
        if (encPwd != null && encryptedPwd != null && encPwd.length == 24 && encryptedPwd.length == 24) {
            for (int i = 0; i < 24; ++i) {
                if (encPwd[i] == encryptedPwd[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected final byte[] convertPassword(String pwd) {
        StringBuffer p14str = new StringBuffer();
        p14str.append(pwd);
        if (p14str.length() > 14) {
            p14str.setLength(14);
        } else {
            while (p14str.length() < 14) {
                p14str.append('\u0000');
            }
        }
        return p14str.toString().getBytes();
    }

    protected final PasswordEncryptor getEncryptor() {
        return this.m_encryptor;
    }

    protected final String getStatusAsString(int sts) {
        String str = null;
        switch (sts) {
            case 0: {
                str = "Allow";
                break;
            }
            case -1: {
                str = "Disallow";
                break;
            }
            case 0x10000000: {
                str = "Guest";
                break;
            }
            case -2: {
                str = "BadPassword";
                break;
            }
            case -3: {
                str = "BadUser";
            }
        }
        return str;
    }

    protected final void doGuestLogon(ClientInfo client, SrvSession sess) {
        this.m_authenticationService.authenticateAsGuest();
        Authentication authToken = this.m_authComponent.getCurrentAuthentication();
        client.setAuthenticationToken(authToken);
        client.setUserName(this.getGuestUserName());
        this.getHomeFolderForUser(client);
        client.setGuest(true);
        DiskInterface diskDrv = this.m_config.getDiskInterface();
        ContentContext diskCtx = new ContentContext("", "", client.getHomeFolder());
        diskCtx.setDiskInformation(new SrvDiskInfo(2560, 64, 512, 2304));
        sess.addDynamicShare(new DiskSharedDevice(client.getUserName(), diskDrv, diskCtx, 8));
    }

    protected final void getHomeFolderForUser(ClientInfo client) {
        UserTransaction tx = this.m_transactionService.getUserTransaction();
        NodeRef homeSpaceRef = null;
        try {
            tx.begin();
            homeSpaceRef = (NodeRef)this.m_nodeService.getProperty(this.m_personService.getPerson(client.getUserName()), ContentModel.PROP_HOMEFOLDER);
            client.setHomeFolder(homeSpaceRef);
            tx.commit();
        }
        catch (Throwable ex) {
            try {
                tx.rollback();
            }
            catch (Throwable ex2) {
                logger.error((Object)"Failed to rollback transaction", ex2);
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException("Error during execution of transaction.", ex);
        }
    }
}

