/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.auth;

import net.sf.acegisecurity.Authentication;
import org.alfresco.service.cmr.repository.NodeRef;

public class ClientInfo {
    public static final int LogonNormal = 0;
    public static final int LogonGuest = 1;
    public static final int LogonNull = 2;
    public static final int LogonAdmin = 3;
    private static final String[] _logonTypStr = new String[]{"Normal", "Guest", "Null", "Administrator"};
    private String m_user;
    private byte[] m_password;
    private byte[] m_ansiPwd;
    private int m_logonType;
    private String m_domain;
    private String m_opsys;
    private String m_ipAddr;
    private Authentication m_authToken;
    private NodeRef m_homeNode;

    public ClientInfo() {
        this.setUserName("");
    }

    public ClientInfo(String user, byte[] pwd) {
        this.setUserName(user);
        this.setPassword(pwd);
    }

    public final String getDomain() {
        return this.m_domain;
    }

    public final String getOperatingSystem() {
        return this.m_opsys;
    }

    public final byte[] getPassword() {
        return this.m_password;
    }

    public final String getPasswordAsString() {
        if (this.m_password != null) {
            return new String(this.m_password);
        }
        return null;
    }

    public final char[] getPasswordAsCharArray() {
        char[] cpwd = null;
        if (this.m_password != null) {
            String pwd = new String(this.m_password);
            cpwd = new char[pwd.length()];
            pwd.getChars(0, pwd.length(), cpwd, 0);
        }
        return cpwd;
    }

    public final boolean hasANSIPassword() {
        return this.m_ansiPwd != null;
    }

    public final byte[] getANSIPassword() {
        return this.m_ansiPwd;
    }

    public final String getANSIPasswordAsString() {
        if (this.m_ansiPwd != null) {
            return new String(this.m_ansiPwd);
        }
        return null;
    }

    public final String getUserName() {
        return this.m_user;
    }

    public final int getLogonType() {
        return this.m_logonType;
    }

    public final String getLogonTypeString() {
        return _logonTypStr[this.m_logonType];
    }

    public final boolean isGuest() {
        return this.m_logonType == 1;
    }

    public final boolean isNullSession() {
        return this.m_logonType == 2;
    }

    public final boolean isAdministrator() {
        return this.m_logonType == 3;
    }

    public final boolean hasClientAddress() {
        return this.m_ipAddr != null;
    }

    public final String getClientAddress() {
        return this.m_ipAddr;
    }

    public final boolean hasAuthenticationToken() {
        return this.m_authToken != null;
    }

    public final Authentication getAuthenticationToken() {
        return this.m_authToken;
    }

    public final boolean hasHomeFolder() {
        return this.m_homeNode != null;
    }

    public final NodeRef getHomeFolder() {
        return this.m_homeNode;
    }

    public final void setDomain(String domain) {
        this.m_domain = domain;
    }

    public final void setOperatingSystem(String opsys) {
        this.m_opsys = opsys;
    }

    public final void setPassword(byte[] pwd) {
        this.m_password = pwd;
    }

    public final void setANSIPassword(byte[] pwd) {
        this.m_ansiPwd = pwd;
    }

    public final void setPassword(String pwd) {
        this.m_password = (byte[])(pwd != null ? pwd.getBytes() : null);
    }

    public final void setUserName(String user) {
        this.m_user = user;
    }

    public final void setLogonType(int logonType) {
        this.m_logonType = logonType;
    }

    public final void setGuest(boolean guest) {
        this.setLogonType(guest ? 1 : 0);
    }

    public final void setClientAddress(String addr) {
        this.m_ipAddr = addr;
    }

    public final void setAuthenticationToken(Authentication token) {
        this.m_authToken = token;
    }

    public final void setHomeFolder(NodeRef homeNode) {
        this.m_homeNode = homeNode;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getUserName());
        str.append(":");
        str.append(this.getPassword());
        str.append(",");
        str.append(this.getDomain());
        str.append(",");
        str.append(this.getOperatingSystem());
        if (this.hasClientAddress()) {
            str.append(",");
            str.append(this.getClientAddress());
        }
        if (this.hasAuthenticationToken()) {
            str.append(",token=");
            str.append(this.getAuthenticationToken());
        }
        if (this.isGuest()) {
            str.append(",Guest");
        }
        str.append("]");
        return str.toString();
    }
}

