/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.auth;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.UUID;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.RealmCallback;
import org.alfresco.config.ConfigElement;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.server.auth.AuthenticatorException;
import org.alfresco.filesys.server.auth.CifsAuthenticator;
import org.alfresco.filesys.server.auth.ClientInfo;
import org.alfresco.filesys.server.auth.NTLanManAuthContext;
import org.alfresco.filesys.server.auth.kerberos.KerberosDetails;
import org.alfresco.filesys.server.auth.kerberos.SessionSetupPrivilegedAction;
import org.alfresco.filesys.server.auth.ntlm.NTLMMessage;
import org.alfresco.filesys.server.auth.ntlm.NTLMv2Blob;
import org.alfresco.filesys.server.auth.ntlm.TargetInfo;
import org.alfresco.filesys.server.auth.ntlm.Type1NTLMMessage;
import org.alfresco.filesys.server.auth.ntlm.Type2NTLMMessage;
import org.alfresco.filesys.server.auth.ntlm.Type3NTLMMessage;
import org.alfresco.filesys.server.auth.spnego.NegTokenInit;
import org.alfresco.filesys.server.auth.spnego.NegTokenTarg;
import org.alfresco.filesys.server.auth.spnego.OID;
import org.alfresco.filesys.server.auth.spnego.SPNEGO;
import org.alfresco.filesys.server.config.InvalidConfigurationException;
import org.alfresco.filesys.server.config.ServerConfiguration;
import org.alfresco.filesys.smb.server.SMBSrvException;
import org.alfresco.filesys.smb.server.SMBSrvPacket;
import org.alfresco.filesys.smb.server.SMBSrvSession;
import org.alfresco.filesys.util.DataPacker;
import org.alfresco.filesys.util.HexDump;
import org.alfresco.repo.security.authentication.NTLMMode;
import org.ietf.jgss.Oid;

public class EnterpriseCifsAuthenticator
extends CifsAuthenticator
implements CallbackHandler {
    private static final String LoginConfigEntry = "AlfrescoCIFS";
    private static final int NTLM_FLAGS = -1610087807;
    private boolean m_useRawNTLMSSP;
    private boolean m_acceptNTLMv1;
    private String m_accountName;
    private String m_password;
    private String m_krbRealm;
    private String m_krbKDC;
    private String m_loginEntryName = "AlfrescoCIFS";
    private LoginContext m_loginContext;
    private byte[] m_negTokenInit;

    public void initialize(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        super.initialize(config, params);
        ConfigElement kdcAddress = params.getChild("KDC");
        if (kdcAddress != null && kdcAddress.getValue() != null && kdcAddress.getValue().length() > 0) {
            this.m_krbKDC = kdcAddress.getValue();
            ConfigElement krbRealm = params.getChild("Realm");
            if (krbRealm == null || krbRealm.getValue() == null || krbRealm.getValue().length() <= 0) {
                throw new InvalidConfigurationException("Kerberos realm not specified");
            }
            this.m_krbRealm = krbRealm.getValue();
            ConfigElement srvPassword = params.getChild("Password");
            if (srvPassword == null || srvPassword.getValue() == null || srvPassword.getValue().length() <= 0) {
                throw new InvalidConfigurationException("CIFS service account password not specified");
            }
            this.m_password = srvPassword.getValue();
            ConfigElement loginEntry = params.getChild("LoginEntry");
            if (loginEntry != null) {
                if (loginEntry.getValue() != null && loginEntry.getValue().length() > 0) {
                    this.m_loginEntryName = loginEntry.getValue();
                } else {
                    throw new InvalidConfigurationException("Invalid login entry specified");
                }
            }
            StringBuilder cifsAccount = new StringBuilder();
            cifsAccount.append("cifs/");
            cifsAccount.append(config.getServerName().toLowerCase());
            cifsAccount.append("@");
            cifsAccount.append(this.m_krbRealm);
            this.m_accountName = cifsAccount.toString();
            try {
                this.m_loginContext = new LoginContext(this.m_loginEntryName, this);
                this.m_loginContext.login();
            }
            catch (LoginException ex) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)"CIFS Kerberos authenticator error", (Throwable)ex);
                }
                throw new InvalidConfigurationException("Failed to login CIFS server service");
            }
            Vector<Oid> mechTypes = new Vector<Oid>();
            mechTypes.add(OID.NTLMSSP);
            mechTypes.add(OID.KERBEROS5);
            mechTypes.add(OID.MSKERBEROS5);
            try {
                String mecListMIC = null;
                StringBuilder mic = new StringBuilder();
                mic.append(config.getServerName().toLowerCase());
                mic.append("$@");
                mic.append(this.m_krbRealm);
                mecListMIC = mic.toString();
                NegTokenInit negTokenInit = new NegTokenInit(mechTypes, mecListMIC);
                this.m_negTokenInit = negTokenInit.encode();
            }
            catch (IOException ex) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)"Error creating SPNEGO NegTokenInit blob", (Throwable)ex);
                }
                throw new InvalidConfigurationException("Failed to create SPNEGO NegTokenInit blob");
            }
            this.m_useRawNTLMSSP = false;
        } else {
            ConfigElement useSpnego = params.getChild("useSPNEGO");
            if (useSpnego != null) {
                Vector<Oid> mechTypes = new Vector<Oid>();
                mechTypes.add(OID.NTLMSSP);
                try {
                    NegTokenInit negTokenInit = new NegTokenInit(mechTypes, null);
                    this.m_negTokenInit = negTokenInit.encode();
                }
                catch (IOException ex) {
                    if (logger.isErrorEnabled()) {
                        logger.error((Object)"Error creating SPNEGO NegTokenInit blob", (Throwable)ex);
                    }
                    throw new InvalidConfigurationException("Failed to create SPNEGO NegTokenInit blob");
                }
                this.m_useRawNTLMSSP = false;
            } else {
                this.m_useRawNTLMSSP = true;
            }
        }
        ConfigElement disallowNTLMv1 = params.getChild("disallowNTLMv1");
        boolean bl = this.m_acceptNTLMv1 = disallowNTLMv1 == null;
        if (!this.isKerberosEnabled() && this.m_authComponent.getNTLMMode() != NTLMMode.MD4_PROVIDER) {
            logger.error((Object)"No valid CIFS authentication combination available");
            logger.error((Object)"Either enable Kerberos support or use an authentication component that supports MD4 hashed passwords");
            throw new AlfrescoRuntimeException("Invalid CIFS authenticator configuration");
        }
    }

    private final boolean isKerberosEnabled() {
        return this.m_krbKDC != null && this.m_loginContext != null;
    }

    private final boolean useRawNTLMSSP() {
        return this.m_useRawNTLMSSP;
    }

    private final boolean acceptNTLMv1Logon() {
        return this.m_acceptNTLMv1;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            Callback cb;
            if (callbacks[i] instanceof NameCallback) {
                cb = (NameCallback)callbacks[i];
                ((NameCallback)cb).setName(this.m_accountName);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                cb = (PasswordCallback)callbacks[i];
                ((PasswordCallback)cb).setPassword(this.m_password.toCharArray());
                continue;
            }
            if (callbacks[i] instanceof RealmCallback) {
                cb = (RealmCallback)callbacks[i];
                ((TextInputCallback)cb).setText(this.m_krbRealm);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i]);
        }
    }

    public int getEncryptionKeyLength() {
        return 8;
    }

    public int getServerCapabilities() {
        return -2147433860;
    }

    public void generateNegotiateResponse(SMBSrvSession sess, SMBSrvPacket respPkt, boolean extendedSecurity) throws AuthenticatorException {
        if (!extendedSecurity) {
            super.generateNegotiateResponse(sess, respPkt, extendedSecurity);
            return;
        }
        if ((respPkt.getFlags2() & 0x800) == 0) {
            respPkt.setFlags2(respPkt.getFlags2() + 2048);
        }
        int pos = respPkt.getByteOffset();
        byte[] buf = respPkt.getBuffer();
        UUID serverGUID = sess.getSMBServer().getServerGUID();
        DataPacker.putIntelLong(serverGUID.getLeastSignificantBits(), buf, pos);
        DataPacker.putIntelLong(serverGUID.getMostSignificantBits(), buf, pos + 8);
        pos += 16;
        if (!this.useRawNTLMSSP()) {
            System.arraycopy(this.m_negTokenInit, 0, buf, pos, this.m_negTokenInit.length);
            pos += this.m_negTokenInit.length;
        }
        respPkt.setByteCount(pos - respPkt.getByteOffset());
    }

    public void processSessionSetup(SMBSrvSession sess, SMBSrvPacket reqPkt, SMBSrvPacket respPkt) throws SMBSrvException {
        int respLen;
        if (!reqPkt.checkPacketIsValid(12, 0)) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        if (reqPkt.getParameterCount() == 13) {
            try {
                this.doHashedPasswordLogon(sess, reqPkt, respPkt);
                return;
            }
            catch (SMBSrvException ex) {
                sess.setSetupObject(null);
                throw ex;
            }
        }
        int maxBufSize = reqPkt.getParameter(2);
        int maxMpx = reqPkt.getParameter(3);
        int secBlobLen = reqPkt.getParameter(7);
        int capabs = reqPkt.getParameterLong(10);
        int dataPos = reqPkt.getByteOffset();
        byte[] buf = reqPkt.getBuffer();
        boolean isUni = reqPkt.isUnicode();
        int secBlobPos = dataPos;
        reqPkt.setPosition(dataPos += secBlobLen);
        String domain = "";
        if (reqPkt.hasMoreData() && (domain = reqPkt.unpackString(isUni)) == null) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        String clientOS = "";
        if (reqPkt.hasMoreData() && (clientOS = reqPkt.unpackString(isUni)) == null) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("NT Session setup " + (this.useRawNTLMSSP() ? "NTLMSSP" : "SPNEGO") + ", MID=" + reqPkt.getMultiplexId() + ", UID=" + reqPkt.getUserId() + ", PID=" + reqPkt.getProcessId()));
        }
        sess.setClientMaximumBufferSize(maxBufSize);
        sess.setClientMaximumMultiplex(maxMpx);
        sess.setClientCapabilities(capabs);
        ClientInfo client = new ClientInfo();
        client.setDomain(domain);
        client.setOperatingSystem(clientOS);
        client.setLogonType(0);
        if (sess.hasRemoteAddress()) {
            client.setClientAddress(sess.getRemoteAddress().getHostAddress());
        }
        Object setupObj = sess.getSetupObject();
        byte[] respBlob = null;
        try {
            respBlob = this.useRawNTLMSSP() ? this.doNtlmsspSessionSetup(sess, client, buf, secBlobPos, secBlobLen, isUni) : this.doSpnegoSessionSetup(sess, client, buf, secBlobPos, secBlobLen, isUni);
        }
        catch (SMBSrvException ex) {
            sess.setSetupObject(null);
            throw ex;
        }
        if (logger.isDebugEnabled() && sess.hasDebug(4)) {
            logger.debug((Object)("User " + client.getUserName() + " logged on " + (client != null ? " (type " + client.getLogonTypeString() + ")" : "")));
        }
        if (sess.getClientInformation() == null || sess.getClientInformation().getUserName().length() == 0) {
            sess.setClientInformation(client);
        }
        int n = respLen = respBlob != null ? respBlob.length : 0;
        if (this.useRawNTLMSSP() || sess.hasSetupObject() || setupObj != null) {
            if (sess.hasSetupObject()) {
                respPkt.setLongErrorCode(-1073741802);
            } else {
                respPkt.setLongErrorCode(0);
            }
            respPkt.setParameterCount(4);
            respPkt.setParameter(0, 255);
            respPkt.setParameter(1, 0);
            respPkt.setParameter(2, 0);
            respPkt.setParameter(3, respLen);
        } else {
            respPkt.setLongErrorCode(0);
            respPkt.setParameterCount(12);
            respPkt.setParameter(0, 255);
            respPkt.setParameter(1, 0);
            respPkt.setParameter(2, 65540);
            respPkt.setParameter(3, 4);
            respPkt.setParameter(4, 0);
            respPkt.setParameterLong(5, 0);
            respPkt.setParameter(7, respLen);
            respPkt.setParameterLong(8, 0);
            respPkt.setParameterLong(10, this.getServerCapabilities());
        }
        respPkt.setCommand(reqPkt.getCommand());
        respPkt.setByteCount(0);
        respPkt.setTreeId(0);
        respPkt.setUserId(0);
        int flags = respPkt.getFlags();
        respPkt.setFlags(flags &= 0xFFFFFFF7);
        int flags2 = 18433;
        if (isUni) {
            flags2 += 32768;
        }
        respPkt.setFlags2(flags2);
        int pos = respPkt.getByteOffset();
        buf = respPkt.getBuffer();
        if (respBlob != null) {
            System.arraycopy(respBlob, 0, buf, pos, respBlob.length);
            pos += respBlob.length;
        }
        if (isUni) {
            pos = DataPacker.wordAlign(pos);
        }
        pos = DataPacker.putString("Java", buf, pos, true, isUni);
        pos = DataPacker.putString("Alfresco CIFS Server " + sess.getServer().isVersion(), buf, pos, true, isUni);
        pos = DataPacker.putString(sess.getServer().getConfiguration().getDomainName(), buf, pos, true, isUni);
        respPkt.setByteCount(pos - respPkt.getByteOffset());
    }

    private final byte[] doNtlmsspSessionSetup(SMBSrvSession sess, ClientInfo client, byte[] secbuf, int secpos, int seclen, boolean unicode) throws SMBSrvException {
        int msgType = NTLMMessage.isNTLMType(secbuf, secpos);
        byte[] respBlob = null;
        if (msgType == -1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Invalid NTLMSSP token received");
                logger.debug((Object)("  Token=" + HexDump.hexString(secbuf, secpos, seclen, " ")));
            }
            throw new SMBSrvException(-1073741715, 5, 1);
        }
        if (msgType == 1) {
            Type1NTLMMessage type1Msg = new Type1NTLMMessage(secbuf, secpos, seclen);
            int ntlmFlags = type1Msg.getFlags() & 0xA0080281;
            NTLanManAuthContext ntlmCtx = new NTLanManAuthContext();
            String domain = sess.getSMBServer().getServerName();
            ArrayList<TargetInfo> tList = new ArrayList<TargetInfo>();
            tList.add(new TargetInfo(2, domain));
            tList.add(new TargetInfo(1, sess.getServerName()));
            tList.add(new TargetInfo(4, domain));
            tList.add(new TargetInfo(3, domain));
            ntlmFlags = 1619657221;
            if (this.acceptNTLMv1Logon()) {
                ntlmFlags -= Integer.MIN_VALUE;
            }
            Type2NTLMMessage type2Msg = new Type2NTLMMessage();
            type2Msg.buildType2(ntlmFlags, domain, ntlmCtx.getChallenge(), null, tList);
            sess.setSetupObject(type2Msg);
            respBlob = type2Msg.getBytes();
        } else if (msgType == 3) {
            Type3NTLMMessage type3Msg = new Type3NTLMMessage(secbuf, secpos, seclen, unicode);
            if (!sess.hasSetupObject() || !(sess.getSetupObject() instanceof Type2NTLMMessage)) {
                sess.setSetupObject(null);
                throw new SMBSrvException(-1073741715, 5, 1);
            }
            if (type3Msg.hasFlag(0x20000000) && type3Msg.hasFlag(524288)) {
                if (type3Msg.getNTLMHashLength() > 24) {
                    this.doNTLMv2Logon(sess, client, type3Msg);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Logged on using NTLMSSP/NTLMv2");
                    }
                } else {
                    this.doNTLMv2SessionKeyLogon(sess, client, type3Msg);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Logged on using NTLMSSP/NTLMv2SessKey");
                    }
                }
            } else {
                this.doNTLMv1Logon(sess, client, type3Msg);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Logged on using NTLMSSP/NTLMv1");
                }
            }
        }
        return respBlob;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final byte[] doSpnegoSessionSetup(SMBSrvSession sess, ClientInfo client, byte[] secbuf, int secpos, int seclen, boolean unicode) throws SMBSrvException {
        Object negToken;
        int tokType = -1;
        try {
            tokType = SPNEGO.checkTokenType(secbuf, secpos, seclen);
        }
        catch (IOException ex) {
            // empty catch block
        }
        NegTokenTarg negTarg = null;
        if (tokType == 1 && sess.hasSetupObject() && sess.getSetupObject() instanceof Type2NTLMMessage) {
            negToken = new NegTokenTarg();
            try {
                ((NegTokenTarg)negToken).decode(secbuf, secpos, seclen);
            }
            catch (IOException ex) {
                logger.error((Object)ex);
                throw new SMBSrvException(-1073741715, 5, 1);
            }
            byte[] ntlmsspBlob = ((NegTokenTarg)negToken).getResponseToken();
            byte[] ntlmsspRespBlob = this.doNtlmsspSessionSetup(sess, client, ntlmsspBlob, 0, ntlmsspBlob.length, unicode);
            int spnegoSts = 0;
            if (sess.hasSetupObject()) {
                spnegoSts = 1;
            }
            negTarg = new NegTokenTarg(spnegoSts, null, ntlmsspRespBlob);
        } else {
            if (tokType != 0) {
                logger.error((Object)"Unknown SPNEGO token type");
                throw new SMBSrvException(-1073741715, 5, 1);
            }
            negToken = new NegTokenInit();
            try {
                ((NegTokenInit)negToken).decode(secbuf, secpos, seclen);
            }
            catch (IOException ex) {
                logger.error((Object)ex);
                throw new SMBSrvException(-1073741715, 5, 1);
            }
            String oidStr = null;
            if (((NegTokenInit)negToken).numberOfOids() > 0) {
                oidStr = ((NegTokenInit)negToken).getOidAt(0).toString();
            }
            if (oidStr != null && oidStr.equals("1.3.6.1.4.1.311.2.2.10")) {
                byte[] ntlmsspBlob = ((NegTokenInit)negToken).getMechtoken();
                byte[] ntlmsspRespBlob = this.doNtlmsspSessionSetup(sess, client, ntlmsspBlob, 0, ntlmsspBlob.length, unicode);
                int spnegoSts = 0;
                if (sess.hasSetupObject()) {
                    spnegoSts = 1;
                }
                negTarg = new NegTokenTarg(spnegoSts, OID.NTLMSSP, ntlmsspRespBlob);
            } else if (oidStr != null && (oidStr.equals("1.2.840.48018.1.2.2") || oidStr.equals("1.2.840.113554.1.2.2"))) {
                negTarg = this.doKerberosLogon(sess, (NegTokenInit)negToken, client);
            } else {
                if (!logger.isDebugEnabled()) throw new SMBSrvException(-1073741715, 5, 1);
                logger.debug((Object)"No matching authentication OID found");
                logger.debug((Object)("  " + ((NegTokenInit)negToken).toString()));
                throw new SMBSrvException(-1073741715, 5, 1);
            }
        }
        byte[] respBlob = null;
        try {
            return negTarg.encode();
        }
        catch (IOException ex) {
            if (!logger.isDebugEnabled()) throw new SMBSrvException(-1073741715, 5, 1);
            logger.debug((Object)"Failed to encode NegTokenTarg", (Throwable)ex);
            throw new SMBSrvException(-1073741715, 5, 1);
        }
    }

    private final NegTokenTarg doKerberosLogon(SMBSrvSession sess, NegTokenInit negToken, ClientInfo client) throws SMBSrvException {
        KerberosDetails krbDetails = null;
        NegTokenTarg negTokenTarg = null;
        try {
            SessionSetupPrivilegedAction sessSetupAction = new SessionSetupPrivilegedAction(this.m_accountName, negToken.getMechtoken());
            Object result = Subject.doAs(this.m_loginContext.getSubject(), sessSetupAction);
            if (result != null) {
                krbDetails = (KerberosDetails)result;
                negTokenTarg = new NegTokenTarg(0, OID.KERBEROS5, krbDetails.getResponseToken());
                this.m_authComponent.setCurrentUser(krbDetails.getUserName());
                client.setUserName(krbDetails.getSourceName());
                client.setGuest(false);
                sess.setLoggedOn(true);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Logged on using Kerberos");
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw new SMBSrvException(-1073741715, 5, 1);
        }
        return negTokenTarg;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void doNTLMv1Logon(SMBSrvSession sess, ClientInfo client, Type3NTLMMessage type3Msg) throws SMBSrvException {
        if (!this.acceptNTLMv1Logon()) {
            logger.warn((Object)("NTLMv1 not accepted, client " + sess.getRemoteName()));
            throw new SMBSrvException(-1073741715, 5, 1);
        }
        Type2NTLMMessage type2Msg = (Type2NTLMMessage)sess.getSetupObject();
        sess.setSetupObject(null);
        if (this.m_authComponent.getNTLMMode() != NTLMMode.MD4_PROVIDER) {
            logger.warn((Object)"Authentication component does not support MD4 password hashes");
            throw new SMBSrvException(-1073741715, 5, 1);
        }
        String userName = type3Msg.getUserName();
        if (userName.length() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Null logon");
            }
            client.setLogonType(2);
            return;
        }
        String md4hash = this.m_authComponent.getMD4HashedPassword(userName);
        if (md4hash == null) {
            logger.warn((Object)("User does not exist, " + userName));
            throw new SMBSrvException(-1073741715, 5, 1);
        }
        byte[] p21 = new byte[21];
        byte[] md4byts = this.m_md4Encoder.decodeHash(md4hash);
        System.arraycopy(md4byts, 0, p21, 0, 16);
        byte[] localHash = null;
        try {
            localHash = this.getEncryptor().doNTLM1Encryption(p21, type2Msg.getChallenge());
        }
        catch (NoSuchAlgorithmException ex) {
            // empty catch block
        }
        byte[] clientHash = type3Msg.getNTLMHash();
        if (clientHash != null && localHash != null && clientHash.length == localHash.length) {
            int i;
            for (i = 0; i < clientHash.length && clientHash[i] == localHash[i]; ++i) {
            }
            if (i != clientHash.length) {
                throw new SMBSrvException(-1073741715, 5, 1);
            }
        }
        this.m_authComponent.setCurrentUser(userName);
        client.setUserName(userName.toLowerCase());
        client.setGuest(false);
        sess.setLoggedOn(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void doNTLMv1Logon(SMBSrvSession sess, ClientInfo client) throws SMBSrvException {
        if (!this.acceptNTLMv1Logon()) {
            logger.warn((Object)("NTLMv1 not accepted, client " + sess.getRemoteName()));
            throw new SMBSrvException(-1073741715, 5, 1);
        }
        if (this.m_authComponent.getNTLMMode() != NTLMMode.MD4_PROVIDER) {
            logger.warn((Object)"Authentication component does not support MD4 password hashes");
            throw new SMBSrvException(-1073741715, 5, 1);
        }
        if (client.getUserName().length() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Null logon");
            }
            client.setLogonType(2);
            return;
        }
        String md4hash = this.m_authComponent.getMD4HashedPassword(client.getUserName());
        if (md4hash == null) {
            logger.warn((Object)("User does not exist, " + client.getUserName()));
            throw new SMBSrvException(-1073741715, 5, 1);
        }
        byte[] p21 = new byte[21];
        byte[] md4byts = this.m_md4Encoder.decodeHash(md4hash);
        System.arraycopy(md4byts, 0, p21, 0, 16);
        byte[] challenge = null;
        if (sess.hasAuthenticationContext()) {
            NTLanManAuthContext ntlmCtx = (NTLanManAuthContext)sess.getAuthenticationContext();
            challenge = ntlmCtx.getChallenge();
        }
        byte[] localHash = null;
        try {
            localHash = this.getEncryptor().doNTLM1Encryption(p21, challenge);
        }
        catch (NoSuchAlgorithmException ex) {
            // empty catch block
        }
        byte[] clientHash = client.getPassword();
        if (clientHash != null && localHash != null && clientHash.length == localHash.length) {
            int i;
            for (i = 0; i < clientHash.length && clientHash[i] == localHash[i]; ++i) {
            }
            if (i != clientHash.length) {
                throw new SMBSrvException(-1073741715, 5, 1);
            }
        }
        this.m_authComponent.setCurrentUser(client.getUserName());
        client.setGuest(false);
        sess.setLoggedOn(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void doNTLMv2Logon(SMBSrvSession sess, ClientInfo client, Type3NTLMMessage type3Msg) throws SMBSrvException {
        Type2NTLMMessage type2Msg = (Type2NTLMMessage)sess.getSetupObject();
        sess.setSetupObject(null);
        if (this.m_authComponent.getNTLMMode() != NTLMMode.MD4_PROVIDER) {
            logger.warn((Object)"Authentication component does not support MD4 password hashes");
            throw new SMBSrvException(-1073741715, 5, 1);
        }
        String userName = type3Msg.getUserName();
        if (userName.length() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Null logon");
            }
            client.setLogonType(2);
            return;
        }
        String md4hash = this.m_authComponent.getMD4HashedPassword(userName);
        if (md4hash == null) {
            logger.warn((Object)("User does not exist, " + userName));
            throw new SMBSrvException(-1073741715, 5, 1);
        }
        try {
            byte[] v2hash = this.getEncryptor().doNTLM2Encryption(this.m_md4Encoder.decodeHash(md4hash), type3Msg.getUserName(), type3Msg.getDomain());
            NTLMv2Blob v2blob = new NTLMv2Blob(type3Msg.getNTLMHash());
            byte[] srvChallenge = type2Msg.getChallenge();
            byte[] srvHmac = v2blob.calculateHMAC(srvChallenge, v2hash);
            byte[] clientHmac = v2blob.getHMAC();
            if (clientHmac != null && srvHmac != null && clientHmac.length == srvHmac.length) {
                int i;
                for (i = 0; i < clientHmac.length && clientHmac[i] == srvHmac[i]; ++i) {
                }
                if (i != clientHmac.length) {
                    throw new SMBSrvException(-1073741715, 5, 1);
                }
            }
            this.m_authComponent.setCurrentUser(userName);
            client.setUserName(userName.toLowerCase());
            client.setGuest(false);
            sess.setLoggedOn(true);
            return;
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw new SMBSrvException(-1073741715, 5, 1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void doNTLMv2Logon(SMBSrvSession sess, ClientInfo client) throws SMBSrvException {
        if (this.m_authComponent.getNTLMMode() != NTLMMode.MD4_PROVIDER) {
            logger.warn((Object)"Authentication component does not support MD4 password hashes");
            throw new SMBSrvException(-1073741715, 5, 1);
        }
        if (client.getUserName().length() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Null logon");
            }
            client.setLogonType(2);
            return;
        }
        String md4hash = this.m_authComponent.getMD4HashedPassword(client.getUserName());
        if (md4hash == null) {
            logger.warn((Object)("User does not exist, " + client.getUserName()));
            throw new SMBSrvException(-1073741715, 5, 1);
        }
        try {
            NTLMv2Blob v2blob = new NTLMv2Blob(client.getPassword());
            byte[] v2hash = this.getEncryptor().doNTLM2Encryption(this.m_md4Encoder.decodeHash(md4hash), client.getUserName(), client.getDomain());
            byte[] srvChallenge = null;
            if (sess.hasAuthenticationContext()) {
                NTLanManAuthContext ntlmCtx = (NTLanManAuthContext)sess.getAuthenticationContext();
                srvChallenge = ntlmCtx.getChallenge();
            }
            byte[] srvHmac = v2blob.calculateHMAC(srvChallenge, v2hash);
            byte[] clientHmac = v2blob.getHMAC();
            if (clientHmac != null && srvHmac != null && clientHmac.length == srvHmac.length) {
                int i;
                for (i = 0; i < clientHmac.length && clientHmac[i] == srvHmac[i]; ++i) {
                }
                if (i != clientHmac.length) {
                    throw new SMBSrvException(-1073741715, 5, 1);
                }
            }
            this.m_authComponent.setCurrentUser(client.getUserName());
            client.setGuest(false);
            sess.setLoggedOn(true);
            return;
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw new SMBSrvException(-1073741715, 5, 1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void doNTLMv2SessionKeyLogon(SMBSrvSession sess, ClientInfo client, Type3NTLMMessage type3Msg) throws SMBSrvException {
        Type2NTLMMessage type2Msg = (Type2NTLMMessage)sess.getSetupObject();
        sess.setSetupObject(null);
        if (this.m_authComponent.getNTLMMode() != NTLMMode.MD4_PROVIDER) {
            logger.warn((Object)"Authentication component does not support MD4 password hashes");
            throw new SMBSrvException(-1073741715, 5, 1);
        }
        String userName = type3Msg.getUserName();
        if (userName.length() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Null logon");
            }
            client.setLogonType(2);
            return;
        }
        String md4hash = this.m_authComponent.getMD4HashedPassword(userName);
        if (md4hash == null) {
            logger.warn((Object)("User does not exist, " + userName));
            throw new SMBSrvException(-1073741715, 5, 1);
        }
        byte[] nonce = new byte[16];
        System.arraycopy(type2Msg.getChallenge(), 0, nonce, 0, 8);
        System.arraycopy(type3Msg.getLMHash(), 0, nonce, 8, 8);
        MessageDigest md5 = null;
        byte[] v2challenge = new byte[8];
        try {
            md5 = MessageDigest.getInstance("MD5");
            md5.update(nonce);
            byte[] md5nonce = md5.digest();
            System.arraycopy(md5nonce, 0, v2challenge, 0, 8);
        }
        catch (NoSuchAlgorithmException ex) {
            logger.error((Object)ex);
        }
        byte[] p21 = new byte[21];
        byte[] md4byts = this.m_md4Encoder.decodeHash(md4hash);
        System.arraycopy(md4byts, 0, p21, 0, 16);
        byte[] localHash = null;
        try {
            localHash = this.getEncryptor().doNTLM1Encryption(p21, v2challenge);
        }
        catch (NoSuchAlgorithmException ex) {
            logger.error((Object)ex);
        }
        byte[] clientHash = type3Msg.getNTLMHash();
        if (clientHash != null && localHash != null && clientHash.length == localHash.length) {
            int i;
            for (i = 0; i < clientHash.length && clientHash[i] == localHash[i]; ++i) {
            }
            if (i != clientHash.length) {
                throw new SMBSrvException(-1073741715, 5, 1);
            }
        }
        this.m_authComponent.setCurrentUser(userName);
        client.setUserName(userName.toLowerCase());
        client.setGuest(false);
        sess.setLoggedOn(true);
    }

    private final void doHashedPasswordLogon(SMBSrvSession sess, SMBSrvPacket reqPkt, SMBSrvPacket respPkt) throws SMBSrvException {
        if (!reqPkt.checkPacketIsValid(13, 0)) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        int maxBufSize = reqPkt.getParameter(2);
        int maxMpx = reqPkt.getParameter(3);
        int vcNum = reqPkt.getParameter(4);
        int ascPwdLen = reqPkt.getParameter(7);
        int uniPwdLen = reqPkt.getParameter(8);
        int capabs = reqPkt.getParameterLong(11);
        byte[] buf = reqPkt.getBuffer();
        boolean isUni = reqPkt.isUnicode();
        byte[] ascPwd = reqPkt.unpackBytes(ascPwdLen);
        byte[] uniPwd = reqPkt.unpackBytes(uniPwdLen);
        String user = reqPkt.unpackString(isUni);
        if (user == null) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        String domain = "";
        if (reqPkt.hasMoreData() && (domain = reqPkt.unpackString(isUni)) == null) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        String clientOS = "";
        if (reqPkt.hasMoreData() && (clientOS = reqPkt.unpackString(isUni)) == null) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        if (logger.isDebugEnabled() && sess.hasDebug(4)) {
            logger.debug((Object)("NT Session setup from user=" + user + ", password=" + (uniPwd != null ? HexDump.hexString(uniPwd) : "none") + ", ANSIpwd=" + (ascPwd != null ? HexDump.hexString(ascPwd) : "none") + ", domain=" + domain + ", os=" + clientOS + ", VC=" + vcNum + ", maxBuf=" + maxBufSize + ", maxMpx=" + maxMpx + ", authCtx=" + sess.getAuthenticationContext()));
            logger.debug((Object)("  MID=" + reqPkt.getMultiplexId() + ", UID=" + reqPkt.getUserId() + ", PID=" + reqPkt.getProcessId()));
        }
        sess.setClientMaximumBufferSize(maxBufSize);
        sess.setClientMaximumMultiplex(maxMpx);
        sess.setClientCapabilities(capabs);
        ClientInfo client = new ClientInfo(user, uniPwd);
        client.setANSIPassword(ascPwd);
        client.setDomain(domain);
        client.setOperatingSystem(clientOS);
        if (sess.hasRemoteAddress()) {
            client.setClientAddress(sess.getRemoteAddress().getHostAddress());
        }
        if (user.length() == 0 && domain.length() == 0 && uniPwdLen == 0) {
            client.setLogonType(2);
        }
        boolean isGuest = false;
        if (uniPwd != null) {
            if (uniPwd.length == 24) {
                this.doNTLMv1Logon(sess, client);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Logged on using Hashed/NTLMv1");
                }
            } else if (uniPwd.length > 0) {
                this.doNTLMv2Logon(sess, client);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Logged on using Hashed/NTLMv2");
                }
            }
        }
        if (client.isGuest()) {
            isGuest = true;
            if (logger.isDebugEnabled() && sess.hasDebug(4)) {
                logger.debug((Object)("User " + user + ", logged on as guest"));
            }
        }
        if (sess.getClientInformation() == null || sess.getClientInformation().getUserName().length() == 0) {
            sess.setClientInformation(client);
        }
        client.setGuest(isGuest);
        sess.setLoggedOn(true);
        respPkt.setParameterCount(3);
        respPkt.setParameter(0, 0);
        respPkt.setParameter(1, 0);
        respPkt.setParameter(2, isGuest ? 1 : 0);
        respPkt.setByteCount(0);
        respPkt.setTreeId(0);
        respPkt.setUserId(0);
        int flags = respPkt.getFlags();
        respPkt.setFlags(flags &= 0xFFFFFFF7);
        int flags2 = 1;
        if (isUni) {
            flags2 += 32768;
        }
        respPkt.setFlags2(flags2);
        int pos = respPkt.getByteOffset();
        buf = respPkt.getBuffer();
        if (isUni) {
            pos = DataPacker.wordAlign(pos);
        }
        pos = DataPacker.putString("Java", buf, pos, true, isUni);
        pos = DataPacker.putString("Alfresco CIFS Server " + sess.getServer().isVersion(), buf, pos, true, isUni);
        pos = DataPacker.putString(sess.getServer().getConfiguration().getDomainName(), buf, pos, true, isUni);
        respPkt.setByteCount(pos - respPkt.getByteOffset());
    }
}

