/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.auth.acl;

import org.alfresco.config.ConfigElement;
import org.alfresco.filesys.server.auth.acl.ACLParseException;
import org.alfresco.filesys.server.auth.acl.AccessControl;

public abstract class AccessControlParser {
    public static final String ParameterAccess = "access";
    private static final String[] _accessTypes = new String[]{"None", "Read", "Write"};

    public abstract String getType();

    public abstract AccessControl createAccessControl(ConfigElement var1) throws ACLParseException;

    protected final int parseAccessType(ConfigElement params) throws ACLParseException {
        if (params == null) {
            throw new ACLParseException("Empty parameter list");
        }
        String accessType = params.getAttribute(ParameterAccess);
        if (accessType == null || accessType.length() == 0) {
            throw new ACLParseException("Required parameter 'access' missing");
        }
        return AccessControlParser.parseAccessTypeString(accessType);
    }

    public static final int parseAccessTypeString(String accessType) throws ACLParseException {
        if (accessType == null || accessType.length() == 0) {
            throw new ACLParseException("Empty access type string");
        }
        int access = -1;
        for (int i = 0; i < _accessTypes.length; ++i) {
            if (!accessType.equalsIgnoreCase(_accessTypes[i])) continue;
            access = i;
        }
        if (access == -1) {
            throw new ACLParseException("Invalid access type, " + accessType);
        }
        return access;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getType());
        str.append("]");
        return str.toString();
    }
}

