/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.auth.acl;

import java.util.Enumeration;
import org.alfresco.config.ConfigElement;
import org.alfresco.filesys.server.SrvSession;
import org.alfresco.filesys.server.auth.acl.ACLParseException;
import org.alfresco.filesys.server.auth.acl.AccessControl;
import org.alfresco.filesys.server.auth.acl.AccessControlFactory;
import org.alfresco.filesys.server.auth.acl.AccessControlList;
import org.alfresco.filesys.server.auth.acl.AccessControlManager;
import org.alfresco.filesys.server.auth.acl.AccessControlParser;
import org.alfresco.filesys.server.auth.acl.DomainAccessControlParser;
import org.alfresco.filesys.server.auth.acl.InvalidACLTypeException;
import org.alfresco.filesys.server.auth.acl.IpAddressAccessControlParser;
import org.alfresco.filesys.server.auth.acl.ProtocolAccessControlParser;
import org.alfresco.filesys.server.auth.acl.UserAccessControlParser;
import org.alfresco.filesys.server.config.ServerConfiguration;
import org.alfresco.filesys.server.core.SharedDevice;
import org.alfresco.filesys.server.core.SharedDeviceList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultAccessControlManager
implements AccessControlManager {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.smb.protocol");
    private AccessControlFactory m_factory = new AccessControlFactory();
    private boolean m_debug;

    public int checkAccessControl(SrvSession sess, SharedDevice share) {
        if (!share.hasAccessControls()) {
            if (logger.isDebugEnabled() && this.hasDebug()) {
                logger.debug((Object)("Check access control for " + share.getName() + ", no ACLs"));
            }
            return 2;
        }
        AccessControlList acls = share.getAccessControls();
        int access = -1;
        if (logger.isDebugEnabled() && this.hasDebug()) {
            logger.debug((Object)("Check access control for " + share.getName() + ", ACLs=" + acls.numberOfControls()));
        }
        for (int i = 0; i < acls.numberOfControls(); ++i) {
            AccessControl acl = acls.getControlAt(i);
            int curAccess = acl.allowsAccess(sess, share, this);
            if (logger.isDebugEnabled() && this.hasDebug()) {
                logger.debug((Object)("  Check access ACL=" + acl + ", access=" + AccessControl.asAccessString(curAccess)));
            }
            if (curAccess == -1) continue;
            access = curAccess;
        }
        if (access == -1) {
            access = acls.getDefaultAccessLevel();
            if (logger.isDebugEnabled() && this.hasDebug()) {
                logger.debug((Object)("Access defaulted=" + AccessControl.asAccessString(access) + ", share=" + share));
            }
        } else if (logger.isDebugEnabled() && this.hasDebug()) {
            logger.debug((Object)("Access allowed=" + AccessControl.asAccessString(access) + ", share=" + share));
        }
        return access;
    }

    public SharedDeviceList filterShareList(SrvSession sess, SharedDeviceList shares) {
        if (shares == null || shares.numberOfShares() == 0) {
            return shares;
        }
        if (logger.isDebugEnabled() && this.hasDebug()) {
            logger.debug((Object)("Filter share list for " + sess + ", shares=" + shares));
        }
        SharedDeviceList filterList = new SharedDeviceList();
        Enumeration<SharedDevice> enm = shares.enumerateShares();
        while (enm.hasMoreElements()) {
            SharedDevice share = enm.nextElement();
            if (share.hasAccessControls()) {
                int access = this.checkAccessControl(sess, share);
                if (access == 0) continue;
                filterList.addShare(share);
                continue;
            }
            filterList.addShare(share);
        }
        if (logger.isDebugEnabled() && this.hasDebug()) {
            logger.debug((Object)("Filtered share list " + filterList));
        }
        return filterList;
    }

    public void initialize(ServerConfiguration config, ConfigElement params) {
        if (params != null && params.getChild("debug") != null) {
            this.setDebug(true);
        }
        this.addAccessControlType(new UserAccessControlParser());
        this.addAccessControlType(new ProtocolAccessControlParser());
        this.addAccessControlType(new DomainAccessControlParser());
        this.addAccessControlType(new IpAddressAccessControlParser());
    }

    public AccessControl createAccessControl(String type, ConfigElement params) throws ACLParseException, InvalidACLTypeException {
        return this.m_factory.createAccessControl(type, params);
    }

    public void addAccessControlType(AccessControlParser parser) {
        if (logger.isDebugEnabled() && this.hasDebug()) {
            logger.debug((Object)("AccessControlManager Add rule type " + parser.getType()));
        }
        this.m_factory.addParser(parser);
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final void setDebug(boolean dbg) {
        this.m_debug = dbg;
    }
}

