/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.auth.acl;

import org.alfresco.config.ConfigElement;
import org.alfresco.filesys.server.auth.acl.ACLParseException;
import org.alfresco.filesys.server.auth.acl.AccessControl;
import org.alfresco.filesys.server.auth.acl.AccessControlParser;
import org.alfresco.filesys.server.auth.acl.IpAddressAccessControl;
import org.alfresco.filesys.util.IPAddress;

public class IpAddressAccessControlParser
extends AccessControlParser {
    public String getType() {
        return "address";
    }

    public AccessControl createAccessControl(ConfigElement params) throws ACLParseException {
        int access = this.parseAccessType(params);
        String ipAddr = params.getAttribute("ip");
        if (ipAddr != null) {
            if (ipAddr.length() == 0 || !IPAddress.isNumericAddress(ipAddr)) {
                throw new ACLParseException("Invalid IP address, " + ipAddr);
            }
            if (params.getAttributeCount() != 2) {
                throw new ACLParseException("Invalid parameter(s) specified for address");
            }
            return new IpAddressAccessControl(ipAddr, null, this.getType(), access);
        }
        String subnet = params.getAttribute("subnet");
        if (subnet != null) {
            String netmask = params.getAttribute("mask");
            if (subnet.length() == 0 || netmask == null || netmask.length() == 0) {
                throw new ACLParseException("Invalid subnet/mask parameter");
            }
            if (!IPAddress.isNumericAddress(subnet)) {
                throw new ACLParseException("Invalid subnet parameter, " + subnet);
            }
            if (!IPAddress.isNumericAddress(netmask)) {
                throw new ACLParseException("Invalid mask parameter, " + netmask);
            }
            return new IpAddressAccessControl(subnet, netmask, this.getType(), access);
        }
        throw new ACLParseException("Unknown address parameter(s)");
    }
}

