/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.auth.acl;

import org.alfresco.config.ConfigElement;
import org.alfresco.filesys.server.auth.acl.ACLParseException;
import org.alfresco.filesys.server.auth.acl.AccessControl;
import org.alfresco.filesys.server.auth.acl.AccessControlParser;
import org.alfresco.filesys.server.auth.acl.ProtocolAccessControl;

public class ProtocolAccessControlParser
extends AccessControlParser {
    public String getType() {
        return "protocol";
    }

    public AccessControl createAccessControl(ConfigElement params) throws ACLParseException {
        int access = this.parseAccessType(params);
        String protos = params.getAttribute("type");
        if (protos == null || protos.length() == 0) {
            throw new ACLParseException("Protocol type not specified");
        }
        if (!ProtocolAccessControl.validateProtocolList(protos)) {
            throw new ACLParseException("Invalid protocol type");
        }
        return new ProtocolAccessControl(protos, this.getType(), access);
    }
}

