/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.auth.kerberos;

import java.security.PrivilegedAction;
import org.alfresco.filesys.server.auth.kerberos.KerberosDetails;
import org.alfresco.filesys.server.auth.spnego.OID;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;

public class SessionSetupPrivilegedAction
implements PrivilegedAction {
    private byte[] m_secBlob;
    private int m_secOffset;
    private int m_secLen;
    private String m_accountName;

    public SessionSetupPrivilegedAction(String accountName, byte[] secBlob) {
        this.m_accountName = accountName;
        this.m_secBlob = secBlob;
        this.m_secOffset = 0;
        this.m_secLen = secBlob.length;
    }

    public SessionSetupPrivilegedAction(String accountName, byte[] secBlob, int secOffset, int secLen) {
        this.m_accountName = accountName;
        this.m_secBlob = secBlob;
        this.m_secOffset = secOffset;
        this.m_secLen = secLen;
    }

    public Object run() {
        KerberosDetails krbDetails = null;
        try {
            GSSManager gssManager = GSSManager.getInstance();
            GSSName serverGSSName = gssManager.createName(this.m_accountName, GSSName.NT_USER_NAME);
            GSSCredential serverGSSCreds = gssManager.createCredential(serverGSSName, Integer.MAX_VALUE, OID.KERBEROS5, 2);
            GSSContext serverGSSContext = gssManager.createContext(serverGSSCreds);
            byte[] respBlob = serverGSSContext.acceptSecContext(this.m_secBlob, this.m_secOffset, this.m_secLen);
            krbDetails = new KerberosDetails(serverGSSContext.getSrcName(), serverGSSContext.getTargName(), respBlob);
        }
        catch (GSSException ex) {
            System.out.println("GSSException: " + ex.getMajorString());
            System.out.println("  " + ex.getMessage());
        }
        return krbDetails;
    }
}

