/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.server.auth.ntlm;

import java.io.UnsupportedEncodingException;
import org.alfresco.filesys.server.auth.ntlm.NTLM;
import org.alfresco.filesys.util.DataPacker;

public abstract class NTLMMessage {
    private static final int DefaultBlobSize = 256;
    public static final int OffsetSignature = 0;
    public static final int OffsetType = 8;
    public static final int BufferHeaderLen = 8;
    private byte[] m_buf;
    private int m_offset;
    private int m_len;

    protected NTLMMessage() {
        this.m_buf = new byte[256];
        this.m_len = 256;
    }

    protected NTLMMessage(byte[] buf, int offset, int len) {
        this.m_buf = buf;
        this.m_offset = offset;
        this.m_len = len;
    }

    public final int isMessageType() {
        return DataPacker.getIntelInt(this.m_buf, this.m_offset + 8);
    }

    public abstract int getFlags();

    public final boolean hasFlag(int flag) {
        return (this.getFlags() & flag) != 0;
    }

    public int getLength() {
        return this.m_len;
    }

    public final void setMessageType(int typ) {
        DataPacker.putIntelInt(typ, this.m_buf, this.m_offset + 8);
    }

    public final void copyFrom(byte[] buf, int offset, int len) {
        if (this.m_buf == null || this.m_offset != 0 || this.m_buf.length < len) {
            this.m_buf = new byte[len];
        }
        System.arraycopy(buf, offset, this.m_buf, 0, len);
    }

    public final byte[] getBytes() {
        byte[] byts = new byte[this.getLength()];
        System.arraycopy(this.m_buf, this.m_offset, byts, 0, this.getLength());
        return byts;
    }

    protected abstract void setFlags(int var1);

    protected void initializeHeader(int typ, int flags) {
        System.arraycopy(NTLM.Signature, 0, this.m_buf, this.m_offset, NTLM.Signature.length);
        this.setMessageType(typ);
        this.setFlags(flags);
    }

    protected final int getShortValue(int offset) {
        return DataPacker.getIntelShort(this.m_buf, this.m_offset + offset);
    }

    protected final int getIntValue(int offset) {
        return DataPacker.getIntelInt(this.m_buf, this.m_offset + offset);
    }

    protected final int getByteOffset(int offset) {
        return this.getIntValue(offset + 4);
    }

    protected final byte[] getByteValue(int offset) {
        int bLen = this.getShortValue(offset);
        if (bLen == 0) {
            return null;
        }
        int bOff = this.getIntValue(offset + 4);
        return this.getRawBytes(bOff, bLen);
    }

    protected final byte[] getRawBytes(int offset, int len) {
        byte[] byts = new byte[len];
        System.arraycopy(this.m_buf, this.m_offset + offset, byts, 0, len);
        return byts;
    }

    protected final int getStringLength(int offset) {
        int bufpos = this.m_offset + offset;
        if (bufpos + 2 > this.m_len) {
            return -1;
        }
        return DataPacker.getIntelShort(this.m_buf, bufpos);
    }

    protected final int getStringAllocatedLength(int offset) {
        int bufpos = this.m_offset + offset;
        if (bufpos + 8 > this.m_len) {
            return -1;
        }
        return DataPacker.getIntelShort(this.m_buf, bufpos + 2);
    }

    protected final int getStringOffset(int offset) {
        int bufpos = this.m_offset + offset;
        if (bufpos + 8 > this.m_len) {
            return -1;
        }
        return DataPacker.getIntelInt(this.m_buf, bufpos + 4);
    }

    protected final String getStringValue(int offset, boolean isuni) {
        int bufpos = this.m_offset + offset;
        if (offset + 8 > this.m_len) {
            return null;
        }
        int len = DataPacker.getIntelShort(this.m_buf, bufpos);
        int pos = DataPacker.getIntelInt(this.m_buf, bufpos + 4);
        if (pos + len > this.m_len) {
            return null;
        }
        String str = null;
        try {
            str = new String(this.m_buf, this.m_offset + pos, len, isuni ? "UnicodeLittle" : "US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        return str;
    }

    protected final String getRawString(int offset, int len, boolean isuni) {
        return DataPacker.getString(this.m_buf, this.m_offset + offset, len, isuni);
    }

    protected final void setShortValue(int offset, int sval) {
        DataPacker.putIntelShort(sval, this.m_buf, this.m_offset + offset);
    }

    protected final void setIntValue(int offset, int val) {
        DataPacker.putIntelInt(val, this.m_buf, this.m_offset + offset);
    }

    protected final void setRawBytes(int offset, byte[] byts) {
        System.arraycopy(byts, 0, this.m_buf, this.m_offset + offset, byts.length);
    }

    protected final void setRawInts(int offset, int[] ints) {
        int bufpos = this.m_offset + offset;
        for (int i = 0; i < ints.length; ++i) {
            DataPacker.putIntelInt(ints[i], this.m_buf, bufpos);
            bufpos += 4;
        }
    }

    protected final int setRawString(int offset, String str, boolean isuni) {
        return DataPacker.putString(str, this.m_buf, this.m_offset + offset, false, isuni);
    }

    protected final void zeroBytes(int offset, int len) {
        int bufpos = this.m_offset + offset;
        for (int i = 0; i < len; ++i) {
            this.m_buf[bufpos++] = 0;
        }
    }

    protected final int setByteValue(int offset, byte[] byts, int dataOffset) {
        int bytsLen;
        int n = bytsLen = byts != null ? byts.length : 0;
        if (this.m_offset + offset + 12 > this.m_buf.length || this.m_offset + dataOffset + bytsLen > this.m_buf.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        DataPacker.putIntelShort(bytsLen, this.m_buf, this.m_offset + offset);
        DataPacker.putIntelShort(bytsLen, this.m_buf, this.m_offset + offset + 2);
        DataPacker.putIntelInt(dataOffset, this.m_buf, this.m_offset + offset + 4);
        if (bytsLen > 0) {
            System.arraycopy(byts, 0, this.m_buf, this.m_offset + dataOffset, bytsLen);
        }
        return dataOffset + DataPacker.wordAlign(bytsLen);
    }

    protected final int setStringValue(int offset, String val, int strOffset, boolean isuni) {
        int len = val.length();
        if (isuni) {
            len *= 2;
        }
        if (this.m_offset + offset + 8 > this.m_buf.length || this.m_offset + strOffset + len > this.m_buf.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        DataPacker.putIntelShort(len, this.m_buf, this.m_offset + offset);
        DataPacker.putIntelShort(len, this.m_buf, this.m_offset + offset + 2);
        DataPacker.putIntelInt(strOffset, this.m_buf, this.m_offset + offset + 4);
        return DataPacker.putString(val, this.m_buf, this.m_offset + strOffset, false, isuni) - this.m_offset;
    }

    protected final void setLength(int len) {
        this.m_len = len;
    }

    public static final int isNTLMType(byte[] buf) {
        return NTLMMessage.isNTLMType(buf, 0);
    }

    public static final int isNTLMType(byte[] buf, int offset) {
        if (buf == null || buf.length < 8) {
            return -1;
        }
        for (int i = 0; i < NTLM.Signature.length; ++i) {
            if (buf[offset + i] == NTLM.Signature[i]) continue;
            return -1;
        }
        return DataPacker.getIntelInt(buf, offset + 8);
    }
}

